﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;
using Mall.Model.Extend.Finance;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 财务配置仓储层
    /// </summary>
    public class RB_Finance_ConfigurineRepository : RepositoryBase<RB_Finance_Configurine>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Finance_Configurine_Extend> GetList(RB_Finance_Configurine_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Finance_Configurine.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Finance_Configurine.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Finance_Configurine.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Finance_Configurine.Type)}={dmodel.Type}";
            }

            string sql = $@"SELECT * FROM RB_Finance_Configurine where {where} order by Id asc";
            return Get<RB_Finance_Configurine_Extend>(sql).ToList();
        }
    }
}
