﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Extend.Finance;
using Mall.Model.Entity.Finance;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 财务流程仓储层
    /// </summary>
    public class Rb_Workflow_TemplateRepository : RepositoryBase<Rb_Workflow_Template>
    {

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(Rb_Workflow_Template); } }

        /// <summary>
        /// 获取模板列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<Rb_Workflow_Template_Extend> GetList(Rb_Workflow_Template_Extend model)
        {
            string where = " WHERE 1=1 ";
            if (model.Status > 0) //状态==0的时候查询停用和正常的
            {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.Status) + "={0}", (int)model.Status);
            }
            else
            {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.Status) + "!={0}", 3);
            }
            if (model.Id > 0)
            {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.Id) + "={0}", model.Id);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.Type) + "={0}", (int)model.Type);
            }
            if (model.RB_GroupId > 0)
            {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.RB_GroupId) + "={0}", model.RB_GroupId);
            }
            if (model.RB_BranchId >= 0)
            {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.RB_BranchId) + "={0}", model.RB_BranchId);
            }
            if (model.TemplateType.HasValue && model.TemplateType.Value > 0)
            {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.TemplateType) + "={0}", (int)model.TemplateType);
            }
            if (!string.IsNullOrEmpty(model.TemplateIds))
            {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.Id) + " in ({0})", model.TemplateIds);
            }
            if (model.TemplateSorce > 0)
            {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.TemplateSorce) + "={0}", model.TemplateSorce);
            }
            if (model.TempLateClass > 0) {
                where += string.Format(" AND " + nameof(Rb_Workflow_Template.TempLateClass) + "={0}", (int)model.TempLateClass);
            }

            string sql = string.Format(" SELECT * FROM {0} {1}", TableName, where);
            return Get<Rb_Workflow_Template_Extend>(sql).ToList();
        }


        /// <summary>
        /// 获取自定义模板
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="model"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<Rb_Workflow_Template_Extend> GetPageList(int pageIndex, int pageSize, Rb_Workflow_Template_Extend model, out long count)
        {
            string where = "1=1";
            where += string.Format(" AND A." + nameof(Rb_Workflow_Template.Status) + "!=3");
            if (model.TemplateType > 0)
            {
                where += string.Format(" AND A." + nameof(Rb_Workflow_Template.TemplateType) + "={0}", (int)model.TemplateType);
            }
            if (model.RB_GroupId > 0)
            {
                where += string.Format(" AND A." + nameof(Rb_Workflow_Template.RB_GroupId) + "={0}", model.RB_GroupId);
            }
            if (model.RB_BranchId >= 0)
            {
                where += string.Format(" AND A." + nameof(Rb_Workflow_Template.RB_BranchId) + "={0}", model.RB_BranchId);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND A." + nameof(Rb_Workflow_Template.Type) + "={0}", (int)model.Type);
            }
            if (!string.IsNullOrEmpty(model.TemplateIds))
            {
                where += string.Format(" AND A." + nameof(Rb_Workflow_Template.TemplateType) + " in({0}) ", model.TemplateIds);
            }
            if (!string.IsNullOrWhiteSpace(model.Name))
            {
                where += string.Format(" AND A." + nameof(Rb_Workflow_Template.Name) + " like '%{0}%'", model.Name);
            }
            if (model.TemplateSorce > 0)
            {
                where += string.Format(" AND A." + nameof(Rb_Workflow_Template.TemplateSorce) + "={0}", model.TemplateSorce);
            }
            string sql = string.Format(" select * from {0} as A where {1}", TableName, where);
            return GetPage<Rb_Workflow_Template_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
