﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Product;

namespace Mall.WebApi.Controllers.Finance
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class FinanceController : BaseController
    {
        private readonly FinanceModule financeModule = new FinanceModule();

        #region 财务配置
        
        /// <summary>
        /// 获取财务配置信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFinanceConfigurationInfo()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int Type = parms.GetInt("Type", 0);
            if (Type <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var obj = financeModule.GetFinanceConfigurationInfo(Type, requestParm.TenantId, requestParm.MallBaseId);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 获取流程列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFinanceWorkFlowTemplateList() {

            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int TempLateClass = parms.GetInt("TempLateClass", 0);
            if (TempLateClass <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var List = financeModule.GetFinanceWorkFlowTemplateList(TempLateClass);
            return ApiResult.Success("", List);
        }


        #endregion
    }
}