﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;
using Mall.Common;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单明细仓储层
    /// </summary>
    public class RB_Goods_OrderDetailRepository : BaseRepository<RB_Goods_OrderDetail>
    {

        /// <summary>
        /// 获取订单明细列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetail_Extend> GetOrderDetailList(RB_Goods_OrderDetail_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and a.{nameof(RB_Goods_OrderDetail.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_Goods_OrderDetail.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderDetailIds))
            {
                where += $@" and a.{nameof(RB_Goods_OrderDetail.Id)} in({dmodel.OrderDetailIds})";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and a.{nameof(RB_Goods_OrderDetail.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.OrderType > 0)
            {
                where += $@" and a.{nameof(RB_Goods_OrderDetail.OrderType)}={(int)dmodel.OrderType}";
            }
            if (dmodel.IsComment > 0)
            {
                where += $@" and a.{nameof(RB_Goods_OrderDetail.IsComment)}={(int)dmodel.IsComment}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and a.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.ProductCode))
            {
                where += $@" and a.{nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and a.{nameof(RB_Goods_OrderDetail.OrderId)} in({dmodel.OrderIds})";
            }

            string sql = $@"SELECT a.*,b.`Name` as SupplierName FROM rb_goods_orderdetail as a LEFT JOIN rb_supplier as b on a.SupplierId=b.ID where {where} order by a.Id asc";
            return Get<RB_Goods_OrderDetail_Extend>(sql).ToList();
        }


        /// <summary>
        /// 获取订单商品分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetail_Extend> GetSupplierOrderPageList(int pageIndex, int pageSize, out long count, RB_Goods_OrderDetail_Extend dmodel)
        {
            string where = $" 1=1 and o.{nameof(RB_Goods_Order.Status)}=0 and o.OrderStatus  in(2,3,4,5,6) ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.MallBaseId)}={dmodel.MallBaseId}";
            }

            if (dmodel.OrderType > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.OrderType)}={dmodel.OrderType}";
            }
            if (dmodel.SupplierId > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.SupplierId)}={dmodel.SupplierId}";
            }

            if (dmodel.IsFinance > 0)
            {
                if (dmodel.IsSelectAll == 1)
                {
                    if (dmodel.IsFinance == 1)
                    {
                        where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}>0";
                    }
                    else
                    {
                        where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}<=0";
                    }
                }
                else if (dmodel.IsSelectAll == 2)
                {
                    if (dmodel.IsFinance == 1)
                    {
                        where += $@" and od.{nameof(RB_Goods_OrderDetail.FreightFinanceId)}>0";
                    }
                    else
                    {
                        where += $@" and od.{nameof(RB_Goods_OrderDetail.FreightFinanceId)}<=0";
                    }
                }
                else
                {
                    if (dmodel.IsFinance == 1)
                    {
                        where += $@" and (od.{nameof(RB_Goods_OrderDetail.FreightFinanceId)}>0 or od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}>0)";
                    }
                    else
                    {
                        where += $@" and (od.{nameof(RB_Goods_OrderDetail.FreightFinanceId)}<=0 or od.{nameof(RB_Goods_OrderDetail.CostFinanceId)} <= 0)";
                    }
                }
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }


            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }

            if (!string.IsNullOrEmpty(dmodel.ProductCode))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            }

            string sql = $@"SELECT od.*,o.OrderNo FROM rb_goods_orderdetail od
INNER JOIN rb_goods_order o on o.OrderId=od.OrderId
where {where}  order by o.CreateDate desc";
            return GetPage<RB_Goods_OrderDetail_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }


        /// <summary>
        /// 获取订单商品列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetail_Extend> GetSupplierOrderList(RB_Goods_OrderDetail_Extend dmodel)
        {
            string where = $" 1=1 and o.{nameof(RB_Goods_Order.Status)}=0 and o.OrderStatus  in(2,3,4,5,6) ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.MallBaseId)}={dmodel.MallBaseId}";
            }

            if (dmodel.OrderType > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.OrderType)}={dmodel.OrderType}";
            }
            if (dmodel.SupplierId > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.SupplierId)}={dmodel.SupplierId}";
            }
            if (dmodel.IsFinance > 0)
            {
                if (dmodel.IsSelectAll == 1)
                {
                    if (dmodel.IsFinance == 1)
                    {
                        where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}>0";
                    }
                    else
                    {
                        where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}<=0";
                    }
                }
                else if (dmodel.IsSelectAll == 2)
                {
                    if (dmodel.IsFinance == 1)
                    {
                        where += $@" and od.{nameof(RB_Goods_OrderDetail.FreightFinanceId)}>0";
                    }
                    else
                    {
                        where += $@" and od.{nameof(RB_Goods_OrderDetail.FreightFinanceId)}<=0";
                    }
                }
                else
                {
                    if (dmodel.IsFinance == 1)
                    {
                        where += $@" and (od.{nameof(RB_Goods_OrderDetail.FreightFinanceId)}>0 or od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}>0)";
                    }
                    else
                    {
                        where += $@" and (od.{nameof(RB_Goods_OrderDetail.FreightFinanceId)}<=0 or od.{nameof(RB_Goods_OrderDetail.CostFinanceId)} <= 0)";
                    }
                }
            }
            ////if (dmodel.IsFinance > 0)
            ////{
            ////    if (dmodel.IsFinance == 1)
            ////    {
            ////        where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}>0";
            ////    }
            ////    else
            ////    {
            ////        where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}<=0";
            ////    }
            ////}
            if (dmodel.IdList != null && dmodel.IdList.Any())
            {
                string ids = string.Join(",", dmodel.IdList.Select(x => x));
                where += $@" and od.{nameof(RB_Goods_OrderDetail.Id)} in({ids}) ";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }


            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }

            if (!string.IsNullOrEmpty(dmodel.ProductCode))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            }

            string sql = $@"SELECT od.*,o.OrderNo FROM rb_goods_orderdetail od
INNER JOIN rb_goods_order o on o.OrderId=od.OrderId
where {where}  order by o.CreateDate desc";
            return Get<RB_Goods_OrderDetail_Extend>(sql).ToList();
        }




        /// <summary>
        /// 获取订单商品列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetail_Extend> GetOrderGoodsList(RB_Goods_OrderDetail_Extend dmodel)
        {
            string where = $" 1=1 and o.{nameof(RB_Goods_Order.Status)}=0 and o.OrderStatus=2";
            string childreWhere = "";
            if (dmodel.TenantId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.TenantId)}={dmodel.TenantId}";
                childreWhere += $@" and {nameof(RB_Goods_ExpressRelevance.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.MallBaseId)}={dmodel.MallBaseId}";
                childreWhere += $@" and {nameof(RB_Goods_ExpressRelevance.MallBaseId)}={dmodel.MallBaseId}";
            }

            if (dmodel.OrderType > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.OrderType)}={dmodel.OrderType}";
            }
            if (dmodel.SupplierId > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.SupplierId)}={dmodel.SupplierId}";
            }

            if (dmodel.IsFinance > 0)
            {
                if (dmodel.IsFinance == 1)
                {
                    where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}>0";
                }
                else
                {
                    where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}<=0";
                }
            }
            if (dmodel.IdList != null && dmodel.IdList.Any())
            {
                string ids = string.Join(",", dmodel.IdList.Select(x => x));
                where += $@" and od.{nameof(RB_Goods_OrderDetail.Id)} in({ids}) ";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }


            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }

            if (!string.IsNullOrEmpty(dmodel.ProductCode))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            }

            where += $"and od.Id not in (SELECT OrderDetailId from rb_goods_expressrelevance where 1=1 {childreWhere})";
            string sql = $@"SELECT od.*,o.OrderNo FROM rb_goods_orderdetail od
INNER JOIN rb_goods_order o on o.OrderId=od.OrderId  
where {where}  order by o.CreateDate desc";
            return Get<RB_Goods_OrderDetail_Extend>(sql).ToList();
        }


        /// <summary>
        /// 获取未出库的订单商品列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetail_Extend> GetNoOutOrderGoodsList(int pageIndex, int pageSize, out long count, RB_Goods_OrderDetail_Extend dmodel)
        {
            string where = $" 1=1 and o.{nameof(RB_Goods_Order.Status)}=0 and o.OrderStatus=2";
            string childreWhere = "";
            string outWhere = "";
            if (dmodel.TenantId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.TenantId)}={dmodel.TenantId}";
                childreWhere += $@" and {nameof(RB_Goods_ExpressRelevance.TenantId)}={dmodel.TenantId}";
                outWhere += $@" and  ap.TenantId={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.MallBaseId)}={dmodel.MallBaseId}";
                childreWhere += $@" and {nameof(RB_Goods_ExpressRelevance.MallBaseId)}={dmodel.MallBaseId}";
                outWhere += $@" and ap.MallBaseId={dmodel.MallBaseId}";
            }

            if (dmodel.OrderType > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.OrderType)}={dmodel.OrderType}";
            }
            if (dmodel.SupplierId > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.SupplierId)}={dmodel.SupplierId}";
            }

            if (dmodel.IsFinance > 0)
            {
                if (dmodel.IsFinance == 1)
                {
                    where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}>0";
                }
                else
                {
                    where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}<=0";
                }
            }
            if (dmodel.IdList != null && dmodel.IdList.Any())
            {
                string ids = string.Join(",", dmodel.IdList.Select(x => x));
                where += $@" and od.{nameof(RB_Goods_OrderDetail.Id)} in({ids}) ";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }


            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }

            if (!string.IsNullOrEmpty(dmodel.ProductCode))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            }

            where += $" and od.Id not in (SELECT OrderDetailId from rb_goods_expressrelevance where 1=1 {childreWhere})";
            where += @$" AND od.Id NOT IN (SELECT OrderGoodsId	FROM	{Config.PropertyDB}.rb_warehouseout_goods AS g LEFT JOIN {Config.PropertyDB}.rb_warehouseout_apply AS ap ON g.applyId = ap.id WHERE ap.ApplyStatus in (1,2) {outWhere} )";
            string sql = $@"SELECT od.*,o.OrderNo FROM rb_goods_orderdetail od
INNER JOIN rb_goods_order o on o.OrderId=od.OrderId  
where {where}  order by o.CreateDate desc";
            return GetPage<RB_Goods_OrderDetail_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
