﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 和平等级仓储层
    /// </summary>
    public class RB_Distributor_HPGradeInfoRepository : RepositoryBase<RB_Distributor_HPGradeInfo>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_HPGradeInfo_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_HPGradeInfo_Extend dmodel)
        {
            string where = $@" 1=1 and {nameof(RB_Distributor_HPGradeInfo.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.Id)}={dmodel.Id}";
            }
            if (dmodel.Grade > 0) {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.Grade)}={dmodel.Grade}";
            }
            if (!string.IsNullOrEmpty(dmodel.GradeName)) {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.GradeName)} like '%{dmodel.GradeName}%'";
            }
            
            string sql = $@"select * from RB_Distributor_HPGradeInfo where {where} order by Id desc";
            return GetPage<RB_Distributor_HPGradeInfo_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_HPGradeInfo_Extend> GetList(RB_Distributor_HPGradeInfo_Extend dmodel)
        {
            string where = $@" 1=1 and {nameof(RB_Distributor_HPGradeInfo.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.Id)}={dmodel.Id}";
            }
            if (dmodel.Grade > 0)
            {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.Grade)}={dmodel.Grade}";
            }
            if (!string.IsNullOrEmpty(dmodel.GradeName))
            {
                where += $@" and {nameof(RB_Distributor_HPGradeInfo.GradeName)} like '%{dmodel.GradeName}%'";
            }

            string sql = $@"select * from RB_Distributor_HPGradeInfo where {where} order by Id desc";
            return Get<RB_Distributor_HPGradeInfo_Extend>(sql).ToList();
        }
    }
}
