﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;
using Mall.Common.Enum.Goods;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单返佣仓储层
    /// </summary>
    public class RB_Goods_OrderCommissionRepository : RepositoryBase<RB_Goods_OrderCommission>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderCommission_Extend> GetList(RB_Goods_OrderCommission_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.OrderId)} in({dmodel.OrderIds})";
            }

            string sql = $@"SELECT * FROM RB_Goods_OrderCommission where {where} order by Id asc";
            return Get<RB_Goods_OrderCommission_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取用户返佣
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderCommission_Extend> GetListGroupByUser(RB_Goods_OrderCommission_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and {nameof(RB_Goods_OrderCommission.OrderId)} in({dmodel.OrderIds})";
            }

            string sql = $@"SELECT OrderId,UserId,Grade,Type,SUM(Commission) as Commission FROM RB_Goods_OrderCommission where {where} group by OrderId,UserId,Grade,Type order by Grade asc";
            return Get<RB_Goods_OrderCommission_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取用户返佣
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderCommission_Extend> GetListGroupByUser_V2(int pageIndex,int pageSize,out long count,RB_Goods_OrderCommission_Extend dmodel)
        {
            string where = $" 1=1 and o.Recycled=2";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.OrderId)} in({dmodel.OrderIds})";
            }
            if (dmodel.DistrbutionOrderSelectStatus > 0) {
                switch (dmodel.DistrbutionOrderSelectStatus)
                {
                    case 1: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)OrderStatusEnum.NonPayment}"; break;
                    case 2: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(2,3,4,6)"; break;
                    case 3: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)OrderStatusEnum.Completed}"; break;
                }
            }

            string sql = $@"SELECT oc.OrderId,o.OrderNo,o.UserId,oc.Grade,o.OrderStatus as DistrbutionOrderSelectStatus,SUM(oc.Commission) as Commission 
FROM RB_Goods_OrderCommission oc
inner join rb_goods_order o on oc.OrderId = o.OrderId
where {where} group by oc.OrderId,o.OrderNo,oc.UserId,oc.Grade order by oc.OrderId desc";
            return GetPage<RB_Goods_OrderCommission_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取用户返佣
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderCommission_Extend> GetListGroupByUser_V3(int pageIndex, int pageSize, out long count, RB_Goods_OrderCommission_Extend dmodel)
        {
            string where = $" 1=1 and o.Recycled=2 and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.OrderId)} in({dmodel.OrderIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo)) {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)}='{dmodel.OrderNo}'";
            }
            if (dmodel.CommissionState > 0)
            {
                switch (dmodel.CommissionState)
                {
                    case 2: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)OrderStatusEnum.Completed}"; break;
                    case 1: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(1,2,3,4,6)"; break;
                }
            }

            string sql = $@"SELECT oc.OrderId,o.OrderNo,o.UserId,oc.Grade,o.OrderStatus as DistrbutionOrderSelectStatus,SUM(oc.Commission) as Commission 
FROM RB_Goods_OrderCommission oc
inner join rb_goods_order o on oc.OrderId = o.OrderId
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
where {where} group by oc.OrderId,o.OrderNo,oc.UserId,oc.Grade order by oc.OrderId desc";
            return GetPage<RB_Goods_OrderCommission_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 订单返佣
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public decimal GetUserOrderCommissionStatistics(int userId)
        {
            string sql = $@"SELECT SUM(Commission) as Commission FROM rb_goods_ordercommission oc
INNER JOIN rb_goods_order o on oc.OrderId=o.OrderId
 WHERE oc.UserId={userId} and o.OrderStatus in (1,2,3,4,5,6) and o.Recycled=2";

            var obj = ExecuteScalar(sql);
            if (obj != null) {
                return Convert.ToDecimal(obj);
            }
            return 0;
        }

        /// <summary>
        /// 订单返佣
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderCommission_Extend> GetUserCommissionStatistics(string userIds)
        {
            string sql = $@"SELECT oc.UserId
,SUM(case when oc.CommissionState =1 then oc.Commission else 0 end) as WaitCommission
,SUM(case when oc.CommissionState =2 then oc.Commission else 0 end) as Commission
FROM rb_goods_ordercommission oc
INNER JOIN rb_goods_order o on oc.OrderId=o.OrderId
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
 WHERE oc.UserId in({userIds}) and o.OrderStatus in (1,2,3,4,5,6) and o.Recycled=2 and oa.ReOrderId is null
 group by oc.UserId";

            return Get<RB_Goods_OrderCommission_Extend>(sql).ToList();
        }
    }
}
