﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单明细仓储层
    /// </summary>
    public class RB_Goods_OrderDetailRepository : RepositoryBase<RB_Goods_OrderDetail>
    {

        /// <summary>
        /// 获取订单明细列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetail_Extend> GetOrderDetailList(RB_Goods_OrderDetail_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderDetail.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderDetail.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderDetailIds))
            {
                where += $@" and {nameof(RB_Goods_OrderDetail.Id)} in({dmodel.OrderDetailIds})";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderDetail.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.OrderType > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderDetail.OrderType)}={(int)dmodel.OrderType}";
            }
            if (dmodel.IsComment > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderDetail.IsComment)}={(int)dmodel.IsComment}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and {nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.ProductCode))
            {
                where += $@" and {nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and {nameof(RB_Goods_OrderDetail.OrderId)} in({dmodel.OrderIds})";
            }

            string sql = $@"SELECT * FROM rb_goods_orderdetail where {where} order by Id asc";
            return Get<RB_Goods_OrderDetail_Extend>(sql).ToList();
        }


        /// <summary>
        /// 获取订单商品分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetail_Extend> GetSupplierOrderPageList(int pageIndex, int pageSize, out long count, RB_Goods_OrderDetail_Extend dmodel)
        {
            string where = $" 1=1 and o.{nameof(RB_Goods_Order.Status)}=0 and o.OrderStatus  in(2,3,4,5,6) ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and o.{nameof(RB_Goods_Order.MallBaseId)}={dmodel.MallBaseId}";
            }

            if (dmodel.OrderType > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.OrderType)}={dmodel.OrderType}";
            }
            if (dmodel.SupplierId > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.SupplierId)}={dmodel.SupplierId}";
            }

            if (dmodel.IsFinance > 0)
            {
                if (dmodel.IsFinance == 1)
                {
                    where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}>0";
                }
                else
                {
                    where += $@" and od.{nameof(RB_Goods_OrderDetail.CostFinanceId)}<=0";
                }

            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and o.{nameof(RB_Goods_Order.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }


            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }

            if (!string.IsNullOrEmpty(dmodel.ProductCode))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.ProductCode)} like '%{dmodel.ProductCode}%'";
            }

            string sql = $@"SELECT od.*,o.OrderNo FROM rb_goods_orderdetail od
INNER JOIN rb_goods_order o on o.OrderId=od.OrderId
where {where}  order by o.CreateDate desc";
            return GetPage<RB_Goods_OrderDetail_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
