﻿using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品评论标签仓储层
    /// </summary>
    public class RB_Comment_LabelRepository : BaseRepository<RB_Comment_Label>
    {
        /// <summary>
        /// 获取评论标签分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="totalCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Comment_Label_Extend> GetCommentLabelPageRepository(int pageIndex, int pageSize, out long totalCount, RB_Comment_Label_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_Comment_Label AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Comment_Label_Extend.Status), 0);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Comment_Label_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Comment_Label_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Comment_Label_Extend.Name)} like '%{query.Name}%'");
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Comment_Label_Extend.Id));
            return GetPage<RB_Comment_Label_Extend>(pageIndex, pageSize, out totalCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取评论标签列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Comment_Label_Extend> GetCommentLabelListRepository(RB_Comment_Label_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_Comment_Label AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Comment_Label_Extend.Status), 0);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Comment_Label_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Comment_Label_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Comment_Label_Extend.Name)} like '%{query.Name}%'");
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Comment_Label_Extend.Id));
            return Get<RB_Comment_Label_Extend>(builder.ToString()).ToList();
        }
    }
}
