﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Assess;
using Mall.Model.Extend.Assess;
using System.Linq;

namespace Mall.Repository.Assess
{
    /// <summary>
    /// 估价分类仓储层
    /// </summary>
    public class RB_Assess_CategoryRepository : BaseRepository<RB_Assess_Category>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Assess_Category_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Assess_Category_Extend dmodel)
        {
            string where = $" 1=1 and e.{nameof(RB_Assess_Category_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0) {
                where += $@" and e.{nameof(RB_Assess_Category_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Category_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Enable > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Category_Extend.Enable)} ={dmodel.Enable}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Category_Extend.Id)} ={dmodel.Id}";
            }
            string sql = $@"select * from RB_Assess_Category e where {where} order by e.Id desc";
            return GetPage<RB_Assess_Category_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Assess_Category_Extend> GetList(RB_Assess_Category_Extend dmodel)
        {
            string where = $" 1=1 and e.{nameof(RB_Assess_Category_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Category_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Category_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Enable > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Category_Extend.Enable)} ={dmodel.Enable}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Category_Extend.Id)} ={dmodel.Id}";
            }
            string sql = $@"select * from RB_Assess_Category e where {where} order by e.Id desc";
            return Get<RB_Assess_Category_Extend>(sql).ToList();
        }
    }
}
