﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 微店仓储层
    /// </summary>
    public class RB_SmallShops_InfoRepository : BaseRepository<RB_SmallShops_Info>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_SmallShops_Info_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_SmallShops_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_SmallShops_Info_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (dmodel.GradeId >= 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.GradeId)}={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.NickName))
            {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.NickName}%'";
            }
            if (dmodel.SuperiorId > 0)
            {
                where += $@" and u.{nameof(RB_Member_User.SuperiorId)}={dmodel.SuperiorId}";
            }

            string sql = $@"select di.*,u.Name as NickName,u.SuperiorId,u.Photo from RB_SmallShops_Info di
inner join rb_member_user u on di.UserId=u.Id
where {where} order by di.CreateDate desc";
            return GetPage<RB_SmallShops_Info_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Info_Extend> GetList(RB_SmallShops_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_SmallShops_Info_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.Id)}={dmodel.Id}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (dmodel.GradeId >= 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.GradeId)}={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.NickName))
            {
                where += $@" and u.{nameof(RB_Member_User.Name)} like '%{dmodel.NickName}%'";
            }
            if (dmodel.SuperiorId > 0)
            {
                where += $@" and u.{nameof(RB_Member_User.SuperiorId)}={dmodel.SuperiorId}";
            }

            string sql = $@"select di.*,u.Name as NickName,u.SuperiorId,u.Photo from RB_SmallShops_Info di
inner join rb_member_user u on di.UserId=u.Id
where {where} order by di.CreateDate desc";
            return Get<RB_SmallShops_Info_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Info_Extend> GetListForSingle(RB_SmallShops_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_SmallShops_Info_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserIds))
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.UserId)} in({dmodel.UserIds})";
            }
            if (dmodel.GradeId >= 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.GradeId)}={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.Name)} like '%{dmodel.Name}%'";
            }

            string sql = $@"select di.* from RB_SmallShops_Info di where {where} order by di.Id desc";
            return Get<RB_SmallShops_Info_Extend>(sql).ToList();
        }
        /// <summary>
        /// 下拉列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_SmallShops_Info_Extend> GetSmallShopsDropDownList(int pageIndex, int pageSize, out long count, RB_SmallShops_Info_Extend dmodel)
        {
            string where = $@" 1=1 and di.{nameof(RB_SmallShops_Info_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.UserId)}={dmodel.UserId}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserIds))
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.UserId)} in({dmodel.UserIds})";
            }
            if (dmodel.GradeId >= 0)
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.GradeId)}={dmodel.GradeId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and di.{nameof(RB_SmallShops_Info_Extend.Name)} like '%{dmodel.Name}%'";
            }

            string sql = $@"select di.Id,di.Name from RB_SmallShops_Info di where {where} order by di.Id desc";
            return GetPage<RB_SmallShops_Info_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
