﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 推荐供应商返佣账单表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_Bill
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 期数
        /// </summary>
        public string Periods { get; set; }
        /// <summary>
        /// 账单总金额
        /// </summary>
        public decimal? Money { get; set; }
        /// <summary>
        /// 账单状态   1待打款  2已打款  3驳回
        /// </summary>
        public int? BillState { get; set; }

        /// <summary>
        /// 用户id/分销商id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 供应商id
        /// </summary>        
        public int? SupplierId
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 状态
        /// </summary>
        public int? Status { get; set; }

        /// <summary>
        /// 操作员工
        /// </summary>
        public int? EmpId { get; set; }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 
        /// </summary>
        public DateTime? UpdateDate { get; set; }
        /// <summary>
        /// 绑定财务单据id
        /// </summary>
        public int? FinanceId { get; set; }
    }
}
