﻿using COSXML.Common;
using COSXML.CosException;
using COSXML.Model;
using COSXML.Model.Object;
using COSXML.Model.Tag;
using COSXML.Model.Bucket;
using COSXML.Model.Service;
using COSXML.Utils;
using COSXML.Auth;
using COSXML.Transfer;
using System;
using COSXML;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Mall.Education.Common;
using Mall.Education.Helper;

namespace COSSnippet
{
    public class TransferUploadObjectModel
    {

        private CosXml cosXml;
        private string bucketName;

        public TransferUploadObjectModel(int MallBaseId)
        {
            var ds = FileDataHelper.GetMallBaseFileInfo(MallBaseId, 1);
            if (ds.Tables[0].Rows.Count > 0)
            {
                string endpoint = ds.Tables[0].Rows[0]["Region"].ToString();
                string accessKeyId = ds.Tables[0].Rows[0]["SecretId"].ToString();
                string accessKeySecret = ds.Tables[0].Rows[0]["SecretKey"].ToString();
                CosXmlConfig config = new CosXmlConfig.Builder()
                  .SetRegion(endpoint) //设置一个默认的存储桶地域
                  .Build();

                string secretId = accessKeyId;   //云 API 密钥 SecretId
                string secretKey = accessKeySecret; //云 API 密钥 SecretKey
                long durationSecond = 600;          //每次请求签名有效时长，单位为秒
                QCloudCredentialProvider qCloudCredentialProvider = new DefaultQCloudCredentialProvider(secretId,
                  secretKey, durationSecond);

                this.cosXml = new CosXmlServer(config, qCloudCredentialProvider);

                bucketName = ds.Tables[0].Rows[0]["Bucket"].ToString();
            }
            else
            {
                CosXmlConfig config = new CosXmlConfig.Builder()
                  .SetRegion(Config.GetAppSetting("TX_COS_REGION")) //设置一个默认的存储桶地域
                  .Build();

                string secretId = Config.GetAppSetting("TX_COS_SECRETID");   //云 API 密钥 SecretId
                string secretKey = Config.GetAppSetting("TX_COS_SECRETKEY"); //云 API 密钥 SecretKey
                long durationSecond = 600;          //每次请求签名有效时长，单位为秒
                QCloudCredentialProvider qCloudCredentialProvider = new DefaultQCloudCredentialProvider(secretId,
                  secretKey, durationSecond);

                this.cosXml = new CosXmlServer(config, qCloudCredentialProvider);

                bucketName = Config.GetAppSetting("TX_COS_BUCKET");
            }
        }

        /// 高级接口上传对象
        public void TransferUploadFile(string filePath,string newFileName)
        {
            //.cssg-snippet-body-start:[transfer-upload-file]
            // 初始化 TransferConfig
            TransferConfig transferConfig = new TransferConfig();

            // 初始化 TransferManager
            TransferManager transferManager = new TransferManager(cosXml, transferConfig);

            String bucket = bucketName; //存储桶，格式：BucketName-APPID
            String cosPath = newFileName; //对象在存储桶中的位置标识符，即称对象键
            //String cosPath = "Upload/Education/"+ newFileName; //对象在存储桶中的位置标识符，即称对象键
            //if (Config.GetAppSetting("IsNorServer") == "2")
            //{
            //    cosPath = "Test/" + cosPath;
            //}
            String srcPath = filePath;//本地文件绝对路径

            // 上传对象
            COSXMLUploadTask uploadTask = new COSXMLUploadTask(bucket, cosPath);
            uploadTask.SetSrcPath(srcPath);

            uploadTask.progressCallback = delegate (long completed, long total)
            {
                Console.WriteLine(String.Format("progress = {0:##.##}%", completed * 100.0 / total));
            };
            uploadTask.successCallback = delegate (CosResult cosResult)
            {
                COSXML.Transfer.COSXMLUploadTask.UploadTaskResult result = cosResult
                  as COSXML.Transfer.COSXMLUploadTask.UploadTaskResult;
                Console.WriteLine(result.GetResultInfo());
                string eTag = result.eTag;
            };
            uploadTask.failCallback = delegate (CosClientException clientEx, CosServerException serverEx)
            {
                if (clientEx != null)
                {
                    LogHelper.Write("CosClientException: " + clientEx);
                }
                if (serverEx != null)
                {
                    LogHelper.Write("CosServerException: " + serverEx.GetInfo());
                }
            };
            transferManager.Upload(uploadTask);

            //.cssg-snippet-body-end
        }

        /// <summary>
        /// 查询文件
        /// </summary>
        /// <param name="cosFileName"></param>
        public bool SelectFile(string cosFileName) {
            try
            {
                string bucket = bucketName; //存储桶，格式：BucketName-APPID
                string key = cosFileName; //对象键
                HeadObjectRequest request = new HeadObjectRequest(bucket, key);
                //执行请求
                HeadObjectResult result = cosXml.HeadObject(request);
                //请求成功
                if (result.GetResultInfo().Contains("200 OK"))
                {
                    return true;
                }
                else {
                    return false;
                }
            }
            catch (COSXML.CosException.CosClientException clientEx)
            {
                //请求失败
                Console.WriteLine("CosClientException: " + clientEx);
            }
            catch (COSXML.CosException.CosServerException serverEx)
            {
                //请求失败
                Console.WriteLine("CosServerException: " + serverEx.GetInfo());
            }
            return false;
        }

        /// 高级接口下载对象
        public void TransferDownloadObject(string filePath,string fileName, string cosPathName)
        {
            //.cssg-snippet-body-start:[transfer-download-object]
            // 初始化 TransferConfig
            TransferConfig transferConfig = new TransferConfig();

            // 初始化 TransferManager
            TransferManager transferManager = new TransferManager(cosXml, transferConfig);

            String bucket = bucketName; //存储桶，格式：BucketName-APPID
            String cosPath = cosPathName; //对象在存储桶中的位置标识符，即称对象键
            string localDir = filePath;//本地文件夹
            string localFileName = fileName; //指定本地保存的文件名

            // 下载对象
            COSXMLDownloadTask downloadTask = new COSXMLDownloadTask(bucket, cosPath,
              localDir, localFileName);

            downloadTask.progressCallback = delegate (long completed, long total)
            {
                Console.WriteLine(String.Format("progress = {0:##.##}%", completed * 100.0 / total));
            };
            downloadTask.successCallback = delegate (CosResult cosResult)
            {
                COSXML.Transfer.COSXMLDownloadTask.DownloadTaskResult result = cosResult
                  as COSXML.Transfer.COSXMLDownloadTask.DownloadTaskResult;
                Console.WriteLine(result.GetResultInfo());
                string eTag = result.eTag;
            };
            downloadTask.failCallback = delegate (CosClientException clientEx, CosServerException serverEx)
            {
                if (clientEx != null)
                {
                    Console.WriteLine("CosClientException: " + clientEx);
                }
                if (serverEx != null)
                {
                    Console.WriteLine("CosServerException: " + serverEx.GetInfo());
                }
            };
            transferManager.Download(downloadTask);
            //.cssg-snippet-body-end
        }

        /// 高级接口上传二进制数据
        public void TransferUploadBytes()
        {
            //.cssg-snippet-body-start:[transfer-upload-bytes]
            try
            {
                string bucket = "examplebucket-1250000000"; //存储桶，格式：BucketName-APPID
                string cosPath = "exampleObject"; // 对象键
                byte[] data = new byte[1024]; // 二进制数据
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, cosPath, data);

                cosXml.PutObject(putObjectRequest);
            }
            catch (COSXML.CosException.CosClientException clientEx)
            {
                //请求失败
                Console.WriteLine("CosClientException: " + clientEx);
            }
            catch (COSXML.CosException.CosServerException serverEx)
            {
                //请求失败
                Console.WriteLine("CosServerException: " + serverEx.GetInfo());
            }
            //.cssg-snippet-body-end
        }

        /// 高级接口流式上传
        public void TransferUploadStream()
        {
            /// 暂不支持
            //.cssg-snippet-body-start:[transfer-upload-stream]

            //.cssg-snippet-body-end
        }

        /// 高级接口 URI 上传
        public void TransferUploadUri()
        {
            /// 暂不支持
            //.cssg-snippet-body-start:[transfer-upload-uri]

            //.cssg-snippet-body-end
        }

        /// 上传暂停、续传、取消
        public void TransferUploadInteract()
        {
            TransferConfig transferConfig = new TransferConfig();

            TransferManager transferManager = new TransferManager(cosXml, transferConfig);

            string bucket = "examplebucket-1250000000"; //存储桶，格式：BucketName-APPID
            string cosPath = "exampleobject"; //对象在存储桶中的位置标识符，即称对象键
            string srcPath = @"temp-source-file";//本地文件绝对路径

            // 上传对象
            COSXMLUploadTask uploadTask = new COSXMLUploadTask(bucket, cosPath);
            uploadTask.SetSrcPath(srcPath);

            transferManager.Upload(uploadTask);

            //.cssg-snippet-body-start:[transfer-upload-pause]
            uploadTask.Pause();
            //.cssg-snippet-body-end

            //.cssg-snippet-body-start:[transfer-upload-resume]
            uploadTask.Resume();
            //.cssg-snippet-body-end

            //.cssg-snippet-body-start:[transfer-upload-cancel]
            uploadTask.Cancel();
            //.cssg-snippet-body-end
        }

        /// 批量上传
        public void TransferBatchUploadObjects()
        {
            //.cssg-snippet-body-start:[transfer-batch-upload-objects]
            TransferConfig transferConfig = new TransferConfig();

            // 初始化 TransferManager
            TransferManager transferManager = new TransferManager(cosXml, transferConfig);

            string bucket = "examplebucket-1250000000"; //存储桶，格式：BucketName-APPID

            for (int i = 0; i < 5; i++)
            {
                // 上传对象
                string cosPath = "exampleobject" + i; //对象在存储桶中的位置标识符，即称对象键
                string srcPath = @"temp-source-file";//本地文件绝对路径
                COSXMLUploadTask uploadTask = new COSXMLUploadTask(bucket, cosPath);
                uploadTask.SetSrcPath(srcPath);
                transferManager.Upload(uploadTask);
            }
            //.cssg-snippet-body-end
        }

        /// 上传时对单链接限速
        public void UploadObjectTrafficLimit()
        {
            //.cssg-snippet-body-start:[upload-object-traffic-limit]
            TransferConfig transferConfig = new TransferConfig();

            // 初始化 TransferManager
            TransferManager transferManager = new TransferManager(cosXml, transferConfig);

            string bucket = "examplebucket-1250000000"; //存储桶，格式：BucketName-APPID
            string cosPath = "dir/exampleObject"; // 对象键
            string srcPath = @"temp-source-file";//本地文件绝对路径

            PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, cosPath, srcPath);
            putObjectRequest.LimitTraffic(8 * 1000 * 1000); // 限制为1MB/s

            COSXMLUploadTask uploadTask = new COSXMLUploadTask(putObjectRequest);

            uploadTask.SetSrcPath(srcPath);

            transferManager.Upload(uploadTask);
            //.cssg-snippet-body-end
        }

        /// 创建目录
        public void CreateDirectory()
        {
            //.cssg-snippet-body-start:[create-directory]
            try
            {
                string bucket = "examplebucket-1250000000"; //存储桶，格式：BucketName-APPID
                string cosPath = "dir/"; // 对象键
                PutObjectRequest putObjectRequest = new PutObjectRequest(bucket, cosPath, new byte[0]);

                cosXml.PutObject(putObjectRequest);
            }
            catch (COSXML.CosException.CosClientException clientEx)
            {
                //请求失败
                Console.WriteLine("CosClientException: " + clientEx);
            }
            catch (COSXML.CosException.CosServerException serverEx)
            {
                //请求失败
                Console.WriteLine("CosServerException: " + serverEx.GetInfo());
            }
            //.cssg-snippet-body-end
        }


        // .cssg-methods-pragma

        //static void Main(string[] args)
        //{
        //    TransferUploadObjectModel m = new TransferUploadObjectModel();

        //    /// 高级接口上传对象
        //    m.TransferUploadFile();
        //    /// 高级接口上传二进制数据
        //    m.TransferUploadBytes();
        //    /// 高级接口流式上传
        //    m.TransferUploadStream();
        //    /// 高级接口 URI 上传
        //    m.TransferUploadUri();
        //    /// 上传暂停续传取消
        //    m.TransferUploadInteract();
        //    /// 批量上传
        //    m.TransferBatchUploadObjects();

        //    /// 上传时对单链接限速
        //    m.UploadObjectTrafficLimit();
        //    /// 创建目录
        //    m.CreateDirectory();
        //    // .cssg-methods-pragma
        //}
    }
}