﻿using VT.FW.DB;
using Mall.Common.Enum.MallBase;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 快递配置
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Express_Config
    {

        public int Id { get; set; }    
        
        /// <summary>
        /// 别名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 快递类型1-阿里，2-快递鸟
        /// </summary>
        public int? Type { get; set; }

        /// <summary>
        /// appid
        /// </summary>
        public string AppID { get; set; }

        /// <summary>
        /// key
        /// </summary>
        public string AppKey { get; set; }

        /// <summary>
        /// 秘钥
        /// </summary>
        public string AppSecret { get; set; }


        /// <summary>
        /// code
        /// </summary>
        public string AppCode { get; set; }
        /// <summary>
        /// 请求
        /// </summary>
        public string RquUrl { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 1-是  2否
        /// </summary>
        public int? IsDefault { get; set; }

        public int? Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }

    }
}
