﻿using VT.FW.DB;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 自动发放优惠券
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Coupon_SelfMotion
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 新人购买并付款的注册时间
        /// </summary>
        public DateTime? RegisterDate { get; set; }

        /// <summary>
        /// 触发事件，1-分享，2-购买并付款，3-新人领券
        /// </summary>
        public TriggerTypeEnum TriggerType { get; set; }


        /// <summary>
        /// 优惠券id
        /// </summary>
        public int DiscountCouponId { get; set; }


        /// <summary>
        /// 发放次数，0-无限制
        /// </summary>
        public int GrantNum { get; set; }

        /// <summary>
        /// 0-所有人，1-指定用户
        /// </summary>
        public int IsAll { get; set; }
    }
}
