﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 粉象返佣等级表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_FXCommission
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 等级ID
        /// </summary>        
        public int FXGradeId
        {
            get;
            set;
        }
        /// <summary>
        /// 返佣等级ID
        /// </summary>        
        public int CommissionGradeId
        {
            get;
            set;
        }
        /// <summary>
        /// 等级类型，-直接，2-间接
        /// </summary>        
        public int GradeType
        {
            get;
            set;
        }
        /// <summary>
        /// 返佣金额
        /// </summary>        
        public decimal? CommissionPrice
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
