﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    /// <summary>
    /// vip购买自定义页面页面仓储层
    /// </summary>
    public class RB_Distributor_FXGradeCustomRepository : BaseRepository<RB_Distributor_FXGradeCustom>
    {

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Distributor_FXGradeCustom); } }
        /// <summary>
        /// 自定义页面信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_FXGradeCustom_Extend> GetGradeCustomPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_FXGradeCustom_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Distributor_FXGradeCustom_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXGradeCustom_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXGradeCustom_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXGradeCustom_Extend.Id)}={query.Id}");
                }
            }
            return GetPage<RB_Distributor_FXGradeCustom_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 自定义页面信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_FXGradeCustom_Extend> GetGradeCustomList(RB_Distributor_FXGradeCustom_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Distributor_FXGradeCustom_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXGradeCustom_Extend.Id)}={query.Id}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXGradeCustom_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXGradeCustom_Extend.MallBaseId)}={query.MallBaseId}");
                }
            }
            return Get<RB_Distributor_FXGradeCustom_Extend>(builder.ToString()).ToList();
        }
    }
}
