﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.GuideCar
{
    /// <summary>
    /// 司导-车辆搜索模板实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_GuideCar_CarSearch
    {
        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 背景
        /// </summary>
        public string Background { get; set; }
        /// <summary>
        /// 搜索背景
        /// </summary>
        public string SearchBackground { get; set; }


        /// <summary>
        /// 搜索框文字
        /// </summary>
        public string SearchTips { get; set; }


        /// <summary>
        /// 是否显示时间筛选0-否，1-是
        /// </summary>
        public int IsShowDate { get; set; }

        /// <summary>
        /// 是否显示城市筛选0-否，1-是
        /// </summary>
        public int IsShowCity { get; set; }

        /// <summary>
        /// 是否显示地址筛选0-否，1-是
        /// </summary>
        public int IsShowAddress { get; set; }

        /// <summary>
        /// 是否显示拼车筛选0-否，1-是
        /// </summary>
        public int IsShowCarpooling { get; set; }

        /// <summary>
        /// 是否显示出行类型筛选0-否，1-是
        /// </summary>
        public int IsShowGuideCarGoodsType { get; set; }


        /// <summary>
        /// 是否显示车辆类型筛选0-否，1-是
        /// </summary>
        public int IsShowCarClass { get; set; }


        /// <summary>
        /// 是否显示出行人数筛选0-否，1-是
        /// </summary>
        public int IsShowTravelGuestNum { get; set; }


        /// <summary>
        /// 按钮上面的文字提示
        /// </summary>
        public string Tips { get; set; }

        /// <summary>
        /// 按钮上面的文字图标提示
        /// </summary>
        public string TipsIco { get; set; }

        /// <summary>
        /// 搜索框图标
        /// </summary>
        public string SearchIco { get; set; }
        /// <summary>
        /// 搜索圆角像素
        /// </summary>        
        public int? SearchFilletPX
        {
            get;
            set;
        }




        /// <summary>
        /// 按钮圆角像素
        /// </summary>        
        public int? ButtonFilletPX
        {
            get;
            set;
        }
        /// <summary>
        /// 按钮文本
        /// </summary>        
        public string ButtonText
        {
            get;
            set;
        }
        /// <summary>
        /// 按钮颜色
        /// </summary>        
        public string ButtonColor
        {
            get;
            set;
        }
        /// <summary>
        /// 按钮文字颜色
        /// </summary>        
        public string ButtonTextColor
        {
            get;
            set;
        }

    }
}
