﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using Mall.AOP.CustomerAttribute;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.GuideCar;
using Mall.Model.Entity.Product;
using Mall.Model.Entity.User;
using Mall.Model.Extend.BaseSetUp;
using Mall.Model.Extend.GuideCar;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.User;
using Mall.Model.Query;
using Mall.Repository.BaseSetUp;
using Mall.Repository.GuideCar;
using Mall.Repository.Product;
using Mall.Repository.User;
using Newtonsoft.Json;
using VT.FW.DB;

namespace Mall.Module.Product
{
    /// <summary>
    /// 司导专区处理层
    /// </summary>
    public class GuideCarModule
    {
        /// <summary>
        /// 素材分组
        /// </summary>
        private readonly RB_Material_GroupRepository material_GroupRepository = new RB_Material_GroupRepository();
        /// <summary>
        /// 素材管理
        /// </summary>
        private readonly RB_Material_InfoRepository material_InfoRepository = new RB_Material_InfoRepository();
        /// <summary>
        /// 商品分类
        /// </summary>
        private readonly RB_Product_CategoryRepository product_CategoryRepository = new RB_Product_CategoryRepository();
        /// <summary>
        /// 商品
        /// </summary>
        private readonly RB_GoodsRepository goodsRepository = new RB_GoodsRepository();
        /// <summary>
        /// 商品可预定日期
        /// </summary>
        private readonly RB_Goods_TargetDateRepository goods_TargetDateRepository = new RB_Goods_TargetDateRepository();
        /// <summary>
        /// 商品日志
        /// </summary>
        private readonly RB_Goods_LogRepository goods_LogRepository = new RB_Goods_LogRepository();
        /// <summary>
        /// 商品区域
        /// </summary>
        private readonly RB_Goods_AreaRepository goods_AreaRepository = new RB_Goods_AreaRepository();
        /// <summary>
        /// 商品分类
        /// </summary>
        private readonly RB_Goods_CategoryRepository goods_CategoryRepository = new RB_Goods_CategoryRepository();
        /// <summary>
        /// 分销商等级
        /// </summary>
        private readonly RB_Distributor_GradeRepository distributor_GradeRepository = new RB_Distributor_GradeRepository();
        /// <summary>
        /// 分销商
        /// </summary>
        private readonly RB_Distributor_InfoRepository distributor_InfoRepository = new RB_Distributor_InfoRepository();
        /// <summary>
        /// 分销基础配置
        /// </summary>
        private readonly RB_Distributor_BasicsRepository distributor_BasicsRepository = new RB_Distributor_BasicsRepository();
        /// <summary>
        /// 会员等级
        /// </summary>
        private readonly RB_Member_GradeRepository member_GradeRepository = new RB_Member_GradeRepository();
        /// <summary>
        /// 用户管理
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        /// <summary>
        /// 商品分销佣金
        /// </summary>
        private readonly RB_Goods_DistributionCommissionRepository goods_DistributionCommissionRepository = new RB_Goods_DistributionCommissionRepository();
        /// <summary>
        /// 商品会员价格
        /// </summary>
        private readonly RB_Goods_MemberPriceRepository goods_MemberPriceRepository = new RB_Goods_MemberPriceRepository();
        /// <summary>
        /// 商户仓储层对象
        /// </summary>
        private Mall.Repository.User.RB_MiniProgramRepository programRepository = new Repository.User.RB_MiniProgramRepository();
        /// <summary>
        /// 商品收藏
        /// </summary>
        private readonly RB_Member_CollectionRepository member_CollectionRepository = new RB_Member_CollectionRepository();
        /// <summary>
        /// 收货地址
        /// </summary>
        private readonly RB_Member_ShippingAddressRepository member_ShippingAddressRepository = new RB_Member_ShippingAddressRepository();
        /// <summary>
        /// 订单商品
        /// </summary>
        private readonly RB_Goods_OrderRepository goods_OrderRepository = new RB_Goods_OrderRepository();
        /// <summary>
        /// 地区处理
        /// </summary>
        private readonly Rb_destinationRepository destinationRepository = new Rb_destinationRepository();
        /// <summary>
        /// 商品分销
        /// </summary>
        private readonly RB_MiniProgram_GoodPosterRepository miniProgram_GoodPosterRepository = new RB_MiniProgram_GoodPosterRepository();
        /// <summary>
        /// 粉象返佣
        /// </summary>
        private readonly RB_Distributor_FXGradeRepository distributor_FXGradeRepository = new RB_Distributor_FXGradeRepository();
        /// <summary>
        /// 粉象VIP返佣比例
        /// </summary>
        private readonly RB_Distributor_FXCommissionRepository distributor_FXCommissionRepository = new RB_Distributor_FXCommissionRepository();
        /// <summary>
        /// 微店基础
        /// </summary>
        private RB_SmallShops_CustomRepository smallShops_CustomRepository = new RB_SmallShops_CustomRepository();
        /// <summary>
        /// 微店
        /// </summary>
        private RB_SmallShops_InfoRepository smallShops_InfoRepository = new RB_SmallShops_InfoRepository();
        /// <summary>
        /// 微店商品价格
        /// </summary>
        private RB_SmallShops_PriceRepository smallShops_PriceRepository = new RB_SmallShops_PriceRepository();
        /// <summary>
        /// 司导站点
        /// </summary>
        private RB_GuideCar_SiteRepository SiteRepository = new RB_GuideCar_SiteRepository();
        /// <summary>
        /// 司导站点地区
        /// </summary>
        private RB_GuideCar_SiteRegionRepository SiteRegionRepository = new RB_GuideCar_SiteRegionRepository();
        /// <summary>
        /// 司导基础配置
        /// </summary>
        private RB_GuideCar_BaseRepository guideCar_BaseRepository = new RB_GuideCar_BaseRepository();
        /// <summary>
        /// 司导基础配置
        /// </summary>
        private RB_GuideCar_GuideRepository GuideRepository = new RB_GuideCar_GuideRepository();
        /// <summary>
        /// 车辆
        /// </summary>
        private RB_GuideCar_CarRepository GuideCarRepository = new RB_GuideCar_CarRepository();
        /// <summary>
        /// 车辆颜色
        /// </summary>
        private RB_GuideCar_CarColorRepository CarColorRepository = new RB_GuideCar_CarColorRepository();

        #region 基础配置
        /// <summary>
        /// 获取基础配置
        /// </summary>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_GuideCar_Base_Extend GetGuideCarInfo(int tenantId, int mallBaseId)
        {
            var model = guideCar_BaseRepository.GetList(new RB_GuideCar_Base_Extend() { TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                model = new RB_GuideCar_Base_Extend()
                {
                    AdvanceDay = 1,
                    MallBaseId = mallBaseId,
                    CancelHour = 1,
                    CostPrice = 0,
                    Id = 0,
                    InsuranceDescription = "",
                    InsuranceName = "",
                    IsConfirm = 1,
                    PagePath = "",
                    SalePrice = 0,
                    TenantId = tenantId,
                };
            }
            if (model.OrderStateJson == null || model.OrderStateJson == "" || model.OrderStateJson == "[]")
            {
                var list = EnumHelper.GetEnumList(typeof(Common.Enum.Goods.OrderStatusEnum));
                model.OrderStateList = list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new GrudeCarStateModel
                {
                    Name = x.Key,
                    Id = Convert.ToInt32(x.Value)
                }).ToList();
            }
            else
            {
                model.OrderStateList = JsonConvert.DeserializeObject<List<GrudeCarStateModel>>(model.OrderStateJson);
            }
            return model;
        }

        /// <summary>
        /// 保存
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetGuideCarInfo(RB_GuideCar_Base_Extend demodel)
        {
            var model = guideCar_BaseRepository.GetList(new RB_GuideCar_Base_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return guideCar_BaseRepository.Insert(demodel) > 0;
            }
            else
            {
                model.UpdateBy = demodel.UpdateBy;
                model.AdvanceDay = demodel.AdvanceDay;
                model.CancelHour = demodel.CancelHour;
                model.CostPrice = demodel.CostPrice;
                model.InsuranceDescription = demodel.InsuranceDescription;
                model.InsuranceName = demodel.InsuranceName;
                model.IsConfirm = demodel.IsConfirm;
                model.OrderStateJson = demodel.OrderStateJson;
                model.PagePath = demodel.PagePath;
                model.SalePrice = demodel.SalePrice;
                model.UpdateDate = demodel.UpdateDate;
                return guideCar_BaseRepository.Update(model);
            }
        }

        /// <summary>
        /// 获取会员等级列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGradeList(RB_Member_Grade_Extend dmodel)
        {
            var list = member_GradeRepository.GetList(dmodel);
            return list;
        }

        /// <summary>
        /// 获取分销等级列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Grade_Extend> GetDistributorGradeList(RB_Distributor_Grade_Extend demodel)
        {
            var list = distributor_GradeRepository.GetList(demodel);
            return list;
        }

        #endregion

        #region 商品管理

        /// <summary>
        /// 获取后台商品分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetProductGoodsPageList(int pageIndex, int pageSize, out long count, RB_Goods_Extend demodel)
        {
            var list = goodsRepository.GetPageListForCar(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                //查询分类
                string ids = string.Join(",", list.Select(x => x.Id));
                var clist = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsIds = ids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                var olist = goods_OrderRepository.GetGoodsOrderNum(ids);

                foreach (var item in list)
                {
                    item.CategoryList = clist.Where(x => x.GoodsId == item.Id).ToList();
                    //轮播图
                    item.CoverImage = "";
                    item.CarouselImageList = new List<RB_ImageCommonModel>();
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = CarouselIdList[0];
                        //轮播图
                        foreach (var qitem in CarouselIdList)
                        {
                            item.CarouselImageList.Add(new RB_ImageCommonModel()
                            {
                                Id = 0,
                                Name = "",
                                Path = qitem
                            });
                        }
                    }

                    item.GoodsBuyNum = olist.Where(x => x.GoodsId == item.Id).FirstOrDefault()?.OrderNum ?? 0;
                }
            }
            return list;
        }

        /// <summary>
        /// 获取商品详情
        /// </summary>
        /// <param name="goodsId"></param>
        /// <returns></returns>
        public RB_Goods_Extend GetProductGoodsInfo(int goodsId, int TenantId, int MallBaseId)
        {
            var model = goodsRepository.GetEntity(goodsId).RefMapperTo<RB_Goods_Extend>();
            if (model == null || model.TenantId != TenantId || model.MallBaseId != MallBaseId)
            {
                return null;
            }
            model.CategoryList = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            model.AreaList = new List<RB_Goods_Area_Extend>();
            if (model.IsAreaBuy == 1)
            {
                model.AreaList = goods_AreaRepository.GetList(new RB_Goods_Area_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
            }
            model.DistributionCommissionList = new List<RB_Goods_DistributionCommission_Extend>();
            model.DistributionCommissionTreeList = new List<RB_Goods_DistributionCommission_Extend>();
            if (model.SeparateDistribution == 1)
            {
                model.DistributionCommissionList = goods_DistributionCommissionRepository.GetList(new RB_Goods_DistributionCommission_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });

                if (model.DistributionCommissionList.Any())
                {
                    int SortNum = 1;
                    //获取分销商启用等级
                    var dgradeList = distributor_GradeRepository.GetList(new RB_Distributor_Grade_Extend() { Enabled = 1, TenantId = TenantId, MallBaseId = MallBaseId });
                    dgradeList.Add(new RB_Distributor_Grade_Extend()
                    {
                        Grade = 0,
                        Name = "默认等级",
                        Id = 0
                    });
                    string zdgradeStr = string.Join(",", dgradeList.Select(x => x.Id).OrderBy(x => x));
                    string ndgradeStr = string.Join(",", model.DistributionCommissionList.Select(x => x.DistributorGrade).Distinct().OrderBy(x => x));
                    var KeyList = model.DistributionCommissionList.Select(x => x.SpecificationSort ?? "").Distinct().ToList();
                    if (zdgradeStr == ndgradeStr)
                    {
                        foreach (var qitem in KeyList)
                        {
                            var treemodel = model.DistributionCommissionList.Where(x => (x.SpecificationSort ?? "") == qitem).FirstOrDefault();
                            treemodel.GradeCommissionList = model.DistributionCommissionList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            if (model.SeparateDistributionType == 2)
                            {
                                if (!string.IsNullOrEmpty(qitem))
                                {
                                    var ssarr = qitem.Split(':');
                                    int Sort = Convert.ToInt32(ssarr[0]);
                                    string pic_url = model.SpecificationList[0].SpecificationValueList.Where(x => x.Sort == Sort).FirstOrDefault()?.ImagePath;
                                    List<object> AttrList = new List<object>();
                                    for (int i = 0; i < ssarr.Length; i++)
                                    {
                                        var smodel = model.SpecificationList[i];
                                        var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();
                                        AttrList.Add(new
                                        {
                                            SName = smodel.Name,
                                            SId = smodel.Id,
                                            SVId = svmodel.Sort,
                                            SVName = svmodel.Name
                                        });
                                    }
                                    treemodel.AttrList = AttrList;
                                }
                            }
                            treemodel.Sort = SortNum;
                            treemodel.GradeCommissionList = treemodel.GradeCommissionList.OrderBy(x => x.DistributorGrade).ToList();
                            model.DistributionCommissionTreeList.Add(treemodel);
                        }
                    }
                    else
                    {//分销商等级有变更
                        foreach (var qitem in KeyList)
                        {
                            var treemodel = model.DistributionCommissionList.Where(x => (x.SpecificationSort ?? "") == qitem).FirstOrDefault();
                            treemodel.GradeCommissionList = new List<RB_Goods_DistributionCommission_Extend>();
                            var gradeCommList = model.DistributionCommissionList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            dgradeList = dgradeList.OrderByDescending(x => x.Grade).ToList();
                            foreach (var grade in dgradeList)
                            {
                                var gradeMList = gradeCommList.Where(x => x.DistributorGrade == grade.Id && x.SpecificationSort == qitem);
                                if (gradeMList.Any())
                                {
                                    treemodel.GradeCommissionList.AddRange(gradeMList);
                                }
                                else
                                {
                                    //表示新的
                                    treemodel.GradeCommissionList.Add(new RB_Goods_DistributionCommission_Extend()
                                    {
                                        DistributorGrade = grade.Id,
                                        OneCommission = 0,
                                        TwoCommission = 0,
                                        ThreeCommission = 0
                                    });
                                }
                            }
                            if (model.SeparateDistributionType == 2)
                            {
                                if (!string.IsNullOrEmpty(qitem))
                                {
                                    var ssarr = qitem.Split(':');
                                    int Sort = Convert.ToInt32(ssarr[0]);
                                    string pic_url = model.SpecificationList[0].SpecificationValueList.Where(x => x.Sort == Sort).FirstOrDefault()?.ImagePath;
                                    List<object> AttrList = new List<object>();
                                    for (int i = 0; i < ssarr.Length; i++)
                                    {
                                        var smodel = model.SpecificationList[i];
                                        var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();
                                        AttrList.Add(new
                                        {
                                            SName = smodel.Name,
                                            SId = smodel.Id,
                                            SVId = svmodel.Sort,
                                            SVName = svmodel.Name
                                        });
                                    }
                                    treemodel.AttrList = AttrList;
                                }
                            }
                            treemodel.Sort = SortNum;
                            treemodel.GradeCommissionList = treemodel.GradeCommissionList.OrderBy(x => x.DistributorGrade).ToList();
                            model.DistributionCommissionTreeList.Add(treemodel);
                        }
                    }
                    SortNum++;
                    if (model.DistributionCommissionTreeList.Any())
                    {
                        //倒序排一次
                        model.DistributionCommissionTreeList = model.DistributionCommissionTreeList.OrderByDescending(x => x.Sort).ToList();
                    }
                }
            }
            model.MemberPriceList = new List<RB_Goods_MemberPrice_Extend>();
            model.MemberPriceTreeList = new List<RB_Goods_MemberPrice_Extend>();
            if (model.EnjoyMember == 1 && model.SeparateSetMember == 1)
            {
                model.MemberPriceList = goods_MemberPriceRepository.GetList(new RB_Goods_MemberPrice_Extend() { GoodsId = goodsId, TenantId = TenantId, MallBaseId = MallBaseId });
                if (model.MemberPriceList.Any())
                {
                    int SortNum = 1;
                    var mgradeList = member_GradeRepository.GetList(new RB_Member_Grade_Extend() { Enabled = 1, TenantId = 1, MallBaseId = 1 });

                    string zdgradeStr = string.Join(",", mgradeList.Select(x => x.Id).OrderBy(x => x));
                    string ndgradeStr = string.Join(",", model.MemberPriceList.Select(x => x.MemberGrade).Distinct().OrderBy(x => x));
                    if (zdgradeStr == ndgradeStr)
                    {
                        var KeyList = model.MemberPriceList.Select(x => x.SpecificationSort ?? "").Distinct().ToList();
                        foreach (var qitem in KeyList)
                        {
                            var treemodel = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).FirstOrDefault();
                            treemodel.GradePriceList = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            if (!string.IsNullOrEmpty(qitem))
                            {
                                var ssarr = qitem.Split(':');
                                int Sort = Convert.ToInt32(ssarr[0]);
                                string pic_url = model.SpecificationList[0].SpecificationValueList.Where(x => x.Sort == Sort).FirstOrDefault()?.ImagePath;
                                List<object> AttrList = new List<object>();
                                for (int i = 0; i < ssarr.Length; i++)
                                {
                                    var smodel = model.SpecificationList[i];
                                    var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();
                                    AttrList.Add(new
                                    {
                                        SName = smodel.Name,
                                        SId = smodel.Id,
                                        SVId = svmodel.Sort,
                                        SVName = svmodel.Name
                                    });
                                }
                                treemodel.AttrList = AttrList;
                            }
                            treemodel.Sort = SortNum;
                            treemodel.GradePriceList = treemodel.GradePriceList.OrderBy(x => x.MemberGrade).ToList();
                            model.MemberPriceTreeList.Add(treemodel);
                        }
                    }
                    else
                    {//会员等级有变更
                        var KeyList = model.MemberPriceList.Select(x => x.SpecificationSort ?? "").Distinct().ToList();
                        foreach (var qitem in KeyList)
                        {
                            var treemodel = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).FirstOrDefault();
                            //treemodel.GradePriceList = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            treemodel.GradePriceList = new List<RB_Goods_MemberPrice_Extend>() { };
                            var gradePrice = model.MemberPriceList.Where(x => (x.SpecificationSort ?? "") == qitem).ToList();
                            mgradeList = mgradeList.OrderByDescending(x => x.Grade).ToList();
                            foreach (var grade in mgradeList)
                            {
                                var gradeMList = gradePrice.Where(x => x.MemberGrade == grade.Id && x.SpecificationSort == qitem);
                                if (gradeMList.Any())
                                {
                                    treemodel.GradePriceList.AddRange(gradeMList);
                                }
                                else
                                {
                                    //表示新的
                                    treemodel.GradePriceList.Add(new RB_Goods_MemberPrice_Extend()
                                    {
                                        MemberGrade = grade.Id,
                                        MemberPrice = 0,
                                    });
                                }
                            }
                            if (!string.IsNullOrEmpty(qitem))
                            {
                                var ssarr = qitem.Split(':');
                                int Sort = Convert.ToInt32(ssarr[0]);
                                string pic_url = model.SpecificationList[0].SpecificationValueList.Where(x => x.Sort == Sort).FirstOrDefault()?.ImagePath;
                                List<object> AttrList = new List<object>();
                                for (int i = 0; i < ssarr.Length; i++)
                                {
                                    var smodel = model.SpecificationList[i];
                                    var svmodel = smodel.SpecificationValueList.Where(x => x.Sort == Convert.ToInt32(ssarr[i])).FirstOrDefault();
                                    AttrList.Add(new
                                    {
                                        SName = smodel.Name,
                                        SId = smodel.Id,
                                        SVId = svmodel.Sort,
                                        SVName = svmodel.Name
                                    });
                                }
                                treemodel.AttrList = AttrList;
                            }
                            treemodel.Sort = SortNum;
                            treemodel.GradePriceList = treemodel.GradePriceList.OrderBy(x => x.MemberGrade).ToList();
                            model.MemberPriceTreeList.Add(treemodel);
                        }
                    }

                    SortNum++;
                    if (model.MemberPriceTreeList.Any())
                    {
                        //倒序排一次
                        model.MemberPriceTreeList = model.MemberPriceTreeList.OrderByDescending(x => x.Sort).ToList();
                    }
                }
            }
            model.CarouselImageList = new List<RB_ImageCommonModel>();
            if (!string.IsNullOrEmpty(model.CarouselImage) && model.CarouselImage != "[]")
            {
                List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(model.CarouselImage);
                //轮播图
                foreach (var item in CarouselIdList)
                {
                    model.CarouselImageList.Add(new RB_ImageCommonModel()
                    {
                        Id = 0,
                        Name = "",
                        Path = item
                    });
                }
            }
            model.CustomShareImagePath = model.CustomShareImage;

            #region 可预定日期
            model.TargetDateList = goods_TargetDateRepository.GetList(new RB_Goods_TargetDate_Extend() { GoodsId = goodsId });
            #endregion
            if (!string.IsNullOrEmpty(model.LineDescription) && model.LineDescription != "[]")
            {
                model.LineDescriptionList = JsonConvert.DeserializeObject<List<string>>(model.LineDescription);
            }
            return model;
        }

        /// <summary>
        /// 新增修改商品信息
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetProductGoodsInfo(RB_Goods_Extend demodel)
        {
            var goodsModel = new RB_Goods();
            if (demodel.Id > 0)
            {
                goodsModel = goodsRepository.GetEntity(demodel.Id);
                if (goodsModel == null)
                {
                    return false;
                }
            }
            try
            {
                if (demodel.Id > 0)
                {
                    //修改
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Goods.Name),demodel.Name},
                        { nameof(RB_Goods.CarouselImage),demodel.CarouselImage},
                        { nameof(RB_Goods.VideoAddress),demodel.VideoAddress},
                        { nameof(RB_Goods.CustomShareTitles),demodel.CustomShareTitles},
                        { nameof(RB_Goods.CustomShareImage),demodel.CustomShareImage},
                        { nameof(RB_Goods.GoodsStatus),demodel.GoodsStatus},
                        { nameof(RB_Goods.InventoryNum),demodel.InventoryNum},
                        { nameof(RB_Goods.DefaultSpecificationName),demodel.DefaultSpecificationName},
                        { nameof(RB_Goods.IsCustomSpecification),demodel.IsCustomSpecification},
                        { nameof(RB_Goods.Sort),demodel.Sort},
                        { nameof(RB_Goods.SellingPrice),demodel.SellingPrice},
                        { nameof(RB_Goods.OriginalPrice),demodel.OriginalPrice},
                        { nameof(RB_Goods.Unit),demodel.Unit},
                        { nameof(RB_Goods.CostPrice),demodel.CostPrice},
                        { nameof(RB_Goods.IsGoodsNegotiable),demodel.IsGoodsNegotiable},
                        { nameof(RB_Goods.SalesNum),demodel.SalesNum},
                        { nameof(RB_Goods.GoodsNumbers),demodel.GoodsNumbers},
                        { nameof(RB_Goods.GoodsWeight),demodel.GoodsWeight},
                        { nameof(RB_Goods.IsDefaultService),demodel.IsDefaultService},
                        { nameof(RB_Goods.GoodsService),demodel.GoodsService},
                        { nameof(RB_Goods.FreightId),demodel.FreightId},
                        { nameof(RB_Goods.FormsId),demodel.FormsId},
                        { nameof(RB_Goods.LimitBuyGoodsNum),demodel.LimitBuyGoodsNum},
                        { nameof(RB_Goods.LimitBuyOrderNum),demodel.LimitBuyOrderNum},
                        { nameof(RB_Goods.FullNumPinkage),demodel.FullNumPinkage},
                        { nameof(RB_Goods.FullMoneyPinkage),demodel.FullMoneyPinkage},
                        { nameof(RB_Goods.IsAreaBuy),demodel.IsAreaBuy},
                        { nameof(RB_Goods.IntegralPresent),demodel.IntegralPresent},
                        { nameof(RB_Goods.IntegralPresentType),demodel.IntegralPresentType},
                        { nameof(RB_Goods.PointsDeduction),demodel.PointsDeduction},
                        { nameof(RB_Goods.PointsDeductionType),demodel.PointsDeductionType},
                        { nameof(RB_Goods.IsMultipleDeduction),demodel.IsMultipleDeduction},
                        { nameof(RB_Goods.GoodsDetails),demodel.GoodsDetails},
                        { nameof(RB_Goods.UpdateDate),demodel.UpdateDate},
                        { nameof(RB_Goods.SeparateDistribution),demodel.SeparateDistribution},
                        { nameof(RB_Goods.SeparateDistributionType),demodel.SeparateDistributionType},
                        { nameof(RB_Goods.SeparateDistributionMoneyType),demodel.SeparateDistributionMoneyType},
                        { nameof(RB_Goods.EnjoyMember),demodel.EnjoyMember},
                        { nameof(RB_Goods.SeparateSetMember),demodel.SeparateSetMember},
                        { nameof(RB_Goods.IsQuickBuy),demodel.IsQuickBuy},
                        { nameof(RB_Goods.SupplierId),demodel.SupplierId},
                        { nameof(RB_Goods.IsProxy),demodel.IsProxy},
                        { nameof(RB_Goods.ProxyType),demodel.ProxyType},
                        { nameof(RB_Goods.ProxyRises),demodel.ProxyRises},
                        { nameof(RB_Goods.ProxyMoney),demodel.ProxyMoney},
                        { nameof(RB_Goods.Commission),demodel.Commission},
                        { nameof(RB_Goods.PresentFXGrade),demodel.PresentFXGrade},
                        { nameof(RB_Goods.PresentFXMonth),demodel.PresentFXMonth},
                        { nameof(RB_Goods.Advertising),demodel.Advertising},
                        { nameof(RB_Goods.SubName),demodel.SubName},
                        { nameof(RB_Goods.MarketingLogo),demodel.MarketingLogo},
                        { nameof(RB_Goods.IsLiveGoods),demodel.IsLiveGoods},
                        { nameof(RB_Goods.ShelvesDate),demodel.ShelvesDate },
                        { nameof(RB_Goods.DownDate),demodel.DownDate },
                         { nameof(RB_Goods.SendArea),demodel.SendArea },

                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods.Id),
                              FiledValue=demodel.Id,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods.TenantId),
                              FiledValue=demodel.TenantId,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods.MallBaseId),
                              FiledValue=demodel.MallBaseId,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    bool flag = goodsRepository.Update(keyValues, wheres);
                    if (flag)
                    {
                        #region 修改可预定日期
                        var tdlist = goods_TargetDateRepository.GetList(new RB_Goods_TargetDate_Extend() { GoodsId = demodel.Id });
                        var tdinsertList = demodel.TargetDateList.Where(x => !tdlist.Select(y => y.Date).Contains(x.Date)).ToList();
                        var tddeleteList = tdlist.Where(x => !demodel.TargetDateList.Select(y => y.Date).Contains(x.Date)).ToList();
                        foreach (var item in tdinsertList)
                        {
                            goods_TargetDateRepository.Insert(new RB_Goods_TargetDate()
                            {
                                Id = 0,
                                GoodsId = demodel.Id,
                                Date = item.Date
                            });
                        }
                        foreach (var item in tddeleteList)
                        {
                            goods_TargetDateRepository.Delete(item);
                        }
                        #endregion

                        #region 修改分类
                        var clist = goods_CategoryRepository.GetList(new RB_Goods_Category_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                        var insertList = demodel.CategoryList.Where(x => !clist.Select(y => y.CategoryId).Contains(x.CategoryId)).ToList();
                        var deleteList = clist.Where(x => !demodel.CategoryList.Select(y => y.CategoryId).Contains(x.CategoryId)).ToList();
                        foreach (var item in insertList)
                        {
                            goods_CategoryRepository.Insert(new RB_Goods_Category()
                            {
                                CategoryId = item.CategoryId,
                                CreateDate = demodel.CreateDate,
                                GoodsId = demodel.Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            });
                        }
                        foreach (var item in deleteList)
                        {
                            goods_CategoryRepository.Delete(item.Id);
                        }
                        #endregion

                        #region 修改区域
                        var alist = goods_AreaRepository.GetList(new RB_Goods_Area_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                        var insertList1 = demodel.AreaList.Where(x => !alist.Select(y => y.AreaId).Contains(x.AreaId)).ToList();
                        var deleteList1 = alist.Where(x => !demodel.AreaList.Select(y => y.AreaId).Contains(x.AreaId)).ToList();
                        foreach (var item in insertList1)
                        {
                            goods_AreaRepository.Insert(new RB_Goods_Area()
                            {
                                AreaId = item.AreaId,
                                AreaType = item.AreaType,
                                CreateDate = demodel.CreateDate,
                                GoodsId = demodel.Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            });
                        }
                        foreach (var item in deleteList1)
                        {
                            goods_AreaRepository.Delete(item.Id);
                        }


                        #endregion

                        #region 修改分销佣金
                        if (demodel.SeparateDistribution == 1)
                        {
                            //价格新增/更新
                            var dclist = goods_DistributionCommissionRepository.GetList(new RB_Goods_DistributionCommission_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                            if (dclist.Count() != demodel.DistributionCommissionList.Count()
                                || dclist.Count() != demodel.DistributionCommissionList.Where(x => dclist.Select(y => y.SpecificationSort).Contains(x.SpecificationSort)).Count()
                                || dclist.Select(x => x.DistributorGrade).Distinct().Count() != demodel.DistributionCommissionList.Select(x => x.DistributorGrade).Distinct().Count()
                                || dclist.Select(x => x.DistributorGrade).Distinct().Count() != dclist.Select(x => x.DistributorGrade).Distinct().Where(x => demodel.DistributionCommissionList.Select(y => y.DistributorGrade).Distinct().Contains(x)).Count())
                            {
                                goods_DistributionCommissionRepository.DeleteBatch(dclist);
                                foreach (var item in demodel.DistributionCommissionList)
                                {
                                    goods_DistributionCommissionRepository.Insert(new RB_Goods_DistributionCommission()
                                    {
                                        CreateDate = demodel.CreateDate,
                                        GoodsId = demodel.Id,
                                        Id = 0,
                                        DistributorGrade = item.DistributorGrade,
                                        OneCommission = item.OneCommission,
                                        ThreeCommission = item.ThreeCommission,
                                        TwoCommission = item.TwoCommission,
                                        MallBaseId = demodel.MallBaseId,
                                        SpecificationSort = item.SpecificationSort,
                                        Status = 0,
                                        TenantId = demodel.TenantId,
                                        UpdateDate = demodel.UpdateDate
                                    });
                                }
                            }
                            else
                            {

                                foreach (var item in dclist)
                                {
                                    var pupmodel = demodel.DistributionCommissionList.Where(x => x.SpecificationSort == item.SpecificationSort && x.DistributorGrade == item.DistributorGrade).FirstOrDefault();
                                    if (item.OneCommission != pupmodel.OneCommission || item.TwoCommission != pupmodel.TwoCommission || item.ThreeCommission != pupmodel.ThreeCommission)
                                    {
                                        Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                            { nameof(RB_Goods_DistributionCommission.OneCommission),pupmodel.OneCommission},
                                            { nameof(RB_Goods_DistributionCommission.TwoCommission),pupmodel.TwoCommission},
                                            { nameof(RB_Goods_DistributionCommission.ThreeCommission),pupmodel.ThreeCommission}
                                        };
                                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                            new WhereHelper(){
                                                    FiledName=nameof(RB_Goods_DistributionCommission.Id),
                                                    FiledValue=item.Id,
                                                    OperatorEnum=OperatorEnum.Equal
                                            }
                                        };
                                        goods_DistributionCommissionRepository.Update(keyValues1, wheres1);
                                    }
                                }
                            }
                        }
                        #endregion

                        #region 修改会员价格
                        if (demodel.EnjoyMember == 1 && demodel.SeparateSetMember == 1)
                        {
                            var mplist = goods_MemberPriceRepository.GetList(new RB_Goods_MemberPrice_Extend() { GoodsId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                            if (mplist.Count() != demodel.MemberPriceList.Count()
                                || mplist.Count() != demodel.MemberPriceList.Where(x => mplist.Select(y => y.SpecificationSort).Contains(x.SpecificationSort)).Count()
                                || mplist.Select(x => x.MemberGrade).Distinct().Count() != demodel.MemberPriceList.Select(x => x.MemberGrade).Distinct().Count()
                                || mplist.Select(x => x.MemberGrade).Distinct().Count() != mplist.Select(x => x.MemberGrade).Distinct().Where(x => demodel.MemberPriceList.Select(y => y.MemberGrade).Distinct().Contains(x)).Count())
                            {
                                goods_MemberPriceRepository.DeleteBatch(mplist);
                                foreach (var item in demodel.MemberPriceList)
                                {
                                    goods_MemberPriceRepository.Insert(new RB_Goods_MemberPrice()
                                    {
                                        CreateDate = demodel.CreateDate,
                                        GoodsId = demodel.Id,
                                        Id = 0,
                                        MemberGrade = item.MemberGrade,
                                        MemberPrice = item.MemberPrice,
                                        MallBaseId = demodel.MallBaseId,
                                        SpecificationSort = item.SpecificationSort,
                                        Status = 0,
                                        TenantId = demodel.TenantId,
                                        UpdateDate = demodel.UpdateDate
                                    });
                                }
                            }
                            else
                            {

                                foreach (var item in mplist)
                                {
                                    var pupmodel = demodel.MemberPriceList.Where(x => x.SpecificationSort == item.SpecificationSort && x.MemberGrade == item.MemberGrade).FirstOrDefault();
                                    if (item.MemberPrice != pupmodel.MemberPrice)
                                    {
                                        Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                            { nameof(RB_Goods_MemberPrice.MemberPrice),pupmodel.MemberPrice}
                                        };
                                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                            new WhereHelper(){
                                                    FiledName=nameof(RB_Goods_MemberPrice.Id),
                                                    FiledValue=item.Id,
                                                    OperatorEnum=OperatorEnum.Equal
                                            }
                                        };
                                        goods_MemberPriceRepository.Update(keyValues1, wheres1);
                                    }
                                }
                            }
                        }
                        #endregion
                    }
                }
                else
                {
                    int Id = goodsRepository.Insert(demodel);
                    bool flag = Id > 0;
                    if (flag)
                    {
                        //插入可预定日期
                        foreach (var item in demodel.TargetDateList)
                        {
                            goods_TargetDateRepository.Insert(new RB_Goods_TargetDate()
                            {
                                Id = 0,
                                GoodsId = Id,
                                Date = item.Date
                            });
                        }
                        //插入分类
                        foreach (var item in demodel.CategoryList)
                        {
                            goods_CategoryRepository.Insert(new RB_Goods_Category()
                            {
                                CategoryId = item.CategoryId,
                                CreateDate = demodel.CreateDate,
                                GoodsId = Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            });
                        }
                        //插入区域
                        foreach (var item in demodel.AreaList)
                        {
                            goods_AreaRepository.Insert(new RB_Goods_Area()
                            {
                                AreaId = item.AreaId,
                                AreaType = item.AreaType,
                                CreateDate = demodel.CreateDate,
                                GoodsId = Id,
                                Id = 0,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId
                            });
                        }
                        //插入分销佣金
                        if (demodel.SeparateDistribution == 1)
                        {
                            foreach (var item in demodel.DistributionCommissionList)
                            {
                                goods_DistributionCommissionRepository.Insert(new RB_Goods_DistributionCommission()
                                {
                                    CreateDate = demodel.CreateDate,
                                    GoodsId = Id,
                                    Id = 0,
                                    DistributorGrade = item.DistributorGrade,
                                    OneCommission = item.OneCommission,
                                    ThreeCommission = item.ThreeCommission,
                                    TwoCommission = item.TwoCommission,
                                    MallBaseId = demodel.MallBaseId,
                                    SpecificationSort = item.SpecificationSort,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    UpdateDate = demodel.UpdateDate
                                });
                            }
                        }
                        //插入会员价格
                        if (demodel.EnjoyMember == 1 && demodel.SeparateSetMember == 1)
                        {
                            foreach (var item in demodel.MemberPriceList)
                            {
                                goods_MemberPriceRepository.Insert(new RB_Goods_MemberPrice()
                                {
                                    CreateDate = demodel.CreateDate,
                                    GoodsId = Id,
                                    Id = 0,
                                    MemberGrade = item.MemberGrade,
                                    MemberPrice = item.MemberPrice,
                                    MallBaseId = demodel.MallBaseId,
                                    SpecificationSort = item.SpecificationSort,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    UpdateDate = demodel.UpdateDate
                                });
                            }
                        }
                    }
                }

                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetProductGoodsInfoSD:" + Common.Plugin.JsonHelper.Serialize(demodel));
                return false;
            }
        }

        /// <summary>
        /// 删除商品
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelProcudtGoodsInfo(int goodsId, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Goods.Status),1},
                { nameof(RB_Goods.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.Id),
                        FiledValue=goodsId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return goodsRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 设置商品上下架
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetGoodsStatusInfo(int goodsId, int tenantId, int mallBaseId)
        {
            var goodsModel = goodsRepository.GetEntity(goodsId);
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Goods.GoodsStatus),(goodsModel?.GoodsStatus??0)==1?2:1},
                { nameof(RB_Goods.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.Id),
                        FiledValue=goodsId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Goods.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return goodsRepository.Update(keyValues, wheres);
        }

        #endregion



        #region 站点配置
        /// <summary>
        /// 站点配置列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_Site_Extend> GetGuideCarSiteList(int pageIndex, int pageSize, out long rowCount, RB_GuideCar_Site_Extend query)
        {
            List<RB_GuideCar_Site_Extend> list = SiteRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
            if (list != null && list.Any())
            {
                List<RB_GuideCar_SiteRegion_Extend> listLogisticsRulesRegion = SiteRegionRepository.GetListRepository(new RB_GuideCar_SiteRegion_Extend { TenantId = query.TenantId, SiteType = 1, MallBaseId = query.MallBaseId, SiteIds = string.Join(",", list.Select(x => x.ID)) });
                foreach (var item in list)
                {
                    item.RegionList = new List<RB_GuideCar_SiteRegion_Extend>();
                    item.RegionList = listLogisticsRulesRegion.Where(x => x.SiteId == item.ID).ToList();
                }
            }
            return list;
        }

        /// <summary>
        /// 站点配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_GuideCar_Site_Extend GetGuideCarSiteModel(RB_GuideCar_Site_Extend query)
        {
            RB_GuideCar_Site_Extend model = SiteRepository.GetGuideCarSiteList(query).FirstOrDefault();
            if (model != null)
            {
                List<RB_GuideCar_SiteRegion_Extend> listLogisticsRulesRegion = SiteRegionRepository.GetListRepository(new RB_GuideCar_SiteRegion_Extend { TenantId = query.TenantId, SiteType = query.SiteType, MallBaseId = query.MallBaseId, SiteId = model.ID });
                model.RegionList = new List<RB_GuideCar_SiteRegion_Extend>();
                model.RegionList = listLogisticsRulesRegion;
            }

            return model;
        }



        /// <summary>
        /// 站点配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_GuideCar_Site_Extend> GetGuideCarSiteList(RB_GuideCar_Site_Extend query)
        {
            return SiteRepository.GetGuideCarSiteList(query);
        }

        /// <summary>
        /// 新增/修改站点配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateGuideCarSite(RB_GuideCar_Site_Extend model)
        {
            bool flag = false;
            var trans = SiteRepository.DbTransaction;
            try
            {
                int rulesId = 0;
                if (model.ID == 0)
                {
                    rulesId = SiteRepository.Insert(model, trans);
                    flag = rulesId > 0;
                }
                else
                {
                    rulesId = model.ID;
                    flag = SiteRepository.Update(model, trans);

                    List<RB_GuideCar_SiteRegion_Extend> listLogisticsRulesRegion = SiteRegionRepository.GetListRepository(new RB_GuideCar_SiteRegion_Extend { TenantId = model.TenantId, SiteType = model.SiteType, MallBaseId = model.MallBaseId, SiteId = model.ID });

                    //删除之前的区域
                    foreach (var itemRegion in listLogisticsRulesRegion.Where(x => x.SiteId == model.ID))
                    {
                        IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_GuideCar_SiteRegion.Status),1},
                                    { nameof(RB_GuideCar_SiteRegion.UpdateDate),System.DateTime.Now},
                                  };
                        IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_GuideCar_SiteRegion.ID),FiledValue=itemRegion.ID,OperatorEnum=OperatorEnum.Equal}
                                };
                        SiteRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                    }
                }
                if (model.RegionList != null && model.RegionList.Any())
                {
                    model.RegionList.ForEach(x => x.TenantId = model.TenantId);
                    model.RegionList.ForEach(x => x.CreateDate = System.DateTime.Now);
                    model.RegionList.ForEach(x => x.ID = 0);
                    model.RegionList.ForEach(x => x.SiteId = rulesId);
                    model.RegionList.ForEach(x => x.SiteType = model.SiteType);
                    model.RegionList.ForEach(x => x.MallBaseId = model.MallBaseId);
                    SiteRegionRepository.InsertBatch(model.RegionList, trans);
                }

                SiteRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateGuideCarSite");
                SiteRepository.DBSession.Rollback("AddOrUpdateGuideCarSite");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除站点配置
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelGuideCarSiteInfo(int id, int uid, int mallBaseId)
        {
            var trans = SiteRepository.DbTransaction;
            bool flag;
            try
            {
                Dictionary<string, object> cols = new Dictionary<string, object>()
                {
                    { nameof(RB_GuideCar_Site.Status),1},
                    { nameof(RB_GuideCar_Site.UpdateDate),DateTime.Now},
                };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_GuideCar_Site.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_GuideCar_Site.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_GuideCar_Site.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
                flag = SiteRepository.Update(cols, wheres1, trans);

                IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_GuideCar_SiteRegion.Status),1},
                                    { nameof(RB_GuideCar_SiteRegion.UpdateDate),System.DateTime.Now},
                                  };
                IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_GuideCar_SiteRegion.SiteId),FiledValue=id,OperatorEnum=OperatorEnum.Equal},
                new WhereHelper(){
                        FiledName=nameof(RB_GuideCar_SiteRegion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_GuideCar_SiteRegion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }  };
                flag = SiteRegionRepository.Update(filedsRegion, whereHelpersRegion, trans);
                SiteRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelGuideCarSiteInfo");
                SiteRepository.DBSession.Rollback("DelGuideCarSiteInfo");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 批量启用/禁用站点
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool EnableGuideCarSiteInfo(List<string> ids, int IsEnable, int uid, int mallBaseId)
        {
            var trans = SiteRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_GuideCar_Site.IsEnable),IsEnable},
                            { nameof(RB_GuideCar_Site.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_GuideCar_Site.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_GuideCar_Site.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_GuideCar_Site.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = SiteRepository.Update(cols, wheres1, trans);
                    }
                }
                SiteRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "EnableGuideCarSiteInfo");
                SiteRepository.DBSession.Rollback("EnableGuideCarSiteInfo");
                return false;
            }
            return flag;
        }

        #endregion

        #region 导游信息
        /// <summary>
        ///导游配置列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_Guide_Extend> GetGuidePageListRepository(int pageIndex, int pageSize, out long rowCount, RB_GuideCar_Guide_Extend query)
        {
            List<RB_GuideCar_Guide_Extend> list = GuideRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);

            return list;
        }

        /// <summary>
        /// 导游配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_GuideCar_Guide_Extend GetGuideCarGuideModel(RB_GuideCar_Guide_Extend query)
        {
            RB_GuideCar_Guide_Extend model = GuideRepository.GetGuideCarGuideList(query).FirstOrDefault();

            return model;
        }


        /// <summary>
        /// 导游配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_GuideCar_Guide_Extend> GetGuideCarGuideList(RB_GuideCar_Guide_Extend query)
        {
            return GuideRepository.GetGuideCarGuideList(query);
        }
        /// <summary>
        /// 新增/修改导游配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateGuideCarGuide(RB_GuideCar_Guide_Extend model)
        {
            bool flag = false;
            try
            {

                if (model.ID == 0)
                {
                    flag = GuideRepository.Insert(model) > 0;
                }
                else
                {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_GuideCar_Guide_Extend.GuidePhoto),model.GuidePhoto},
                        { nameof(RB_GuideCar_Guide_Extend.Name),model.Name},
                        { nameof(RB_GuideCar_Guide_Extend.SiteId),model.SiteId},
                        { nameof(RB_GuideCar_Guide_Extend.Telephone),model.Telephone},
                        { nameof(RB_GuideCar_Guide_Extend.Introduction),model.Introduction},
                        { nameof(RB_GuideCar_Guide_Extend.EmergencyPhone),model.EmergencyPhone},
                        { nameof(RB_GuideCar_Guide_Extend.WorkYears),model.WorkYears}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_GuideCar_Guide_Extend.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    flag = GuideRepository.Update(keyValues, wheres);
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateGuideCarGuide");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 批量启用/禁用导游
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool EnableGuideCarGuideInfo(List<string> ids, int IsEnable, int uid, int mallBaseId)
        {
            var trans = GuideRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_GuideCar_Guide.IsEnable),IsEnable},
                            { nameof(RB_GuideCar_Guide.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_GuideCar_Site.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_GuideCar_Site.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_GuideCar_Site.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = GuideRepository.Update(cols, wheres1, trans);
                    }
                }
                GuideRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "EnableGuideCarGuideInfo");
                GuideRepository.DBSession.Rollback("EnableGuideCarGuideInfo");
                return false;
            }
            return flag;
        }
        #endregion

        #region 车辆信息
        /// <summary>
        /// 车辆列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_GuideCar_Car_Extend> GetGuideCarPageList(int pageIndex, int pageSize, out long rowCount, RB_GuideCar_Car_Extend query)
        {
            List<RB_GuideCar_Car_Extend> list = GuideCarRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
            if (list != null && list.Any())
            {
                List<RB_GuideCar_CarColor_Extend> listCarColor = CarColorRepository.GetCarColorList(new RB_GuideCar_CarColor_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CardIds = string.Join(",", list.Select(x => x.ID)) });
                if (listCarColor != null && listCarColor.Any())
                {
                    listCarColor.Where(x => !string.IsNullOrWhiteSpace(x.CarPic)).ToList().ForEach(x => x.PicList = JsonConvert.DeserializeObject<List<string>>(x.CarPic));
                }
                foreach (var item in list)
                {
                    item.ColorList = new List<RB_GuideCar_CarColor_Extend>();
                    item.ColorList = listCarColor.Where(x => x.CarId == item.ID).ToList();

                }
            }
            return list;
        }

        /// <summary>
        /// 车辆
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_GuideCar_Car_Extend GetGuideCarModel(RB_GuideCar_Car_Extend query)
        {
            RB_GuideCar_Car_Extend model = GuideCarRepository.GetGuideCarCarList(query).FirstOrDefault();
            if (model != null)
            {
                List<RB_GuideCar_CarColor_Extend> listCarColor = CarColorRepository.GetCarColorList(new RB_GuideCar_CarColor_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CarId = model.ID });
                if (listCarColor != null && listCarColor.Any())
                {
                    listCarColor.Where(x => !string.IsNullOrWhiteSpace(x.CarPic)).ToList().ForEach(x => x.PicList = JsonConvert.DeserializeObject<List<string>>(x.CarPic));
                }
                model.ColorList = new List<RB_GuideCar_CarColor_Extend>();
                model.ColorList = listCarColor;
            }

            return model;
        }



        /// <summary>
        /// 车辆
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_GuideCar_Car_Extend> GetGuideCarList(RB_GuideCar_Car_Extend query)
        {
            var list = GuideCarRepository.GetGuideCarCarList(query);
            if (list != null && list.Any())
            {
                List<RB_GuideCar_CarColor_Extend> listCarColor = CarColorRepository.GetCarColorList(new RB_GuideCar_CarColor_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CardIds = string.Join(",", list.Select(x => x.ID)) });
                if (listCarColor != null && listCarColor.Any())
                {
                    listCarColor.Where(x => !string.IsNullOrWhiteSpace(x.CarPic)).ToList().ForEach(x => x.PicList = JsonConvert.DeserializeObject<List<string>>(x.CarPic));
                }
                foreach (var item in list)
                {
                    item.ColorList = new List<RB_GuideCar_CarColor_Extend>();
                    item.ColorList = listCarColor.Where(x => x.CarId == item.ID).ToList();

                }
            }
            return list;
        }

        /// <summary>
        /// 新增/修改车辆
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateGuideCar(RB_GuideCar_Car_Extend model)
        {
            bool flag = false;
            var trans = GuideCarRepository.DbTransaction;
            try
            {
                int rulesId = 0;
                if (model.ID == 0)
                {
                    rulesId = GuideCarRepository.Insert(model, trans);
                    flag = rulesId > 0;
                }
                else
                {
                    rulesId = model.ID;
                    flag = GuideCarRepository.Update(model, trans);

                    List<RB_GuideCar_CarColor_Extend> listLogisticsRulesRegion = CarColorRepository.GetCarColorList(new RB_GuideCar_CarColor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CarId = model.ID });

                    //List<string> ColorListdExcept = new List<string>();

                    //if (model.ColorList != null && model.ColorList.Any())
                    //{
                    //    if (listLogisticsRulesRegion != null && listLogisticsRulesRegion.Any())
                    //    {
                    //        //颜色差集
                    //        ColorListdExcept = model.ColorList.Select(x => x.ID.ToString()).Except(listLogisticsRulesRegion.Select(x => x.ID.ToString())).ToList();
                    //    }
                    //    foreach (var item in listLogisticsRulesRegion.Where(x => ColorListdExcept.Contains(x.ID.ToString())))
                    //    {
                    //        IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                    //             {
                    //                { nameof(RB_GuideCar_CarColor_Extend.Status),1},
                    //                { nameof(RB_GuideCar_CarColor_Extend.UpdateDate),System.DateTime.Now},
                    //              };
                    //        IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                    //            {
                    //                new WhereHelper (){ FiledName=nameof(RB_GuideCar_CarColor_Extend.ID),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal}
                    //            };
                    //        CarColorRepository.Update(filedsRegion, whereHelpersRegion, trans);
                    //    }
                    //}
                    //else
                    //{ //全部删除
                    foreach (var itemRegion in listLogisticsRulesRegion.Where(x => x.CarId == model.ID))
                    {
                        IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//删除价格下面对应的地区
                                 {
                                    { nameof(RB_GuideCar_CarColor_Extend.Status),1},
                                    { nameof(RB_GuideCar_CarColor_Extend.UpdateDate),System.DateTime.Now},
                                  };
                        IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_GuideCar_CarColor_Extend.ID),FiledValue=itemRegion.ID,OperatorEnum=OperatorEnum.Equal}
                                };
                        CarColorRepository.Update(filedsRegion, whereHelpersRegion, trans);
                    }
                    //}
                }
                if (model.ColorList != null && model.ColorList.Any())
                {
                    foreach (var item in model.ColorList)
                    {
                        if (item.ID == 0)
                        {
                            item.TenantId = model.TenantId;
                            item.CreateDate = System.DateTime.Now;
                            item.ID = 0;
                            item.CarId = rulesId;
                            item.MallBaseId = model.MallBaseId;
                            CarColorRepository.Insert(item, trans);
                        }
                        else
                        {
                            IDictionary<string, object> filedsRegion = new Dictionary<string, object>()//更新之前的信息
                                 {
                                    { nameof(RB_GuideCar_CarColor_Extend.ColorName),item.ColorName},
                                     { nameof(RB_GuideCar_CarColor_Extend.Status),0},
                                     { nameof(RB_GuideCar_CarColor_Extend.CarPic),item.CarPic},
                                    { nameof(RB_GuideCar_CarColor_Extend.UpdateDate),System.DateTime.Now},
                                  };
                            IList<WhereHelper> whereHelpersRegion = new List<WhereHelper>()
                                {
                                    new WhereHelper (){ FiledName=nameof(RB_GuideCar_CarColor_Extend.ID),FiledValue=item.ID,OperatorEnum=OperatorEnum.Equal}
                                };
                            CarColorRepository.Update(filedsRegion, whereHelpersRegion, trans);
                        }
                    }
                }
                GuideCarRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateGuideCar");
                GuideCarRepository.DBSession.Rollback("AddOrUpdateGuideCar");
                return false;
            }
            return flag;
        }
        #endregion
    }
}
