﻿using System;
using Aliyun.OSS;
using Mall.Education.Common;
using Mall.Education.Helper;

namespace COSSnippet
{
    public class AliOSSUploadObject
    {
        public string endpoint;
        public string accessKeyId;
        public string accessKeySecret;
        public string bucketName;

        public AliOSSUploadObject(int MallBaseId) {            
            var ds = FileDataHelper.GetMallBaseFileInfo(MallBaseId, 2);
            if (ds.Tables[0].Rows.Count > 0)
            {
                endpoint = ds.Tables[0].Rows[0]["Region"].ToString();
                accessKeyId = ds.Tables[0].Rows[0]["SecretId"].ToString();
                accessKeySecret = ds.Tables[0].Rows[0]["SecretKey"].ToString();
                bucketName = ds.Tables[0].Rows[0]["Bucket"].ToString();
            }
            else {
                //使用默认值
                endpoint = Config.GetAppSetting("Ali_OSS_REGION");
                accessKeyId = Config.GetAppSetting("Ali_OSS_SECRETID");
                accessKeySecret = Config.GetAppSetting("Ali_OSS_SECRETKEY");
                bucketName = Config.GetAppSetting("Ali_OSS_BUCKET");
            }
        }

        /// 上传对象
        public void TransferUploadFile(string filePath,string AliFileName)
        {
            var objectName = AliFileName;
            var localFilename = filePath;
            // 创建OssClient实例。
            var client = new OssClient(endpoint, accessKeyId, accessKeySecret);
            try
            {
                // 上传文件。
                client.PutObject(bucketName, objectName, localFilename);
            }
            catch (Exception ex)
            {                
                LogHelper.Write(ex, "AliOSSUploadObject");
            }
        }

        /// <summary>
        /// 删除文件
        /// </summary>
        /// <param name="Key"></param>
        public void TransferUpladDel(string Key) {
            var objectName = Key;
            // 创建OssClient实例。
            var client = new OssClient(endpoint, accessKeyId, accessKeySecret);
            try
            {
                // 删除文件。
                client.DeleteObject(bucketName, objectName);
                Console.WriteLine("Delete object succeeded");
            }
            catch (Exception ex)
            {
                Console.WriteLine("Delete object failed. {0}", ex.Message);
            }
        }
    }
}