﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// FAT咨询仓储层
    /// </summary>
    public class RB_Commerce_AskRepository:BaseRepository<RB_Commerce_Ask>
    {
        /// <summary>
        /// 获取FAT咨询分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Ask_Extend> GetCommerceAskPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Ask_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*, 
FROM RB_Commerce_Ask AS A  
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Ask_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Commerce_Ask_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Ask_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Commerce_Ask_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.FatTitle))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Commerce_Ask_Extend.FatTitle));
                    parameters.Add("Name", "%" + query.FatTitle.Trim() + "%");
                }
            }
            return GetPage<RB_Commerce_Ask_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
