﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using Mall.Repository.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.BaseSetUp
{
    public class MallBaseModule
    {
        private RB_MallBaseRepository mallBaseRepository = new RB_MallBaseRepository();
        private RB_LogisticsRepository logisticsRepository = new RB_LogisticsRepository();
        private RB_LogisticsRulesPriceRepository logisticsRulesPriceRepository = new RB_LogisticsRulesPriceRepository();
        private RB_LogisticsRulesRegionRepository logisticsRulesRegionRepository = new RB_LogisticsRulesRegionRepository();
        private RB_LogisticsRulesRepository logisticsRulesRepository = new RB_LogisticsRulesRepository();

        #region 基础设置
        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MallBase_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_MallBase_Extend query)
        {
            return mallBaseRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MallBase_Extend> GetListRepository(RB_MallBase_Extend query)
        {
            return mallBaseRepository.GetListRepository(query);
        }


        /// <summary>
        /// 根据编号获取实体
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>

        public RB_MallBase GetMallBaseEntity(int ID)
        {
            return mallBaseRepository.GetEntity(ID);
        }


        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateMallBase(RB_MallBase model)
        {
            if (model.ID == 0)
            {
                return mallBaseRepository.Insert(model) > 0;
            }
            else
            {
                return mallBaseRepository.Update(model);
            }
        }
        #endregion


        #region 物流设置
        /// <summary>
        /// 根据商户id获取物流信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics> GetLogisticsList(RB_Logistics query)
        {
            return logisticsRepository.GetListRepository(query);
        }


        /// <summary>
        /// 新增/修改基础信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateLogistics(RB_Logistics model)
        {
            if (model.ID == 0)
            {
                return logisticsRepository.Insert(model) > 0;
            }
            else
            {
                return logisticsRepository.Update(model);
            }
        }
        #endregion

        #region 物流规则设置
        /// <summary>
        /// 物料规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_LogisticsRules_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_LogisticsRules_Extend query)
        {
            return logisticsRulesRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 物流规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_LogisticsRules_Extend> GetLogisticsRulesList(RB_LogisticsRules_Extend query)
        {
            return logisticsRulesRepository.GetLogisticsRulesList(query);
        }

        public RB_LogisticsRules_Extend GetLogisticsRulesModel(RB_LogisticsRules_Extend query)
        {
            RB_LogisticsRules_Extend model = logisticsRulesRepository.GetLogisticsRulesList(query).FirstOrDefault();
            //获取价格规则
            List<RB_LogisticsRulesPrice_Extend> ListPrice = logisticsRulesPriceRepository.GetListRepository(new RB_LogisticsRulesPrice_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, RulesId = query.ID });

            List<RB_LogisticsRulesRegion_Extend> listLogisticsRulesRegion = logisticsRulesRegionRepository.GetListRepository(new RB_LogisticsRulesRegion_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, PriceIds = string.Join(",", ListPrice.Select(x => x.ID)) });

            model.Detail = new List<RB_LogisticsRulesPrice_Extend>();
            model.Detail = ListPrice;

            foreach (var item in model.Detail)
            {
                item.List = new List<RB_LogisticsRulesRegion_Extend>();

            }

            return model;
        }

        #endregion

    }
}
