﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 视频表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Video
    {
        /// <summary>
        /// 视频编号
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 视频标题
        /// </summary>        
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// 视频来源(1-源地址，2-腾讯)
        /// </summary>        
        public int? SourceType
        {
            get;
            set;
        }

        /// <summary>
        /// 视频链接
        /// </summary>        
        public string VedioUrl
        {
            get;
            set;
        }

        /// <summary>
        /// 视频封面图
        /// </summary>        
        public string VedioCoverImg
        {
            get;
            set;
        }

        /// <summary>
        /// 视频详情介绍
        /// </summary>        
        public string VedioIntro
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
    }
}
