﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Product;
using Mall.AOP;
using Mall.Model.Extend.GuideCar;
using Mall.Common.Enum.Goods;
using DotNetCore.CAP.Infrastructure;
using Mall.Model.Entity.GuideCar;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class GuideCarController : BaseController
    {

        private readonly GuideCarModule guideCarModule = new GuideCarModule();

        #region 基础配置
        /// <summary>
        /// 获取司导专区基础配置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarInfo()
        {
            var req = RequestParm;

            var model = guideCarModule.GetGuideCarInfo(req.TenantId, req.MallBaseId);
            return ApiResult.Success("", model);
        }

        /// <summary>
        /// 保存司导专区配置
        /// </summary>
        /// <returns></returns>
        public ApiResult SetGuideCarInfo()
        {
            var req = RequestParm;
            RB_GuideCar_Base_Extend demodel = JsonConvert.DeserializeObject<RB_GuideCar_Base_Extend>(req.msg.ToString());

            if (string.IsNullOrEmpty(demodel.PagePath))
            {
                return ApiResult.ParamIsNull("请输入详情页面链接地址");
            }

            demodel.OrderStateJson = "";
            if (demodel.OrderStateList != null && demodel.OrderStateList.Any())
            {
                demodel.OrderStateJson = JsonConvert.SerializeObject(demodel.OrderStateList);
            }
            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.UpdateBy = req.EmpId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            bool flag = guideCarModule.SetGuideCarInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion

        #region 商品管理

        /// <summary>
        /// 商品后台分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGoodsPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            JObject parameters = JObject.Parse(RequestParm.msg.ToString());
            RB_Goods_Extend demodel = new RB_Goods_Extend()
            {
                Name = parameters.GetStringValue("Name"),
                GoodsStatus = parameters.GetInt("GoodsStatus"),
                CategoryIds = parameters.GetStringValue("CategoryIds"),
                Id = parameters.GetInt("Id"),
                StartTime = parameters.GetStringValue("StartTime"),
                EndTime = parameters.GetStringValue("EndTime"),
                OrderBy = parameters.GetInt("OrderBy")
            };

            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = guideCarModule.GetProductGoodsPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Sort,
                x.CoverImage,
                CategoryList = x.CategoryList.Select(y => new { y.Id, y.CategoryName }),
                x.SellingPrice,
                x.GoodsBuyNum,
                x.GoodsStatus,
                x.TenantId,
                x.MallBaseId,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 商品导出
        /// </summary>
        [HttpPost]
        public FileContentResult GetProductGoodsListToExcel()
        {
            var parms = RequestParm;
            RB_Goods_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Extend>(parms.msg.ToString());
            string ExcelName = "司导商品列表" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30) {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "商品名称") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "原价") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "成本价") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "商品详情") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "商品缩略图") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "商品轮播图") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "商品视频") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "售价") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "赠送积分") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "赠送积分类型") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "可抵扣积分") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "可抵扣积分类型") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "允许多件累计折扣") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "自定义分享图片") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "自定义分享标题") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "排序") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "是否单独区域购买") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "区域限购详情") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "站点") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "导游") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "车辆") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "车辆颜色") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "车牌号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "是否拼座") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "乘坐人数") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                    new ExcelColumn(value: "提前预定时间") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                }
            };

            slist.Add(header);

            try
            {
                demodel.TenantId = parms.TenantId;
                demodel.MallBaseId = parms.MallBaseId;
                var list = guideCarModule.GetProductGoodsPageListToExcel(1, 10000, out long count, demodel);
                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    string AreaList = "";
                    if (item.IsAreaBuy == 1)
                    {
                        AreaList = JsonConvert.SerializeObject(item.AreaList.Select(x => new
                        {
                            x.Id,
                            x.GoodsId,
                            x.AreaId,
                            x.AreaName,
                            x.AreaType
                        }));
                    }

                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                            new ExcelColumn(value:item.Name){ },
                            new ExcelColumn(value:(item.OriginalPrice??0).ToString()){ },
                            new ExcelColumn(value:(item.CostPrice??0).ToString()){ },
                            new ExcelColumn(value:item.GoodsDetails){ },
                            new ExcelColumn(value:item.CoverImage){ },
                            new ExcelColumn(value:item.CarouselImage){ },
                            new ExcelColumn(value:item.VideoAddress){ },
                            new ExcelColumn(value:(item.SellingPrice??0).ToString()){ },
                            new ExcelColumn(value:(item.IntegralPresent??0).ToString()){ },
                            new ExcelColumn(value:(item.IntegralPresentType??0).ToString()){ },
                            new ExcelColumn(value:(item.PointsDeduction??0).ToString()){ },
                            new ExcelColumn(value:(item.PointsDeductionType??0).ToString()){ },
                            new ExcelColumn(value:(item.IsMultipleDeduction??0).ToString()){ },
                            new ExcelColumn(value:item.CustomShareImage ??""){ },
                            new ExcelColumn(value:item.CustomShareTitles ??""){ },
                            new ExcelColumn(value:(item.Sort??0).ToString()){ },
                            new ExcelColumn(value:(item.IsAreaBuy??0).ToString()){ },
                            new ExcelColumn(value:AreaList.ToString()){ },
                            new ExcelColumn(value:item.SiteName){ },
                            new ExcelColumn(value:item.GuideName){ },
                            new ExcelColumn(value:item.CarName){ },
                            new ExcelColumn(value:item.CarColorName){ },
                            new ExcelColumn(value:item.CarNumber){ },
                            new ExcelColumn(value:item.IsSpell==1?"是":"否"){ },
                            new ExcelColumn(value:(item.RideNum??0).ToString()){ },
                            new ExcelColumn(value:(item.AdvanceDay??0).ToString()+"天"){ },
                        }
                        ,
                        ColumnHight = 30
                    };
                    slist.Add(datarow);
                }
                #endregion

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);

                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

        }

        /// <summary>
        /// 获取商品详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGoodsInfo()
        {
            var req = RequestParm;
            JObject prams = JObject.Parse(req.msg.ToString());
            int GoodsId = prams.GetInt("GoodsId", 0);
            if (GoodsId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var model = guideCarModule.GetProductGoodsInfo(GoodsId, req.TenantId, req.MallBaseId);
            return ApiResult.Success("", new
            {
                model?.Id,
                model?.Name,
                model?.CarouselImageList,
                model?.VideoAddress,
                model?.CustomShareTitles,
                model?.CustomShareImage,
                model?.GoodsStatus,
                model?.Sort,
                model?.SellingPrice,
                model?.OriginalPrice,
                model?.CostPrice,
                model?.IsAreaBuy,
                model?.IntegralPresent,
                model?.IntegralPresentType,
                model?.PointsDeduction,
                model?.PointsDeductionType,
                model?.IsMultipleDeduction,
                model?.GoodsDetails,
                model?.SeparateDistribution,
                model?.SeparateDistributionType,
                model?.SeparateDistributionMoneyType,
                model?.EnjoyMember,
                model?.SeparateSetMember,
                model?.SupplierId,
                model?.Commission,
                model?.IsLiveGoods,
                CategoryList = model?.CategoryList.Select(x => new
                {
                    x.Id,
                    x.CategoryId,
                    x.CategoryName
                }),
                AreaList = model?.AreaList.Select(x => new
                {
                    x.Id,
                    x.AreaId,
                    x.AreaName,
                    x.AreaType
                }),
                DistributionCommissionList = model?.DistributionCommissionList.Select(x => new
                {
                    x.Id,
                    x.DistributorGrade,
                    x.OneCommission,
                    x.SpecificationSort,
                    x.ThreeCommission,
                    x.TwoCommission
                }),
                DistributionCommissionTreeList = model?.DistributionCommissionTreeList.Select(x => new
                {
                    x.Id,
                    x.SpecificationSort,
                    x.AttrList,
                    GradeCommissionList = x.GradeCommissionList.Select(y => new
                    {
                        y.DistributorGrade,
                        y.OneCommission,
                        y.ThreeCommission,
                        y.TwoCommission
                    })
                }),
                MemberPriceList = model?.MemberPriceList.Select(x => new
                {
                    x.Id,
                    x.MemberGrade,
                    x.MemberPrice,
                    x.SpecificationSort
                }),
                MemberPriceTreeList = model?.MemberPriceTreeList.Select(x => new
                {
                    x.Id,
                    x.SpecificationSort,
                    x.AttrList,
                    GradePriceList = x.GradePriceList.Select(y => new
                    {
                        y.MemberGrade,
                        y.MemberPrice
                    })
                }),
                model?.Advertising,
                model?.SubName,
                model?.MarketingLogo,
                model?.SiteId,
                model?.GuideId,
                model?.CarId,
                model?.CarColorId,
                model?.CarNumber,
                model?.CarBuyYear,
                model?.CarType,
                CarTypeName = model?.CarType.GetEnumName(),
                model?.UseDay,
                model?.LineName,
                model?.LineDescriptionList,
                model?.IsSpell,
                model?.RideNum,
                model?.AdvanceDay,
                model?.TargetDateList
            });
        }

        /// <summary>
        /// 获取可预定日期列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGoodsTargetDateList() {
            var req = RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int DayType = parms.GetInt("DayType", 1);//类型  1时间范围   2按周   3按月份
            string StartDate = parms.GetStringValue("StartDate");
            string EndDate = parms.GetStringValue("EndDate");
            string Year = parms.GetStringValue("Year");//年
            string Month = parms.GetStringValue("Month");//月
            int Week = parms.GetInt("Week", 1);//周几

            List<string> DateList = new List<string>();
            if (DayType == 1)
            {
                if (string.IsNullOrWhiteSpace(StartDate) || string.IsNullOrWhiteSpace(EndDate))
                {
                    return ApiResult.Failed("请选完善时间段");
                }
                else
                {
                    DateTime endDate = Convert.ToDateTime(EndDate);
                    for (DateTime dt = Convert.ToDateTime(StartDate); dt <= endDate;)
                    {
                        if (!DateList.Contains(dt.ToString("yyyy-MM-dd")))
                        {
                            DateList.Add(dt.ToString("yyyy-MM-dd"));
                        }
                        dt = dt.AddDays(1);
                    }
                }
            }
            else if (DayType == 2)
            {
                if (string.IsNullOrWhiteSpace(Month))
                {
                    return ApiResult.ParamIsNull("请选择月份");
                }
                DateTime StartTime = Convert.ToDateTime(Month + "-01");
                DateTime EndTime = StartTime.AddMonths(1).AddDays(-1);
                for (DateTime dt = StartTime; dt <= EndTime;)
                {
                    if (!DateList.Contains(dt.ToString("yyyy-MM-dd")))
                    {
                        DateList.Add(dt.ToString("yyyy-MM-dd"));
                    }
                    dt = dt.AddDays(1);
                }
            }
            else if (DayType == 3)
            {
                DateTime StartTime = DateTime.Now;
                DateTime EndTime = DateTime.Now;
                if (string.IsNullOrWhiteSpace(Year))
                {
                    return ApiResult.ParamIsNull("请选择年份");
                }
                if (!string.IsNullOrWhiteSpace(Month))
                {
                    StartTime = Convert.ToDateTime(Year + "-" + Month + "-01");
                    EndTime = StartTime.AddMonths(1).AddDays(-1);
                }
                else
                {
                    StartTime = Convert.ToDateTime(Year + "-01" + "-01");
                    EndTime = StartTime.AddYears(1).AddDays(-1);
                }

                for (DateTime dt = StartTime; dt <= EndTime;)
                {
                    //将日期转换为周几
                    DayOfWeek week = dt.DayOfWeek;
                    if (week == (DayOfWeek)Week)
                    {
                        if (!DateList.Contains(dt.ToString("yyyy-MM-dd")))
                        {
                            DateList.Add(dt.ToString("yyyy-MM-dd"));
                        }
                    }
                    dt = dt.AddDays(1);
                }
            }

            return ApiResult.Success("", DateList);
        }

        /// <summary>
        /// 获取服务类型枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetOrderListExportEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(GuideCarGoodsTypeEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 新增修改商品信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetGoodsInfo()
        {
            var parms = RequestParm;
            RB_Goods_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_Extend>(parms.msg.ToString());
            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;

            if (string.IsNullOrEmpty(demodel.Name))
            {
                return ApiResult.ParamIsNull("请输入商品名称");
            }
            if (demodel.CarouselImageList == null || !demodel.CarouselImageList.Any())
            {
                return ApiResult.ParamIsNull("请添加商品轮播图");
            }
            demodel.CarouselImage = JsonConvert.SerializeObject(demodel.CarouselImageList.Select(x => x.Path));
            if ((demodel.SellingPrice ?? 0) < 0)
            {
                return ApiResult.ParamIsNull("请输入售价");
            }
            if ((demodel.OriginalPrice ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请输入原价");
            }
            #region 司导项验证
            if ((demodel.SiteId ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请选择站点");
            }
            if ((demodel.GuideId ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请选择导游");
            }
            if ((demodel.CarId ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请选择车辆信息");
            }
            if ((demodel.CarColorId ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请选择车辆颜色");
            }
            if (string.IsNullOrEmpty(demodel.CarNumber))
            {
                return ApiResult.ParamIsNull("请输入车牌号");
            }
            if (string.IsNullOrEmpty(demodel.CarBuyYear))
            {
                return ApiResult.ParamIsNull("请输入车辆购买年限");
            }
            if ((demodel.CarType ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请选择服务类型");
            }
            if (demodel.CarType == Common.Enum.Goods.GuideCarGoodsTypeEnum.SQ || demodel.CarType == Common.Enum.Goods.GuideCarGoodsTypeEnum.ZB || demodel.CarType == Common.Enum.Goods.GuideCarGoodsTypeEnum.Line)
            {
                if ((demodel.UseDay ?? 0) <= 0)
                {
                    return ApiResult.ParamIsNull("请输入使用时间");
                }
                if (demodel.CarType == Common.Enum.Goods.GuideCarGoodsTypeEnum.Line)
                {
                    if (string.IsNullOrEmpty(demodel.LineName))
                    {
                        return ApiResult.ParamIsNull("请输入线路名称");
                    }
                    demodel.LineDescription = "";
                    if (demodel.LineDescriptionList != null && demodel.LineDescriptionList.Any())
                    {
                        demodel.LineDescription = JsonConvert.SerializeObject(demodel.LineDescriptionList);
                    }
                }
            }
            if ((demodel.RideNum ?? 0) <= 0)
            {
                return ApiResult.ParamIsNull("请输入可乘坐人数");
            }

            demodel.IsSpell ??= 1;
            demodel.AdvanceDay ??= 0;
            if (demodel.TargetDateList != null && demodel.TargetDateList.Any()) {
                //去除重复
                if (demodel.TargetDateList.Count() != demodel.TargetDateList.Select(x => x.Date).Distinct().Count()) {
                    return ApiResult.ParamIsNull("可预定日期有重复");
                }
            }
            if (demodel.Id > 0)
            {
                string vmsg = guideCarModule.ValidateGoodsTargetDate(demodel.Id, demodel.TargetDateList);
                if (vmsg != "")
                {
                    return ApiResult.Failed(vmsg);
                }
            }
            #endregion

            demodel.IsCustomSpecification ??= 2;
            demodel.DefaultSpecificationName = "默认";
            demodel.InventoryNum ??= 0;
            List<Model.Extend.User.RB_Distributor_Grade_Extend> DGradeList = null;
            List<Model.Extend.User.RB_Member_Grade_Extend> MGradeList = null;

            #region 默认值
            demodel.VideoAddress ??= "";
            demodel.CustomShareTitles ??= "";
            demodel.CustomShareImage ??= "";
            demodel.GoodsStatus ??= 2;
            demodel.Sort ??= 0;
            demodel.CostPrice ??= 0;
            demodel.IsGoodsNegotiable ??= 2;
            demodel.SalesNum ??= 0;
            demodel.GoodsNumbers ??= "";
            demodel.GoodsWeight ??= 0;
            demodel.IsDefaultService ??= 1;
            if (demodel.IsDefaultService == 2)
            {
                if (demodel.ServiceList == null || !demodel.ServiceList.Any())
                {
                    return ApiResult.ParamIsNull("请选择商品服务");
                }
                demodel.GoodsService = JsonConvert.SerializeObject(demodel.ServiceList.Select(x => x.Id));
            }
            else
            {
                demodel.GoodsService = "[]";
            }
            demodel.FreightId ??= 0;
            demodel.FormsId ??= 0;
            demodel.LimitBuyGoodsNum ??= -1;
            demodel.LimitBuyOrderNum ??= -1;
            demodel.FullNumPinkage ??= 0;
            demodel.FullMoneyPinkage ??= 0;

            demodel.IsAreaBuy ??= 2;
            if (demodel.IsAreaBuy == 1)
            {
                if (demodel.AreaList == null || !demodel.AreaList.Any())
                {
                    return ApiResult.ParamIsNull("请选择区域");
                }
            }
            demodel.IntegralPresent ??= 0;
            demodel.IntegralPresentType ??= 1;
            demodel.PointsDeduction ??= 0;
            demodel.PointsDeductionType ??= 1;
            demodel.IsMultipleDeduction ??= 2;

            demodel.Status = 0;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            #endregion
            demodel.SeparateDistribution ??= 2;
            demodel.SeparateDistributionType ??= 1;
            if (demodel.SeparateDistribution == 1)
            {
                //获取所有分销商等级
                if (DGradeList == null)
                {
                    DGradeList = guideCarModule.GetDistributorGradeList(new Model.Extend.User.RB_Distributor_Grade_Extend() { Enabled = 1, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                    DGradeList.Add(new Model.Extend.User.RB_Distributor_Grade_Extend()
                    {
                        Grade = 0,
                        Name = "默认等级",
                        Id = 0
                    });
                }
                if (demodel.SeparateDistributionType == 1)
                {
                    if (demodel.DistributionCommissionList == null || !demodel.DistributionCommissionList.Any())
                    {
                        return ApiResult.ParamIsNull("请传递分销佣金列表");
                    }
                    //普通设置  直接根据等级验证数量
                    if (DGradeList.Count() != demodel.DistributionCommissionList.Count())
                    {
                        return ApiResult.ParamIsNull("分销佣金列表数量不正确");
                    }
                    foreach (var item in DGradeList)
                    {
                        var defaultModel = demodel.DistributionCommissionList.Where(x => x.DistributorGrade == item.Id).FirstOrDefault();
                        if (defaultModel == null)
                        {
                            return ApiResult.ParamIsNull("分销佣金" + item.Name + "不存在");
                        }
                        defaultModel.OneCommission ??= 0;
                        defaultModel.TwoCommission ??= 0;
                        defaultModel.ThreeCommission ??= 0;
                        defaultModel.SpecificationSort = "";
                    }
                }
                else
                {
                    if (demodel.IsCustomSpecification != 1)
                    {
                        return ApiResult.ParamIsNull("无法开启详细设置");
                    }
                }
            }
            demodel.SeparateDistributionMoneyType ??= 1;
            demodel.EnjoyMember ??= 2;
            demodel.SeparateSetMember ??= 2;
            if (demodel.EnjoyMember == 1 && demodel.SeparateSetMember == 1)
            {
                //获取所有会员等级
                if (MGradeList == null)
                {
                    MGradeList = guideCarModule.GetMemberGradeList(new Model.Extend.User.RB_Member_Grade_Extend() { Enabled = 1, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                if (!MGradeList.Any())
                {
                    return ApiResult.ParamIsNull("单独设置会员价需先添加会员等级");
                }
                if (demodel.IsCustomSpecification == 2)
                {
                    if (demodel.MemberPriceList == null || !demodel.MemberPriceList.Any())
                    {
                        return ApiResult.ParamIsNull("请传递会员价格列表");
                    }
                    if (MGradeList.Count() != demodel.MemberPriceList.Count())
                    {
                        return ApiResult.ParamIsNull("会员价格列表数量不正确");
                    }
                    foreach (var item in MGradeList)
                    {
                        var defaultModel = demodel.MemberPriceList.Where(x => x.MemberGrade == item.Id).FirstOrDefault();
                        if (defaultModel == null)
                        {
                            return ApiResult.ParamIsNull("会员价格" + item.Name + "不存在");
                        }
                        defaultModel.MemberPrice ??= 0;
                        defaultModel.SpecificationSort = "";
                    }
                }
            }
            demodel.IsQuickBuy ??= 2;
            demodel.IsSellWell ??= 2;
            demodel.GoodsType ??= Common.Enum.Goods.OrderTypeEnum.Mall;
            demodel.GoodsStatus ??= 2;

            demodel.IsProxy ??= 2;
            demodel.ProxyType ??= 1;
            demodel.ProxyRises ??= 0;
            demodel.ProxyMoney ??= 0;
            demodel.IsProcurement = 2;//新增时

            demodel.PresentFXGrade ??= 0;//赠送粉象等级
            demodel.PresentFXMonth ??= 0;

            demodel.Advertising ??= "";//广告词
            demodel.SubName ??= "";//副标题
            demodel.IsLiveGoods ??= 2;//是否直播商品  1是  2否
            demodel.SendArea ??= "";//发货地
            demodel.GoodsClassify = 1;

            bool flag = guideCarModule.SetProductGoodsInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 删除商品
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelGoodsInfo()
        {
            var req = RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int GoodsId = parms.GetInt("GoodsId", 0);
            if (GoodsId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            bool flag = guideCarModule.DelProcudtGoodsInfo(GoodsId, req.TenantId, req.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 上下架商品
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetGoodsStatusInfo()
        {
            var req = RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int GoodsId = parms.GetInt("GoodsId", 0);
            if (GoodsId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            bool flag = guideCarModule.SetGoodsStatusInfo(GoodsId, req.TenantId, req.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion

        #region 站点配置
        /// <summary>
        /// 列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarSiteList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_GuideCar_Site_Extend demodel = JsonConvert.DeserializeObject<RB_GuideCar_Site_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            demodel.SiteType = 1;
            var list = guideCarModule.GetGuideCarSiteList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.SiteName,
                x.IsEnable,
                RegionList = x.RegionList.Select(x => x.RegionName)
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 删除站点
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelGuideCarSiteInfo()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = guideCarModule.DelGuideCarSiteInfo(Id, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }


        /// <summary>
        /// 删除站点
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult EnableGuideCarSiteInfo()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            string idInfo = parmsJob.GetStringValue("Ids");
            int isEnable = parmsJob.GetInt("IsEnable", 0);
            if (string.IsNullOrWhiteSpace(idInfo))
            {
                return ApiResult.Failed("请传递参数");
            }

            bool flag = guideCarModule.EnableGuideCarSiteInfo(idInfo.Split(",").ToList(), isEnable, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }



        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarSiteModel()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Site_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.SiteType = 1;
            var oldLogisticsModel = guideCarModule.GetGuideCarSiteModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_GuideCar_Site_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }

        /// <summary>
        /// 获取全部站点
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAllGuideCarSiteList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Site_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.SiteType = 1;
            var list = guideCarModule.GetGuideCarSiteList(query);
            var result = list.Where(x => x.IsEnable == 1).Select(x => new { x.ID, x.SiteName });
            return ApiResult.Success("", result);
        }


        /// <summary>
        /// 保存司导站点信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateGuideCarSite()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Site_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.SiteType = 1;
            if (query == null)
            {
                return ApiResult.Failed("请传入站点信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.SiteName))
                {
                    return ApiResult.Failed("请输入站点名称");
                }

                if (query.RegionList == null || !query.RegionList.Any())
                {
                    return ApiResult.Failed("请选择地区");
                }
                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = guideCarModule.AddOrUpdateGuideCarSite(query);
                if (result)
                {
                    return ApiResult.Success("站点信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("站点信息保存失败");
                }
            }
        }


        #endregion

        #region 导游信息
        [HttpPost]
        public ApiResult GetGuidePageListRepository()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_GuideCar_Guide_Extend demodel = JsonConvert.DeserializeObject<RB_GuideCar_Guide_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = guideCarModule.GetGuidePageListRepository(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.GuidePhoto,
                x.Name,
                x.WorkYears,
                Score = x.Score == 0 ? "暂无" : x.Score.ToString(),
                x.SiteName,
                x.OrderNum,
                x.GoodsList,
                x.GoodsNum,
                CreateDateStr = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss"),
                x.IsEnable,
                x.Telephone,
                x.EmergencyPhone

            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 禁用/启用导游状态
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult EnableGuideCarGuideInfo()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            string idInfo = parmsJob.GetStringValue("Ids");
            int isEnable = parmsJob.GetInt("IsEnable", 0);
            if (string.IsNullOrWhiteSpace(idInfo))
            {
                return ApiResult.Failed("请传递参数");
            }

            bool flag = guideCarModule.EnableGuideCarGuideInfo(idInfo.Split(",").ToList(), isEnable, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }



        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetGuideCarGuideModel()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Guide_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = guideCarModule.GetGuideCarGuideModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_GuideCar_Guide_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }


        /// <summary>
        /// 获取全部导游
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarGuideList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Guide_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var list = guideCarModule.GetGuideCarGuideList(query);
            var result = list.Select(x => new { x.ID, x.Name, x.WorkYears, x.Score });
            return ApiResult.Success("", result);
        }


        /// <summary>
        /// 保存司导导游信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateGuideCarGuide()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Guide_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            query.IsEnable = 0;
            if (query == null)
            {
                return ApiResult.Failed("请传入站点信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.Name))
                {
                    return ApiResult.Failed("请输入导游名称");
                }
                if (string.IsNullOrWhiteSpace(query.GuidePhoto))
                {
                    return ApiResult.Failed("请上传导游头像");
                }
                if (string.IsNullOrWhiteSpace(query.Telephone))
                {
                    return ApiResult.Failed("请输入联系电话");
                }
                if (string.IsNullOrWhiteSpace(query.EmergencyPhone))
                {
                    return ApiResult.Failed("请输入紧急联系电话");
                }
                if (query.SiteId == 0)
                {
                    return ApiResult.Failed("请选择站点信息");
                }
                if (string.IsNullOrWhiteSpace(query.Introduction))
                {
                    return ApiResult.Failed("请输入间接");
                }

                query.TenantId = UserInfo.TenantId;
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = guideCarModule.AddOrUpdateGuideCarGuide(query);
                if (result)
                {
                    return ApiResult.Success("导游信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("导游信息保存失败");
                }
            }
        }
        #endregion

        #region 司导-车辆
        /// <summary>
        /// 列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_GuideCar_Car_Extend demodel = JsonConvert.DeserializeObject<RB_GuideCar_Car_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = guideCarModule.GetGuideCarPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.Name,
                x.CarLogo,
                x.CarBrand,
                x.CarType,
                CarClassStr = EnumHelper.GetEnumName(x.CarClass),
                x.ColorList,
                x.GoodsNum,
                x.OrderNum,
                x.GuestNum
            });
            return ApiResult.Success("", pagelist);
        }



        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarModel()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Car_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = guideCarModule.GetGuideCarModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_GuideCar_Car_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }

        /// <summary>
        /// 获取全部车辆
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Car_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var list = guideCarModule.GetGuideCarList(query);
            var result = list.Select(x => new { x.ID, x.Name, x.CarBrand, x.CarClass, x.CarLogo, ColorList = x.ColorList.Select(y => new { y.ColorName, y.PicList ,y.ID}), x.CarType });
            return ApiResult.Success("", result);
        }


        /// <summary>
        /// 保存车辆信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateGuideCar()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_Car_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入车辆信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.Name))
                {
                    return ApiResult.Failed("请输入车辆名称");
                }

                if (query.CarBrandId == 0)
                {
                    return ApiResult.Failed("请选择车辆品牌");
                }
                if (string.IsNullOrWhiteSpace(query.CarLogo))
                {
                    return ApiResult.Failed("请上传车辆LOGO");
                }
                if (string.IsNullOrWhiteSpace(query.CarType))
                {
                    return ApiResult.Failed("请输入车辆型号");
                }
                if ((int)query.CarClass == 0)
                {
                    return ApiResult.Failed("请选择车辆分类");
                }
                if (query.ColorList == null || !query.ColorList.Any())
                {
                    return ApiResult.Failed("请输入车辆颜色信息");
                }
                else
                {

                    query.ColorList.Where(x => x.PicList != null && x.PicList.Any()).ToList().ForEach(x => x.CarPic = JsonConvert.SerializeObject(x.PicList));
                }

                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = guideCarModule.AddOrUpdateGuideCar(query);
                if (result)
                {
                    return ApiResult.Success("车辆信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("车辆信息保存失败");
                }
            }
        }


        /// <summary>
        /// 获取车辆分类下拉
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCarClassList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.GuideCar.CarClassEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        #endregion


        #region 司导-车辆搜索模块
        /// <summary>
        /// 新增车辆搜索模块
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetGuideCarSearchInfo()
        {
            var requestParm = RequestParm;
            RB_GuideCar_CarSearch demodel = JsonConvert.DeserializeObject<RB_GuideCar_CarSearch>(requestParm.msg.ToString());
            if (demodel.Background == null || string.IsNullOrWhiteSpace(demodel.Background))
            {
                return ApiResult.ParamIsNull("请传递背景图片");
            }
            //if (demodel.SearchBackground == null || string.IsNullOrWhiteSpace(demodel.SearchBackground))
            //{
            //    return ApiResult.ParamIsNull("请传递搜索背景图片");
            //}
            //if (string.IsNullOrEmpty(demodel.SearchTips))
            //{
            //    return ApiResult.ParamIsNull("请传递搜索框提示文字");
            //}
            if (string.IsNullOrEmpty(demodel.Tips))
            {
                return ApiResult.ParamIsNull("请传递按钮上面的文字提示");
            }
            if (string.IsNullOrEmpty(demodel.TipsIco))
            {
                return ApiResult.ParamIsNull("请传递按钮上面的文字图标提示");
            }
            //if (string.IsNullOrEmpty(demodel.SearchIco))
            //{
            //    return ApiResult.ParamIsNull("请传递搜索框图标");
            //}
            if (string.IsNullOrEmpty(demodel.ButtonTextColor))
            {
                return ApiResult.ParamIsNull("请传递分销申请下文本颜色");
            }

            if (string.IsNullOrEmpty(demodel.ButtonText))
            {
                return ApiResult.ParamIsNull("请传递按钮文本");
            }
            if (demodel.ButtonColor == null || string.IsNullOrWhiteSpace(demodel.ButtonColor))
            {
                return ApiResult.ParamIsNull("请传递按钮颜色");
            }
            if (string.IsNullOrEmpty(demodel.ButtonTextColor))
            {
                return ApiResult.ParamIsNull("请传递按钮文字颜色");
            }
            demodel.TenantId = Convert.ToInt32(requestParm.uid);
            demodel.MallBaseId = requestParm.MallBaseId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            bool flag = guideCarModule.SetGuideCarSearchInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 获取车辆搜索模块
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarSearchInfo()
        {
            var requestParm = RequestParm;
            var model = guideCarModule.GetGuideCarSearchInfo(requestParm.uid, requestParm.MallBaseId);
            return ApiResult.Success("", new
            {
                model.ID,
                model.Background,
                model.SearchBackground,
                model.SearchTips,
                model.IsShowDate,
                model.IsShowCity,
                model.IsShowAddress,
                model.IsShowCarpooling,
                model.IsShowGuideCarGoodsType,
                model.IsShowCarClass,
                model.IsShowTravelGuestNum,
                model.Tips,
                model.TipsIco,
                model.SearchIco,
                model.SearchFilletPX,
                model.ButtonFilletPX,
                model.ButtonText,
                model.ButtonColor,
                model.ButtonTextColor
            });
        }
        #endregion

        #region 司导-车辆品牌
        /// <summary>
        /// 车辆品牌列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarBrandPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_GuideCar_CarBrand_Extend demodel = JsonConvert.DeserializeObject<RB_GuideCar_CarBrand_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = guideCarModule.GetGuideCarBrandPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.Name,
                x.BrandLogo
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取车辆品牌详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarBrandModel()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_CarBrand_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = guideCarModule.GetGuideCarBrandModel(query);
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_GuideCar_CarBrand_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }

        /// <summary>
        /// 获取全部车辆品牌
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarBrandList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_CarBrand_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var list = guideCarModule.GetGuideCarBrandList(query);
            var result = list.Select(x => new { x.ID, x.Name, x.BrandLogo });
            return ApiResult.Success("", result);
        }


        /// <summary>
        /// 保存车辆品牌信息
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateGuideCarBrand()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_GuideCar_CarBrand>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入车辆信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.Name))
                {
                    return ApiResult.Failed("请输入车辆品牌名称");
                }
                if (string.IsNullOrWhiteSpace(query.BrandLogo))
                {
                    return ApiResult.Failed("请上传品牌LOGO");
                }

                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = guideCarModule.AddOrUpdateGuideCarBrand(query);
                if (result)
                {
                    return ApiResult.Success("车辆信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("车辆信息保存失败");
                }
            }
        }


        /// <summary>
        /// 删除车辆品牌
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelGuideCarBrandInfo()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            string idInfo = parmsJob.GetStringValue("Ids");
            if (string.IsNullOrWhiteSpace(idInfo))
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = guideCarModule.DelGuideCarBrandInfo(idInfo.Split(",").ToList(), UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion

        #region 新增司导评论-车辆与导游评论

        /// <summary>
        /// 管理新增评论
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetGuideCarCommentInfo()
        {
            var req = RequestParm;
            List<RB_Goods_Comment_Extend> list = JsonConvert.DeserializeObject<List<RB_Goods_Comment_Extend>>(req.msg.ToString());

            if (list != null && list.Any())
            {

                if (list.Where(x => (x.GuideId ?? 0) > 0).Count() == 0)
                {
                    return ApiResult.ParamIsNull("请传递导游");
                }
                if (list.Where(x => (x.CarId ?? 0) > 0).Count() == 0)
                {
                    return ApiResult.ParamIsNull("请传递车辆");
                }
            }
            else {
                return ApiResult.ParamIsNull("请传递您要评论的信息");
            }
            foreach (var demodel in list)
            {
                if (string.IsNullOrEmpty(demodel.UserName))
                {
                    return ApiResult.ParamIsNull("请输入用户名称");
                }
                if (!demodel.CreateDate.HasValue)
                {
                    return ApiResult.ParamIsNull("请输入评论时间");
                }
                if ((demodel.GoodsId ?? 0) <= 0)
                {
                    return ApiResult.ParamIsNull("请选择商品");
                }
                if (string.IsNullOrEmpty(demodel.Content))
                {
                    return ApiResult.ParamIsNull("请输入评价内容");
                }
                if (!demodel.CommentGrade.HasValue)
                {
                    return ApiResult.ParamIsNull("请选择评分");
                }
                demodel.CommentScore ??= 5;
                demodel.CommentImage = "";
                if (demodel.CommentImgList != null && demodel.CommentImgList.Any())
                {
                    demodel.CommentImage = JsonConvert.SerializeObject(demodel.CommentImgList);
                }
                demodel.UserPhoto ??= 0;
                demodel.Is_Top ??= 2;
                demodel.Is_Show ??= 1;
                demodel.Is_Anonymity ??= 2;
                demodel.UserId ??= 0;
                demodel.Reply ??= "";
                demodel.TenantId = req.TenantId;
                demodel.MallBaseId = req.MallBaseId;
                demodel.Status = 0;
                demodel.UpdateDate = DateTime.Now;

            }

            bool flag = guideCarModule.SetGoodsCommentInfo(list);
            if (flag) { return ApiResult.Success(); } else { return ApiResult.Failed(); }
        }
        #endregion
    }
}