﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Finance;
using VT.FW.DB;

namespace Mall.Model.Extend.Finance
{
    /// <summary>
    /// 现金账户表扩展 实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_CashAccount_Extend : RB_CashAccount
    {
        /// <summary>
        /// 期初开始时间str
        /// </summary>
        public string BeginTimeStr { get; set; }
        /// <summary>
        /// 账户id Str
        /// </summary>
        public string AccountIdStr { get; set; }
        /// <summary>
        /// 收款负责人名称
        /// </summary>
        public string InemName { get; set; }
        /// <summary>
        /// 付款负责人
        /// </summary>
        public string OutemName { get; set; }
        /// <summary>
        /// 上期损益
        /// </summary>
        public decimal? ProfitLossMoney { get; set; }
        /// <summary>
        /// 所属公司集合
        /// </summary>
        //public List<RB_AccountRelation_Extend> BranchList { get; set; }
        /// <summary>
        /// 所属公司
        /// </summary>
        public int? BranchId
        {
            get; set;
        }

        /// <summary>
        /// 币种
        /// </summary>
        public string CurrencyName { get; set; }

        /// <summary>
        /// 账户类型
        /// </summary>
        public string TypeName { get; set; }
        /// <summary>
        /// 当前汇率
        /// </summary>
        public decimal CurrencyRate { get; set; }

        /// <summary>
        /// 付款汇率
        /// </summary>
        public decimal PayRate { get; set; }
        /// <summary>
        /// 上调汇率
        /// </summary>
        public decimal ExchangeRates { get; set; }

        /// <summary>
        /// 汇率
        /// </summary>
        public decimal Rate { get; set; }
        /// <summary>
        /// 货币代码
        /// </summary>
        public string CurrencyCode { get; set; }
        /// <summary>
        /// 本位币货币代码
        /// </summary>
        public string StandardCurrencyCode { get; set; }

        /// <summary>
        /// 币种类型
        /// </summary>
        public int IsStandardCurrency { get; set; }
    }
}
