﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 出库明细id
    /// </summary>
    public class RB_WarehouseOut_GoodsDetailRepository : BaseRepository<RB_WarehouseOut_GoodsDetail>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_WarehouseOut_GoodsDetail); } }

        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_GoodsDetail_Extend> GetOutGoodsDetailPageList(int pageIndex, int pageSize, out long rowCount, RB_WarehouseOut_GoodsDetail_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" select a.* from {TableName} as a where a.Status=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.MallBaseId)}={query.MallBaseId}");
                }
                if (query.OrderId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.OrderId)}={query.OrderId}");
                }
                if (!string.IsNullOrEmpty(query.GoodsName))
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.GoodsName)} like '%{query.GoodsName}%'");
                }
            }
            return GetPage<RB_WarehouseOut_GoodsDetail_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_GoodsDetail> GetOutGoodsDetailList(RB_WarehouseOut_GoodsDetail_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" select * from {TableName} as a where a.Status=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ApplyId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.ApplyId)}={query.ApplyId}");
                }
                if (!string.IsNullOrEmpty(query.WarehouseOutIds))
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_GoodsDetail.ID)} in({query.WarehouseOutIds})");
                }
            }
            return Get<RB_WarehouseOut_GoodsDetail>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取出库记录分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_WarehouseOut_GoodsDetail_Extend> GetPageList_V2(int pageIndex, int pageSize, out long rowCount, RB_WarehouseOut_GoodsDetail_Extend query) 
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($@"SELECT a.*,i.InventoryNum,i.CreateDate as StockInDate,i.FinanceId FROM(
SELECT gd.OrderId,gd.OrderGoodsId,gd.GoodsId,gd.StockOutId,gd.MaterialId,gd.GoodsName
,gd.Specification,gd.CostMoney,gd.ProductCode,gd.WarehouseId,s.StockOutDate,w.`Name` as WarehouseName,GROUP_CONCAT(gd.ValidityId) as ValidityIds,COUNT(0) AS Number
FROM rb_warehouseout_goodsdetail gd
LEFT JOIN rb_supplies_stockout s on gd.StockOutId = s.Id and s.`Status`=0 and s.StockOutState =1
LEFT JOIN rb_supplies_warehouse w on gd.WarehouseId =w.Id
WHERE gd.`Status`=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.ID)}={query.ID}");
                }
                if (!string.IsNullOrEmpty(query.WarehouseOutIds))
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.ID)} in({query.WarehouseOutIds})");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.MallBaseId)}={query.MallBaseId}");
                }
                if (query.OrderId > 0)
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.OrderId)}={query.OrderId}");
                }
                if (!string.IsNullOrEmpty(query.GoodsName))
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.GoodsName)} like '%{query.GoodsName}%'");
                }
            }
            builder.Append($@" GROUP BY gd.OrderId,gd.OrderGoodsId,gd.GoodsId,gd.StockOutId,gd.MaterialId) a
LEFT JOIN rb_warehouseout_inventory i on a.StockOutId = i.StockOutId and a.MaterialId = i.MaterialId and a.OrderId = i.OrderId and a.OrderGoodsId = i.OrderGoodsId");
            builder.Append(" ORDER BY a.StockOutDate DESC");
            return GetPage<RB_WarehouseOut_GoodsDetail_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取出库记录列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_WarehouseOut_GoodsDetail_Extend> GetList_V2(RB_WarehouseOut_GoodsDetail_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($@"SELECT a.*,i.InventoryNum FROM(
SELECT gd.OrderId,gd.OrderGoodsId,gd.GoodsId,gd.StockOutId,gd.MaterialId,gd.GoodsName
,gd.Specification,gd.CostMoney,gd.ProductCode,gd.WarehouseId,s.StockOutDate,w.`Name` as WarehouseName,COUNT(0) AS Number
FROM rb_warehouseout_goodsdetail gd
LEFT JOIN rb_supplies_stockout s on gd.StockOutId = s.Id and s.`Status`=0 and s.StockOutState =1
LEFT JOIN rb_supplies_warehouse w on gd.WarehouseId =w.Id
WHERE gd.`Status`=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.ID)}={query.ID}");
                }
                if (!string.IsNullOrEmpty(query.WarehouseOutIds))
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.ID)} in({query.WarehouseOutIds})");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.MallBaseId)}={query.MallBaseId}");
                }
                if (query.OrderId > 0)
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.OrderId)}={query.OrderId}");
                }
                if (!string.IsNullOrEmpty(query.GoodsName))
                {
                    builder.Append($" AND gd.{nameof(RB_WarehouseOut_GoodsDetail.GoodsName)} like '%{query.GoodsName}%'");
                }
            }
            builder.Append($@" GROUP BY gd.OrderId,gd.OrderGoodsId,gd.GoodsId,gd.StockOutId,gd.MaterialId) a
LEFT JOIN rb_warehouseout_inventory i on a.StockOutId = i.StockOutId and a.MaterialId = i.MaterialId and a.OrderId = i.OrderId and a.OrderGoodsId = i.OrderGoodsId");
            builder.Append(" ORDER BY a.StockOutDate DESC");
            return Get<RB_WarehouseOut_GoodsDetail_Extend>(builder.ToString()).ToList();
        }
    }
}
