﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.ThirdCore.Message
{
    /// <summary>
    /// 短信消息
    /// </summary>
    public class SMSService
    {

        /// <summary>
        /// 发送证码
        /// </summary>
        /// <param name="phoneNumber">电话号码</param>
        /// <param name="code">验证码</param>
        public static void SendCode(string phoneNumber, string code, string templateCode)
        {
            JObject obj = new JObject();
            obj["cmd"] = "sms";
            obj["phoneNumber"] = phoneNumber;
            obj["templateCode"] = templateCode;
            var TemplateParam = new { code = code };
            obj["templateParam"] = JsonConvert.SerializeObject(TemplateParam);
            QueueHelper.EnqueueTask(JsonConvert.SerializeObject(obj));
        }

        /// <summary>
        /// 发送短信通知
        /// </summary>
        /// <param name="phoneNumber"></param>
        /// <param name="content"></param>
        /// <param name="templateCode"></param>
        public static void SendMsg(string phoneNumber, string content, string templateCode)
        {
            JObject obj = new JObject();
            obj["cmd"] = "sms";
            obj["phoneNumber"] = phoneNumber;
            obj["templateCode"] = templateCode;
            var TemplateParam = new { content };
            obj["templateParam"] = JsonConvert.SerializeObject(TemplateParam);
            LogHelper.WriteInfo("发送短信信息");
            QueueHelper.EnqueueTask(JsonConvert.SerializeObject(obj));
        }

        /// <summary>
        /// 发送短信通知
        /// </summary>
        /// <param name="phoneNumber"></param>
        /// <param name="templateParam">通知参数</param>
        /// <param name="templateCode"></param>
        public static void SendMsg(string phoneNumber, object templateParam, string templateCode)
        {
            JObject obj = new JObject();
            obj["cmd"] = "sms";
            obj["phoneNumber"] = phoneNumber;
            obj["templateCode"] = templateCode;
            var TemplateParam = templateParam;
            obj["templateParam"] = JsonConvert.SerializeObject(TemplateParam);
            QueueHelper.EnqueueTask(JsonConvert.SerializeObject(obj));
        }
    }
}
