﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 员工基础配置仓储层
    /// </summary>
    public class RB_Emp_ConfigRepository : RepositoryBase<RB_Emp_Config>
    {
        /// <summary>
        /// 获取员工配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Emp_Config_Extend> GetEmpConfigListRepository(RB_Emp_Config_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Emp_Config WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Emp_Config_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Emp_Config_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.ConfigId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Emp_Config_Extend.ConfigId), query.ConfigId);
            }
            return Get<RB_Emp_Config_Extend>(builder.ToString()).ToList();
        }
    }
}