﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Model.Entity.User;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class EmployeeController : BaseController
    {
        /// <summary>
        /// 员工相关处理类对象
        /// </summary>
        private readonly EmployeeModule module = new EmployeeModule();

        #region 角色管理

        /// <summary>
        /// 角色分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetRolePageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Role_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetRolePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取角色列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetRoleList()
        {
            var query = JsonConvert.DeserializeObject<RB_Role_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetRoleListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改角色
        /// </summary>
        /// <returns></returns>
        public ApiResult SetRole()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Role_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            var flag = module.SetRoleModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取角色实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetRole()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var RoleId = parms.GetInt("RoleId", 0);
            var extModel = module.GetRoleModule(RoleId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除角色
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveRole()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var RoleId = parms.GetInt("RoleId", 0);
            var flag = module.RemoveRoleModule(RoleId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 员工管理

        /// <summary>
        /// 员工分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetEmployeePageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Employee_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetEmployeePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取员工列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetEmployeeList()
        {
            var query = JsonConvert.DeserializeObject<RB_Employee_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetEmployeeListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改员工
        /// </summary>
        /// <returns></returns>
        public ApiResult SetEmployee()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Employee_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            var flag = module.SetEmployeeModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取员工实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetEmployee()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var EmpId = parms.GetInt("EmpId", 0);
            var extModel = module.GetEmployeeModule(EmpId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除员工
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveEmployee()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var EmpId = parms.GetInt("EmpId", 0);
            var flag = module.RemoveEmployeeModule(EmpId);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 员工管理


        /// <summary>
        /// 获取员工配置列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetEmpConfigList()
        {
            var query = JsonConvert.DeserializeObject<RB_Emp_Config_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = module.GetEmpConfigListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改员工配置
        /// </summary>
        /// <returns></returns>
        public ApiResult SetEmpConfig()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Emp_Config_Extend>(RequestParm.msg.ToString());
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            var flag = module.SetEmpConfigModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion
    }
}