﻿using Mall.Model.Entity.TradePavilion;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.TradePavilion
{
    /// <summary>
    /// 商会活动表扩展实体类
    /// </summary>
    public class RB_Commerce_Activity_Extend : RB_Commerce_Activity
    {
        /// <summary>
        /// 活动名称
        /// </summary>
        public string ActivityTypeName { get; set; }

        /// <summary>
        /// 开始时间字符串
        /// </summary>
        public string StartTimeStr { get { return Common.ConvertHelper.FormatDate(this.StartTime); } }


        /// <summary>
        /// 结束时间字符串
        /// </summary>
        public string EndTimeStr { get { return Common.ConvertHelper.FormatDate(this.EndTime); } }


        /// <summary>
        /// 商会活动详情列表
        /// </summary>
        public List<RB_Commerce_Details_Extend> CommerceDetailsList { get; set; }

        /// <summary>
        /// 活动状态
        /// </summary>
        public int ActivityStatus
        {
            get
            {
                int status = 0;//未开始
                DateTime currentDay = Convert.ToDateTime(Common.ConvertHelper.FormatDate(DateTime.Now));
                if (currentDay >= this.StartTime && currentDay <= this.EndTime)
                {
                    status = 1;//进行中
                }
                else if (currentDay > this.EndTime)
                {
                    status = 2;//已结束
                }
                return status;
            }
        }

        /// <summary>
        /// 活动状态字符串
        /// </summary>
        public string ActivityStatusStr
        {
            get
            {
                string str = "未开始";
                switch (this.ActivityStatus)
                {
                    case 0:
                        str = "未开始";
                        break;
                    case 1:
                        str = "进行中";
                        break;
                    case 2:
                        str = "已结束";
                        break;
                }
                return str;
            }
        }
    }
}
