﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Common.Enum
{
    /// <summary>
    /// 手机号码验证码类型
    /// </summary>
    public enum MobileCodeTypeEnum
    {
        /// <summary>
        /// 账号绑定手机号
        /// </summary>
        [EnumField("SMS_137666181")]
        AccountBindMobile = 1,
        /// <summary>
        /// 修改密码 
        /// </summary>
        [EnumField("SMS_132045009")]
        ChangePassword = 2,
        /// <summary>
        /// B2B用户账号激活 
        /// </summary>
        [EnumField("SMS_147435886")]
        B2BAccountActivation = 3,
        /// <summary>
        /// 直客报名成功提示模版
        /// </summary>
        [EnumField("SMS_148594438")]
        ApplySuccess = 4,
        /// <summary>
        /// 同行报名成功提示模版
        /// </summary>
        [EnumField("SMS_150170938")]
        ClientApplySuccess = 5,
        /// <summary>
        /// 登录发送验证码
        /// </summary>
        [EnumField("SMS_151575844")]
        LoginSendCode = 6,
        /// <summary>
        /// B2B未激活的账号信息推广
        /// </summary>
        [EnumField("SMS_152851496")]
        B2BNoAcctiveAccount = 7,
        /// <summary>
        /// B2B抽奖奖励通知
        /// </summary>
        [EnumField("SMS_xxxxx")]
        B2BLotteryReward = 8,
        /// <summary>
        /// 距离发团剩余十日团 订单未收齐款发送提醒
        /// </summary>
        [EnumField("SMS_163625826")]
        TenDayTravelRemind = 9,
        /// <summary>
        /// B2B酒店支付成功短信提示
        /// </summary>
        [EnumField("SMS_170520854")]
        B2BHotelOrder = 10,
        /// <summary>
        /// B2B自由行支付成功短信提示
        /// </summary>
        [EnumField("SMS_173425485")]
        B2BIndependentTravelOrder = 12,
        /// <summary>
        /// 客户交易额返佣  发送短信通知
        /// </summary>
        [EnumField("SMS_173470253")]
        ClientRebate = 11,
        /// <summary>
        /// 客户发送11.18活动
        /// </summary>
        [EnumField("SMS_177547961")]
        ClientActivity = 13,

        /// <summary>
        /// CRM营销发送发送直客生日祝福
        /// </summary>
        [EnumField("SMS_187570365")]
        CRMGuestBirth = 14
    }
}
