﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Miai;

namespace Mall.Repository.Miai
{
    public class RB_MiAi_FollowMemberRepository : BaseRepository<RB_MiAi_FollowMember>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_MiAi_FollowMember); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_FollowMember_Extend> GetFollowMemberList(RB_MiAi_FollowMember_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from RB_MiAi_FollowMember  where 1=1");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and ID={0}", where.ID);
                }
                if (where.CreateBy > 0)
                {
                    sb.AppendFormat(" and CreateBy={0}", where.CreateBy);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and UserId={0}", where.UserId);
                }

                if (!string.IsNullOrWhiteSpace(where.CreateByIds))
                {
                    sb.AppendFormat(" and CreateBy in ({0})", where.CreateByIds);
                }
                if (!string.IsNullOrWhiteSpace(where.UserIds))
                {
                    sb.AppendFormat(" and UserId in ({0})", where.UserIds);
                }
                if (where.Status >= 0)
                {
                    sb.AppendFormat($" AND {nameof(RB_MiAi_FollowMember.Status)}={where.Status}");
                }
            }
            return Get<RB_MiAi_FollowMember_Extend>(sb.ToString()).ToList();
        }




        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_FollowMember_Extend> GetFollowMemberPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_FollowMember_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,b.`Name`,b.Photo from RB_MiAi_FollowMember  as a LEFT JOIN rb_member_user as b on a.createby=b.Id  where a.`Status`=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and a.Id={0}", where.ID);
                }

                if (where.CreateBy > 0)
                {
                    sb.AppendFormat(" and a.CreateBy={0}", where.CreateBy);
                }
            }
            return GetPage<RB_MiAi_FollowMember_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }


        /// <summary>
        /// 我的粉丝分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_FollowMember_Extend> GetFollowFansPageList(int pageIndex, int pageSize, out long rowsCount, RB_MiAi_FollowMember_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,b.`Name`,b.Photo from RB_MiAi_FollowMember  as a LEFT JOIN rb_member_user as b on a.createby=b.Id where a.Status=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and a.Id={0}", where.ID);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and a.UserId={0}", where.UserId);
                }

            }
            return GetPage<RB_MiAi_FollowMember_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }
    }
}
