﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 财务单据明细实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_FinanceDetail
    {
        /// <summary>
        /// 主键
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 单据ID
        /// </summary>        
        public int? FinanceId
        {
            get;
            set;
        }
        /// <summary>
        /// 费用类型
        /// </summary>        
        public int? CostTypeId
        {
            get;
            set;
        }
        /// <summary>
        /// 单价
        /// </summary>        
        public decimal? UnitPrice
        {
            get;
            set;
        }
        /// <summary>
        /// 数量
        /// </summary>        
        public int? Number
        {
            get;
            set;
        }
        /// <summary>
        /// 本位币总金额
        /// </summary>        
        public decimal? Money
        {
            get;
            set;
        }
        /// <summary>
        /// 原币总金额
        /// </summary>
        public decimal? OriginalMoney
        {
            get; set;
        }
        /// <summary>
        /// 币种
        /// </summary>        
        public int? CurrencyId
        {
            get;
            set;
        }
        /// <summary>
        /// 汇率
        /// </summary>        
        public decimal? Rate
        {
            get;
            set;
        }
        /// <summary>
        /// 状态
        /// </summary>        
        public Common.Enum.DateStateEnum Status
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        #region 2019-03-27 Add By:W
        /// <summary>
        /// 1-收入 2-支出  挂账专用
        /// </summary>
        public int? HangingAccountsType { get; set; }

        /// <summary>
        /// 团号
        /// </summary>
        public int? TCID { get; set; }
        #endregion
    }
}
