﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 载体实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Carrier
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }


        /// <summary>
        /// 载体名称
        /// </summary>
        public string CarrierName { get; set; }


        /// <summary>
        /// logo
        /// </summary>
        public string Logo { get; set; }


        /// <summary>
        /// 载体介绍图
        /// </summary>
        public string Banner { get; set; }

        /// <summary>
        /// 载体视频
        /// </summary>
        public string VideoUrl { get; set; }

        /// <summary>
        /// 省
        /// </summary>
        public int Province { get; set; }

        /// <summary>
        /// 市
        /// </summary>
        public int City { get; set; }


        /// <summary>
        /// 区
        /// </summary>
        public int Area { get; set; }

        /// <summary>
        /// 载体地址
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 载体地址经纬度
        /// </summary>
        public string LatAndLon { get; set; }

        /// <summary>
        /// 开发商
        /// </summary>
        public string Developers { get; set; }

        /// <summary>
        /// 开业时间
        /// </summary>
        public DateTime? OpenTime { get; set; }

        /// <summary>
        /// 项目类型
        /// </summary>
        public ProjectTypeEnum? ProjectType { get; set; }

        /// <summary>
        /// 商业体量（单位：万平方米）
        /// </summary>
        public decimal CarrierSize { get; set; }

        /// <summary>
        /// 商业层数
        /// </summary>
        public string LayersNum { get; set; }

        /// <summary>
        /// 车位数量
        /// </summary>
        public int CarNum { get; set; }


        /// <summary>
        /// 业态规划
        /// </summary>
        public string CarrierPlan { get; set; }

        /// <summary>
        /// 招引目标
        /// </summary>
        public string CarrierTarget { get; set; }


        /// <summary>
        /// 定位
        /// </summary>
        public string Location { get; set; }


        /// <summary>
        /// 目标人群
        /// </summary>
        public string Crowd { get; set; }

        /// <summary>
        /// 归属于用户
        /// </summary>
        public int UserId { get; set; }
    }
}
