﻿using Mall.Model.Entity.Reserve;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.Reserve
{

    /// <summary>
    ///  服务人员扩展表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Reserve_ServicePersonal_Extend : RB_Reserve_ServicePersonal
    {
        /// <summary>
        /// 服务人员编号【查询使用】
        /// </summary>
        public string QIds { get; set; }

        /// <summary>
        /// 标签
        /// </summary>
        public List<string> LableNameList { get; set; }

        /// <summary>
        /// 预约数
        /// </summary>
        public int OrderNum { get; set; }
        /// <summary>
        /// 评价数
        /// </summary>
        public int CommentNum { get; set; }

        /// <summary>
        /// 评价数
        /// </summary>
        public decimal CommentScore { get; set; }


        /// <summary>
        /// 订单人数
        /// </summary>
        public int OrderGuestNum { get; set; }


        public int ServiceTargetDateNum { get; set; }

        /// <summary>
        /// 总金额
        /// </summary>
        public decimal Final_Price { get; set; }

        /// <summary>
        /// 排名（并列）
        /// </summary>
        public int Rank { get; set; }


        /// <summary>
        /// 商品分类id
        /// </summary>
        public int[] GoodsClassId { get; set; }

        /// <summary>
        /// 店铺名称
        /// </summary>
        public string StoreName { get; set; }

        public string StoreAddress { get; set; }

        /// <summary>
        /// 日期
        /// </summary>
        public List<string> TargetDateStrList { get; set; }

        /// <summary>
        /// 可预约时间
        /// </summary>

        public List<RB_Reserve_ServiceTargetDate_Extend> ServiceTargetDateList { get; set; }


        /// <summary>
        /// 商品/分类id
        /// </summary>
        public List<RB_Reserve_ServicePersonalProduct_Extend> ProductList { get; set; }


        /// <summary>
        /// 查询时间条件
        /// </summary>
        public string WorkDate { get; set; }

        /// <summary>
        /// 查询时间条件
        /// </summary>
        public string EndWorkDate { get; set; }

        /// <summary>
        /// 排序
        /// </summary>

        public int OrderBy { get; set; }
    }



    //public class StoreServicePersonalKanBan
    //{
    //    public List<ServicePersonalKanBan> ServicePersonalList { get; set; }
    //}

    public class ServicePersonalKanBan
    {
        /// <summary>
        /// 服务人员名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 服务人员编号
        /// </summary>
        public int Id { get; set; }


        public List<OrderKanBan> OrderList { get; set; }


        /// <summary>
        /// 店铺名称
        /// </summary>
        public string StoreName { get; set; }

        public string StoreAddress { get; set; }
    }


    public class OrderKanBan
    {
        /// <summary>
        /// 服务人员名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 服务人员编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 服务时间
        /// </summary>
        public string ServiceTime { get; set; }
        /// <summary>
        /// 服务时间
        /// </summary>
        public string SystemServiceTime { get; set; }
        /// <summary>
        /// 服务时长
        /// </summary>
        public decimal GoodServiceTime { get; set; }

        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }




        public string BuyerMessage { get; set; }
        public string Mobile { get; set; }


        /// <summary>
        /// 用户头像
        /// </summary>
        public string UserPhoto { get; set; }

        /// <summary>
        /// 服务内容
        /// </summary>
        public string GoodsName { get; set; }

        public int Number { get; set; }

        public int OrderId { get; set; }

        public int OrderDetailId { get; set; }
    }

}
