﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using Newtonsoft.Json;
using VT.FW.DB;
using Mall.Common.Plugin;

namespace Mall.Module.TradePavilion
{
    public class CarrierModule
    {
        /// <summary>
        /// 载体信息仓储层对象
        /// </summary>
        private readonly RB_CarrierRepository carrierRepository = new RB_CarrierRepository();
        /// <summary>
        /// 载体地铁信息仓储层对象
        /// </summary>
        private readonly RB_CarrierMetroRepository carrierMetroRepository = new RB_CarrierMetroRepository();
        /// <summary>
        /// 载体信息仓储层对象
        /// </summary>
        private readonly RB_CompanyBrandRepository companyBrandRepository = new RB_CompanyBrandRepository();
        /// <summary>
        /// 公司信息仓储层对象
        /// </summary>
        private readonly RB_CompanyRepository companyRepository = new RB_CompanyRepository();
        /// <summary>
        /// 品牌申请
        /// </summary>
        private readonly RB_BrandApplyForRepository brandApplyForRepository = new RB_BrandApplyForRepository();
        /// <summary>
        /// 载体申请
        /// </summary>
        private readonly RB_CarrierApplyForRepository carrierApplyForRepository = new RB_CarrierApplyForRepository();
        /// <summary>
        /// 载体地铁信息
        /// </summary>
        private readonly RB_CarrierMetroApplyForRepository carrierMetroApplyForRepository = new RB_CarrierMetroApplyForRepository();
        /// <summary>
        /// 用户
        /// </summary>
        private readonly Repository.User.RB_Member_UserRepository member_UserRepository = new Repository.User.RB_Member_UserRepository();
        /// <summary>
        /// 品牌信息仓储层对象
        /// </summary>
        private readonly RB_BrandRepository brandRepository = new RB_BrandRepository();


        /// <summary>
        /// 品牌分类信息仓储层对象
        /// </summary>
        private readonly RB_BrandClassRepository brandClassRepository = new RB_BrandClassRepository();

        /// <summary>
        /// 收藏仓储层对象
        /// </summary>
        private readonly RB_CollectRepository collectRepository = new RB_CollectRepository();

        #region 载体
        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Carrier_Extend> GetCarrierPageList(int pageIndex, int pageSize, out long rowCount, RB_Carrier_Extend query, bool IsSelectUser=false)
        {
            var list = carrierRepository.GetCarrierPageList(pageIndex, pageSize, out rowCount, query);
            if (list != null && list.Any())
            {
                string carrierIds = string.Join(",", list.Select(x => x.ID));
                if (!string.IsNullOrWhiteSpace(carrierIds))
                {
                    var metroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CarrierIds = carrierIds });
                    if (metroList != null && metroList.Any())
                    {
                        foreach (var item in list)
                        {
                            item.CarrierMetroList = new List<RB_CarrierMetro_Extend>();
                            item.CarrierMetroList = metroList.Where(x => x.CarrierId == item.ID).ToList();
                        }
                    }
                }
                if (IsSelectUser) {
                    if (list.Where(x => x.UserId > 0).Any())
                    {
                        //查询用户列表
                        string userIds = string.Join(",", list.Where(x => x.UserId > 0).Select(x => x.UserId));
                        var ulist = member_UserRepository.GetList(new Model.Extend.User.RB_Member_User_Extend() { MallBaseId = query.MallBaseId, UserIds = userIds });
                        foreach (var item in list.Where(x => x.UserId > 0))
                        {
                            var umodel = ulist.Where(x => x.Id == item.UserId).FirstOrDefault();
                            item.UserName = umodel.Name;
                            item.UserIcon = umodel.Photo;
                        }
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Carrier_Extend> GetCarrierList(RB_Carrier_Extend query)
        {
            var list = carrierRepository.GetCarrierList(query);
            if (list != null && list.Any())
            {
                string carrierIds = string.Join(",", list.Select(x => x.ID));
                if (!string.IsNullOrWhiteSpace(carrierIds))
                {
                    var metroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CarrierIds = carrierIds });
                    if (metroList != null && metroList.Any())
                    {
                        foreach (var item in list)
                        {
                            if (!string.IsNullOrWhiteSpace(item.Banner))
                            {
                                item.BannerList = JsonConvert.DeserializeObject<List<string>>(item.Banner);
                            }
                            item.CarrierMetroList = new List<RB_CarrierMetro_Extend>();
                            item.CarrierMetroList = metroList.Where(x => x.CarrierId == item.ID).ToList();
                        }
                    }
                }
            }
            return list;
        }



        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_Carrier_Extend GetCarrierModel(RB_Carrier_Extend query)
        {
            var model = carrierRepository.GetCarrierList(query).FirstOrDefault();
            if (model != null && model.ID > 0)
            {
                var metroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CarrierId = model.ID });
                if (metroList != null && metroList.Any())
                {
                    
                    model.CarrierMetroList = new List<RB_CarrierMetro_Extend>();
                    model.CarrierMetroList = metroList;
                }
                if (!string.IsNullOrWhiteSpace(model.Banner))
                {
                    model.BannerList = JsonConvert.DeserializeObject<List<string>>(model.Banner);
                }
                else {
                    model.BannerList = new List<string>();
                }
            }
            return model;
        }

        /// <summary>
        /// 新增/修改载体
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCarrier(RB_Carrier_Extend model)
        {
            bool flag = false;
            int Id = 0;
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Carrier_Extend.CarrierName),model.CarrierName },
                    {nameof(RB_Carrier_Extend.Logo),model.Logo },
                    {nameof(RB_Carrier_Extend.Banner),model.Banner },
                    {nameof(RB_Carrier_Extend.VideoUrl),model.VideoUrl },
                    {nameof(RB_Carrier_Extend.Address),model.Address },
                    {nameof(RB_Carrier_Extend.LatAndLon),model.LatAndLon },
                    {nameof(RB_Carrier_Extend.Developers),model.Developers },
                    {nameof(RB_Carrier_Extend.OpenTime),model.OpenTime },
                    {nameof(RB_Carrier_Extend.CarrierSize),model.CarrierSize },
                    {nameof(RB_Carrier_Extend.ProjectType),(int)model.ProjectType },
                    {nameof(RB_Carrier_Extend.LayersNum),model.LayersNum },
                    {nameof(RB_Carrier_Extend.CarNum),model.CarNum },
                    {nameof(RB_Carrier_Extend.CarrierPlan),model.CarrierPlan },
                    {nameof(RB_Carrier_Extend.CarrierTarget),model.CarrierTarget },
                    {nameof(RB_Carrier_Extend.Location),model.Location },
                    {nameof(RB_Carrier_Extend.Crowd),model.Crowd }

                };
                flag = carrierRepository.Update(fileds, new WhereHelper(nameof(RB_Carrier_Extend.ID), model.ID));
                if (flag)
                {
                    var oldCarrierMetroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CarrierId = model.ID });
                    carrierMetroRepository.DeleteBatch(oldCarrierMetroList);
                    model.CarrierMetroList.ForEach(x => x.CarrierId = model.ID);
                    model.CarrierMetroList.ForEach(x => x.Status = 0);
                    model.CarrierMetroList.ForEach(x => x.TenantId = model.TenantId);
                    model.CarrierMetroList.ForEach(x => x.MallBaseId = model.MallBaseId);
                    carrierMetroRepository.InsertBatch(model.CarrierMetroList);
                }
            }
            else
            {
                Id = carrierRepository.Insert(model);
                if (Id > 0)
                {
                    model.CarrierMetroList.ForEach(x => x.CarrierId = Id);
                    model.CarrierMetroList.ForEach(x => x.Status = 0);
                    model.CarrierMetroList.ForEach(x => x.TenantId = model.TenantId);
                    model.CarrierMetroList.ForEach(x => x.MallBaseId = model.MallBaseId);
                    carrierMetroRepository.InsertBatch(model.CarrierMetroList);
                }
                flag = Id > 0;
            }

            return flag;
        }

        /// <summary>
        /// 验证载体名称
        /// </summary>
        /// <param name="carrierName"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool ValidateCarrierName(string carrierName, int mallBaseId)
        {
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_Carrier_Extend.CarrierName),
                      FiledValue=carrierName,
                       OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                     FiledName=nameof(RB_Carrier_Extend.MallBaseId),
                      FiledValue=mallBaseId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };
            return carrierRepository.Exists(wheres);
        }

        /// <summary>
        /// 新增修改载体申请
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCarrierApplyFor(RB_CarrierApplyFor_Extend model)
        {
            var cmodel = companyRepository.GetEntity(model.CompanyId);
            if (cmodel == null) { return false; }
            if (cmodel.FirstShopType != 2) { return false; }
            bool flag = false;
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_CarrierApplyFor_Extend.CarrierName),model.CarrierName },
                    {nameof(RB_CarrierApplyFor_Extend.Logo),model.Logo },
                    {nameof(RB_CarrierApplyFor_Extend.Banner),model.Banner },
                    {nameof(RB_CarrierApplyFor_Extend.VideoUrl),model.VideoUrl },
                    {nameof(RB_CarrierApplyFor_Extend.Address),model.Address },
                    {nameof(RB_CarrierApplyFor_Extend.LatAndLon),model.LatAndLon },
                    {nameof(RB_CarrierApplyFor_Extend.Developers),model.Developers },
                    {nameof(RB_CarrierApplyFor_Extend.OpenTime),model.OpenTime },
                    {nameof(RB_CarrierApplyFor_Extend.CarrierSize),model.CarrierSize },
                    {nameof(RB_CarrierApplyFor_Extend.ProjectType),(int)model.ProjectType },
                    {nameof(RB_CarrierApplyFor_Extend.LayersNum),model.LayersNum },
                    {nameof(RB_CarrierApplyFor_Extend.CarNum),model.CarNum },
                    {nameof(RB_CarrierApplyFor_Extend.CarrierPlan),model.CarrierPlan },
                    {nameof(RB_CarrierApplyFor_Extend.CarrierTarget),model.CarrierTarget },
                    {nameof(RB_CarrierApplyFor_Extend.Location),model.Location },
                    {nameof(RB_CarrierApplyFor_Extend.Crowd),model.Crowd },
                    {nameof(RB_CarrierApplyFor_Extend.ExistCarrierId),model.ExistCarrierId },
                };
                flag = carrierApplyForRepository.Update(fileds, new WhereHelper(nameof(RB_CarrierApplyFor_Extend.ID), model.ID));
                if (flag)
                {
                    var oldCarrierMetroList = carrierMetroApplyForRepository.GetCarrierMetroList(new RB_CarrierMetroApplyFor_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CarrierId = model.ID });
                    carrierMetroApplyForRepository.DeleteBatch(oldCarrierMetroList);
                    model.CarrierMetroList.ForEach(x =>
                    {
                        x.CarrierId = model.ID;
                        x.Status = 0;
                        x.TenantId = model.TenantId;
                        x.MallBaseId = model.MallBaseId;
                    });
                    carrierMetroApplyForRepository.InsertBatch(model.CarrierMetroList);

                    //更新认证表  资料状态为完成
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Company_Extend.IsComplete),1}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                                FiledName=nameof(RB_Company_Extend.CompanyId),
                                FiledValue= model.CompanyId,
                                OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    companyRepository.Update(keyValues, wheres);
                }
            }
            else
            {
                #region 验证载体申请是否已存在
                var oldList = carrierApplyForRepository.GetCarrierList(new RB_CarrierApplyFor_Extend() { MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                if (oldList.Any()) {
                    return false;
                }
                #endregion
                int Id = carrierApplyForRepository.Insert(model);
                if (Id > 0)
                {
                    model.CarrierMetroList.ForEach(x =>
                    {
                        x.ID = 0;
                        x.CarrierId = Id;
                        x.Status = 0;
                        x.TenantId = model.TenantId;
                        x.MallBaseId = model.MallBaseId;
                    });
                    carrierMetroApplyForRepository.InsertBatch(model.CarrierMetroList);

                    //更新认证表  资料状态为完成
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Company_Extend.IsComplete),1}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                                FiledName=nameof(RB_Company_Extend.CompanyId),
                                FiledValue= model.CompanyId,
                                OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    companyRepository.Update(keyValues, wheres);
                }
                flag = Id > 0;
            }

            return flag;
        }


        /// <summary>
        ///删除载体信息状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCarrierModule(int CarrierId, int TenantId, int MallBaseId, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Carrier_Extend.Status),Status },
            };
            bool flag = carrierRepository.Update(fileds, new WhereHelper(nameof(RB_Carrier_Extend.ID), CarrierId));
            if (flag)
            {
                var oldCarrierMetroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = TenantId, MallBaseId = MallBaseId, CarrierId = CarrierId });
                if (oldCarrierMetroList != null && oldCarrierMetroList.Any())
                {
                    oldCarrierMetroList.ForEach(x => x.Status = Common.Enum.DateStateEnum.Delete);
                    carrierMetroRepository.UpdateBatch(oldCarrierMetroList);
                }
            }
            return flag;
        }



        #endregion


        #region 公司品牌

        /// <summary>
        /// 获取品牌信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_CompanyBrand_Extend> GetBrandPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_CompanyBrand_Extend query)
        {
            return companyBrandRepository.GetBrandPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 根据查询条件获取品牌信息实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_CompanyBrand_Extend GetBrandRepository(RB_CompanyBrand_Extend query)
        {
            return companyBrandRepository.GetBrandRepository(query);
        }

        /// <summary>
        /// 新增修改品牌
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCompanyBrand(RB_CompanyBrand_Extend model)
        {
            if (model.ID == 0)
            {
                return companyBrandRepository.Insert(model) > 0;
            }
            else
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_CompanyBrand_Extend.BrandName),model.BrandName },
                    {nameof(RB_CompanyBrand_Extend.ShopNum),model.ShopNum },
                    {nameof(RB_CompanyBrand_Extend.BuiltUpArea),model.BuiltUpArea },
                    {nameof(RB_CompanyBrand_Extend.EndBuiltUpArea),model.EndBuiltUpArea },
                    {nameof(RB_CompanyBrand_Extend.FullBrandName),model.FullBrandName },
                    {nameof(RB_CompanyBrand_Extend.CustomerType),model.CustomerType },
                    {nameof(RB_CompanyBrand_Extend.CustomerOtherType),model.CustomerOtherType },
                    {nameof(RB_CompanyBrand_Extend.StoreExpansion),model.StoreExpansion },
                    {nameof(RB_CompanyBrand_Extend.ProjectType),(int)model.ProjectType },
                    {nameof(RB_CompanyBrand_Extend.AreaRequirement),model.AreaRequirement },
                    {nameof(RB_CompanyBrand_Extend.EndAreaRequirement),model.EndAreaRequirement }
                };
                return companyBrandRepository.Update(fileds, new WhereHelper(nameof(RB_CompanyBrand_Extend.ID), model.ID));
            }
        }


        #endregion


        #region 品牌
        /// <summary>
        /// 获取品牌信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Extend> GetBrandPageList(int pageIndex, int pageSize, out long rowsCount, RB_Brand_Extend query, bool IsSelectUser = false)
        {
            var list = brandRepository.GetBrandPageList(pageIndex, pageSize, out rowsCount, query);
            if (IsSelectUser)
            {
                if (list.Where(x => x.UserId > 0).Any())
                {
                    //查询用户列表
                    string userIds = string.Join(",", list.Where(x => x.UserId > 0).Select(x => x.UserId));
                    var ulist = member_UserRepository.GetList(new Model.Extend.User.RB_Member_User_Extend() { MallBaseId = query.MallBaseId, UserIds = userIds });
                    foreach (var item in list.Where(x => x.UserId > 0))
                    {
                        var umodel = ulist.Where(x => x.Id == item.UserId).FirstOrDefault();
                        item.UserName = umodel.Name;
                        item.UserIcon = umodel.Photo;
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 根据查询条件获取品牌信息实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Brand_Extend GetBrand(RB_Brand_Extend query)
        {
            return brandRepository.GetBrand(query);
        }

        /// <summary>
        /// 验证品牌名称
        /// </summary>
        /// <param name="brandName"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool ValidateBrandName(string brandName, int mallBaseId)
        {
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_Brand_Extend.BrandName),
                      FiledValue=brandName,
                       OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                     FiledName=nameof(RB_Brand_Extend.MallBaseId),
                      FiledValue=mallBaseId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };
            return brandRepository.Exists(wheres);
        }

        /// <summary>
        /// 验证品牌全称
        /// </summary>
        /// <param name="brandName"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool ValidateFullBrandName(string brandName, int mallBaseId)
        {
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_Brand_Extend.FullBrandName),
                      FiledValue=brandName,
                       OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                     FiledName=nameof(RB_Brand_Extend.MallBaseId),
                      FiledValue=mallBaseId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };
            return brandRepository.Exists(wheres);
        }

        /// <summary>
        /// 根据查询条件获取品牌信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Extend> GetBrandListByWhere(RB_Brand_Extend query)
        {
            return brandRepository.GetBrandListByWhere(query);
        }

        /// <summary>
        /// 获取品牌列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Extend> GetBrandList_V2(RB_Brand_Extend query)
        {
            return brandRepository.GetBrandList(query);
        }

        /// <summary>
        /// 新增/修改品牌
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetBrand(RB_Brand_Extend model)
        {
            if (model.ID == 0)
            {
                return brandRepository.Insert(model) > 0;
            }
            else
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Brand_Extend.UpdateDate),model.UpdateDate },
                    {nameof(RB_Brand_Extend.Logo),model.Logo },
                    {nameof(RB_Brand_Extend.Status),model.Status },
                    {nameof(RB_Brand_Extend.Banner),model.Banner },
                    {nameof(RB_Brand_Extend.VideoUrl),model.VideoUrl },
                    {nameof(RB_Brand_Extend.FullBrandName),model.FullBrandName },
                    {nameof(RB_Brand_Extend.BrandName),model.BrandName },
                    {nameof(RB_Brand_Extend.ShopNum),model.ShopNum },
                    {nameof(RB_Brand_Extend.BuiltUpArea),model.BuiltUpArea },
                    {nameof(RB_Brand_Extend.EndBuiltUpArea),model.EndBuiltUpArea },
                    {nameof(RB_Brand_Extend.BrandType),model.BrandType },
                    {nameof(RB_Brand_Extend.CustomerType),model.CustomerType },
                    {nameof(RB_Brand_Extend.StoreExpansion),model.StoreExpansion },
                    {nameof(RB_Brand_Extend.ProjectType),model.ProjectType },
                    {nameof(RB_Brand_Extend.AreaRequirement),model.AreaRequirement },
                    {nameof(RB_Brand_Extend.EndAreaRequirement),model.EndAreaRequirement },
                    {nameof(RB_Brand_Extend.Advertising),model.Advertising },
                    {nameof(RB_Brand_Extend.Other),model.Other },
                    {nameof(RB_Brand_Extend.ShopSize),model.ShopSize },
                    {nameof(RB_Brand_Extend.Plumbing),model.Plumbing },
                    {nameof(RB_Brand_Extend.Caliber),model.Caliber },
                    {nameof(RB_Brand_Extend.Sewage),model.Sewage },
                    {nameof(RB_Brand_Extend.RanQi),model.RanQi },
                    {nameof(RB_Brand_Extend.DianLiang),model.DianLiang },
                    {nameof(RB_Brand_Extend.PaiYan),model.PaiYan },
                    {nameof(RB_Brand_Extend.KongTiao),model.KongTiao },
                    {nameof(RB_Brand_Extend.XinFeng),model.XinFeng },
                    {nameof(RB_Brand_Extend.BrandClassId),model.BrandClassId },
                    {nameof(RB_Brand_Extend.RanQiBZ),model.RanQiBZ },
                    {nameof(RB_Brand_Extend.IsDianLiang),model.IsDianLiang },
                    {nameof(RB_Brand_Extend. PaiYanBZ),model. PaiYanBZ },
                    {nameof(RB_Brand_Extend.IsShopSize),model.IsShopSize },
                    {nameof(RB_Brand_Extend.OpenShopWish),model.OpenShopWish },
                };
                return brandRepository.Update(fileds, new WhereHelper(nameof(RB_Brand_Extend.ID), model.ID));
            }
        }

        /// <summary>
        /// 品牌申请
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetBrandApplyFor(RB_BrandApplyFor_Extend model)
        {
            var cmodel = companyRepository.GetEntity(model.CompanyId);
            if (cmodel == null) { return false; }
            if (cmodel.FirstShopType != 1) { return false; }
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_BrandApplyFor_Extend.UpdateDate),model.UpdateDate },
                    {nameof(RB_BrandApplyFor_Extend.Logo),model.Logo },
                    {nameof(RB_BrandApplyFor_Extend.Banner),model.Banner },
                    {nameof(RB_BrandApplyFor_Extend.VideoUrl),model.VideoUrl },
                    {nameof(RB_BrandApplyFor_Extend.FullBrandName),model.FullBrandName },
                    {nameof(RB_BrandApplyFor_Extend.BrandName),model.BrandName },
                    {nameof(RB_BrandApplyFor_Extend.ShopNum),model.ShopNum },
                    {nameof(RB_BrandApplyFor_Extend.BuiltUpArea),model.BuiltUpArea },
                    {nameof(RB_BrandApplyFor_Extend.EndBuiltUpArea),model.EndBuiltUpArea },
                    {nameof(RB_BrandApplyFor_Extend.BrandType),model.BrandType },
                    {nameof(RB_BrandApplyFor_Extend.CustomerType),model.CustomerType },
                    {nameof(RB_BrandApplyFor_Extend.StoreExpansion),model.StoreExpansion },
                    {nameof(RB_BrandApplyFor_Extend.ProjectType),model.ProjectType },
                    {nameof(RB_BrandApplyFor_Extend.AreaRequirement),model.AreaRequirement },
                    {nameof(RB_BrandApplyFor_Extend.EndAreaRequirement),model.EndAreaRequirement },
                    {nameof(RB_BrandApplyFor_Extend.Advertising),model.Advertising },
                    {nameof(RB_BrandApplyFor_Extend.Other),model.Other },
                    {nameof(RB_BrandApplyFor_Extend.ShopSize),model.ShopSize },
                    {nameof(RB_BrandApplyFor_Extend.Plumbing),model.Plumbing },
                    {nameof(RB_BrandApplyFor_Extend.Caliber),model.Caliber },
                    {nameof(RB_BrandApplyFor_Extend.Sewage),model.Sewage },
                    {nameof(RB_BrandApplyFor_Extend.RanQi),model.RanQi },
                    {nameof(RB_BrandApplyFor_Extend.DianLiang),model.DianLiang },
                    {nameof(RB_BrandApplyFor_Extend.PaiYan),model.PaiYan },
                    {nameof(RB_BrandApplyFor_Extend.KongTiao),model.KongTiao },
                    {nameof(RB_BrandApplyFor_Extend.XinFeng),model.XinFeng },
                    {nameof(RB_BrandApplyFor_Extend.BrandClassId),model.BrandClassId },
                    {nameof(RB_BrandApplyFor_Extend.RanQiBZ),model.RanQiBZ },
                    {nameof(RB_BrandApplyFor_Extend.IsDianLiang),model.IsDianLiang },
                    {nameof(RB_BrandApplyFor_Extend.PaiYanBZ),model. PaiYanBZ },
                    {nameof(RB_BrandApplyFor_Extend.IsShopSize),model.IsShopSize },
                    {nameof(RB_BrandApplyFor_Extend.OpenShopWish),model.OpenShopWish },
                    {nameof(RB_BrandApplyFor_Extend.ExistBrandId),model.ExistBrandId },
                };
                bool flag = brandApplyForRepository.Update(fileds, new WhereHelper(nameof(RB_BrandApplyFor_Extend.ID), model.ID));
                if (flag)
                {
                    //更新认证表  资料状态为完成
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Company_Extend.IsComplete),1}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Company_Extend.CompanyId),
                              FiledValue= model.CompanyId,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    companyRepository.Update(keyValues, wheres);
                }
                return flag;
            }
            else
            {
                #region 验证品牌数据是否已存在
                var oldList = brandApplyForRepository.GetBrandListByWhere(new RB_BrandApplyFor_Extend() { MallBaseId = model.MallBaseId, CompanyId = model.CompanyId });
                if (oldList.Any()) {
                    return false;
                }
                #endregion
                bool flag = brandApplyForRepository.Insert(model) > 0;
                if (flag) {
                    //更新认证表  资料状态为完成
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Company_Extend.IsComplete),1}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Company_Extend.CompanyId),
                              FiledValue= model.CompanyId,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    companyRepository.Update(keyValues, wheres);
                }
                return flag;
            }
        }

        /// <summary>
        ///删除品牌状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveBrandModule(int CarrierId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Brand_Extend.Status),1 },
            };
            bool flag = brandRepository.Update(fileds, new WhereHelper(nameof(RB_Brand_Extend.ID), CarrierId));
            return flag;
        }

        /// <summary>
        /// 获取品牌信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_BrandClass_Extend> GetBrandClassPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_BrandClass_Extend query)
        {
            return brandClassRepository.GetBrandClassPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 根据查询条件获取品牌信息实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_BrandClass_Extend GetBrandClassRepository(RB_BrandClass_Extend query)
        {
            return brandClassRepository.GetBrandClassRepository(query);

        }

        /// <summary>
        /// 根据查询条件获取品牌信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_BrandClass_Extend> GetBrandClassList(RB_BrandClass_Extend query)
        {
            return brandClassRepository.GetBrandClassList(query);
        }


        /// <summary>
        /// 新增/修改品牌分类
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetBrandClass(RB_BrandClass_Extend model)
        {
            if (model.ID == 0)
            {
                return brandClassRepository.Insert(model) > 0;
            }
            else
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_BrandClass_Extend.ClassName),model.ClassName },
                    {nameof(RB_BrandClass_Extend.Logo),model.Logo },
                    {nameof(RB_BrandClass_Extend.Status),model.Status },
                    {nameof(RB_BrandClass_Extend.UpdateDate),model.UpdateDate },
                };
                return brandClassRepository.Update(fileds, new WhereHelper(nameof(RB_BrandClass_Extend.ID), model.ID));
            }
        }

        /// <summary>
        ///删除品牌状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveBrandClassModule(int CarrierId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_BrandClass_Extend.Status),1 },
            };
            bool flag = brandClassRepository.Update(fileds, new WhereHelper(nameof(RB_BrandClass_Extend.ID), CarrierId));

            return flag;
        }

        #endregion

        #region 收藏
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Collect_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Collect_Extend query)
        {
            return collectRepository.GetPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 收藏列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Collect_Extend> GetList(RB_Collect_Extend query)
        {
            return collectRepository.GetList(query);
        }


        /// <summary>
        /// 新增/修改我关注的会员配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateCollect(RB_Collect_Extend model)
        {
            bool flag = false;
            try
            {
                int Id = 0;
                if (model.Id == 0)
                {
                    Id = collectRepository.Insert(model);
                    flag = Id > 0;
                }
                else
                {
                    Id = model.Id;
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Collect_Extend.Status),model.Status}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Collect_Extend.Id),
                              FiledValue=model.Id,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };

                    flag = collectRepository.Update(keyValues, wheres);
                }
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "AddOrUpdateCollect");
                return false;
            }
            return flag;
        }
        #endregion
    }
}
