﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 重新入库仓储类
    /// </summary>
    public partial class RB_Warehouseout_InventoryRepository : BaseRepository<RB_Warehouseout_Inventory>
    {
        /// <summary>
        /// 获取分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Warehouseout_Inventory_Extend> GetPageList(int pageIndex, int pageSize, RB_Warehouseout_Inventory_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Warehouseout_Inventory_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.WarehouseId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.WarehouseId) + $" ={dmodel.WarehouseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.OrderId) + $" ={dmodel.OrderId}";
            }
            if (dmodel.MaterialId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.MaterialId) + $" ={dmodel.MaterialId}";
            }
            if (dmodel.FinanceId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.FinanceId) + $" ={dmodel.FinanceId}";
            }

            string sql = $@" select * from RB_Warehouseout_Inventory {where} order by Id desc";            
            return GetPage<RB_Warehouseout_Inventory_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Warehouseout_Inventory_Extend> GetList(RB_Warehouseout_Inventory_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Warehouseout_Inventory_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.WarehouseId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.WarehouseId) + $" ={dmodel.WarehouseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.OrderId) + $" ={dmodel.OrderId}";
            }
            if (dmodel.OrderGoodsId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.OrderGoodsId) + $" ={dmodel.OrderGoodsId}";
            }
            if (dmodel.StockOutId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.StockOutId) + $" ={dmodel.StockOutId}";
            }
            if (dmodel.MaterialId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.MaterialId) + $" ={dmodel.MaterialId}";
            }
            if (dmodel.FinanceId > 0)
            {
                where += " and " + nameof(RB_Warehouseout_Inventory_Extend.FinanceId) + $" ={dmodel.FinanceId}";
            }

            string sql = $@" select * from RB_Warehouseout_Inventory {where} order by Id desc";
            return Get<RB_Warehouseout_Inventory_Extend>(sql).ToList();
        }
    }
}
