﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Newtonsoft.Json.Linq;
using Mall.Model.Entity.User;
using Mall.AOP;
using Mall.Module.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MContentController : BaseController
    {
        /// <summary>
        /// 内容管理
        /// </summary>
        private ContentModule contentModule = new ContentModule();

        /// <summary>
        /// 菜单处理类
        /// </summary>
        private MenuModule menuModule = new MenuModule();

        /// <summary>
        /// 商户菜单处理类对象
        /// </summary>
        private TenantMenuModule tenantMenuModule = AOPHelper.CreateAOPObject<TenantMenuModule>();

        /// <summary>
        /// 商城插件处理类对象
        /// </summary>
        private readonly TenantPlugModule tenantPlugModule = AOPHelper.CreateAOPObject<TenantPlugModule>();

        /// <summary>
        /// 插件处理类对象
        /// </summary>
        private readonly PlugInModule plugInModule = new PlugInModule();

        /// <summary>
        /// 营销中心插件配置处理类
        /// </summary>
        private MarketingPlugModule marketingPlugModule = new MarketingPlugModule();

        #region 专题分类

        /// <summary>
        /// 专题分类分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicTypePageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Topic_Type_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicTypePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取专题分类列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicTypeList()
        {
            var query = JsonConvert.DeserializeObject<RB_Topic_Type_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicTypeListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改专题分类
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTopicType()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Topic_Type_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetTopicTypeModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取专题分类实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetTopicTypeModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除专题分类
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveTopicType()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveTopicTypeModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新专题分类状态
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateTopicTypeStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsDisable = parms.GetInt("IsDisable");
            var flag = contentModule.UpdateTopicTypeStatusModule(Id, IsDisable);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 专题

        /// <summary>
        /// 专题分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Topic_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取专题列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopicList()
        {
            var query = JsonConvert.DeserializeObject<RB_Topic_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetTopicListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改专题
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTopic()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Topic_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            if (extModel.ComponentDataList != null && extModel.ComponentDataList.Count > 0)
            {
                extModel.TemplateData = JsonConvert.SerializeObject(extModel.ComponentDataList);
            }
            var flag = contentModule.SetTopicModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取专题实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetTopic()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetTopicModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除专题
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveTopic()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveTopicModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 门店

        /// <summary>
        /// 门店分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetStoresPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Stores_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetStoresPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 门店分类列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetStoresList()
        {
            var query = JsonConvert.DeserializeObject<RB_Stores_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetStoresListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改门店
        /// </summary>
        /// <returns></returns>
        public ApiResult SetStores()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Stores_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetStoresModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取门店实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetStores()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetStoresModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除门店
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveStores()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveStoresModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 视频

        /// <summary>
        /// 视频分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetVideoPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Video_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetVideoPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取视频列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetVideoList()
        {
            var query = JsonConvert.DeserializeObject<RB_Video_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetVideoListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改视频
        /// </summary>
        /// <returns></returns>
        public ApiResult SetVideo()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Video_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetVideoModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取视频实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetVideo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetVideoModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除视频
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveVideo()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveVideoModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 文章

        /// <summary>
        /// 文章分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetArticlePageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Article_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetArticlePageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取文章列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetArticleList()
        {
            var query = JsonConvert.DeserializeObject<RB_Article_Extend>(RequestParm.msg.ToString());
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = contentModule.GetArticleListModule(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改文章
        /// </summary>
        /// <returns></returns>
        public ApiResult SetArticle()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Article_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = RequestParm.TenantId;
            extModel.CreateDate = DateTime.Now;
            var flag = contentModule.SetArticleModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取文章实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetArticle()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = contentModule.GetArticleModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 删除文章
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveArticle()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var flag = contentModule.RemoveArticleModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 更新文章状态
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateArticleStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var IsDisable = parms.GetInt("IsDisable");
            var flag = contentModule.UpdateArticleIsDisableModule(Id, IsDisable);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        #endregion

        #region 商城菜单

        /// <summary>
        /// 获取小程序菜单列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetTenantMenu()
        {
            var list = JsonConvert.DeserializeObject<List<RB_Tenant_Menu_Extend>>(RequestParm.msg.ToString());
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    item.TenantId = RequestParm.TenantId;
                }
            }
            var flag = tenantMenuModule.SetTenantMenuModule(list);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商户菜单列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTenantMenuList()
        {
            List<object> result = new List<object>();
            var menuList = menuModule.GetMenuListModule(new RB_Menu_Extend());
            if (menuList != null && menuList.Count > 0)
            {
                var tenantMenuList = tenantMenuModule.GetTenantMenuListModule(new RB_Tenant_Menu_Extend() { TenantId = RequestParm.TenantId });
                foreach (var item in menuList.Where(qitem => qitem.MenuLevel == 1))
                {
                    List<object> secondList = new List<object>();
                    foreach (var subItem in menuList.Where(qitem => qitem.MenuLevel == 2 && qitem.ParentId == item.MenuId))
                    {
                        List<object> childList = new List<object>();
                        foreach (var thirdItem in menuList.Where(qitem => qitem.MenuLevel == 3 && qitem.ParentId == subItem.MenuId))
                        {
                            childList.Add(new
                            {
                                thirdItem.MenuId,
                                thirdItem.MenuName,
                                thirdItem.ParentId,
                                IsChecked = tenantMenuList?.Where(qitem => qitem.MenuId == thirdItem.MenuId)?.Count() > 0,
                                SubMenuList = new List<string>()
                            });
                        }
                        secondList.Add(new
                        {
                            subItem.MenuId,
                            subItem.MenuName,
                            subItem.ParentId,
                            IsChecked = tenantMenuList?.Where(qitem => qitem.MenuId == subItem.MenuId)?.Count() > 0,
                            SubMenuList = childList
                        });
                    }
                    var obj = new
                    {
                        item.MenuId,
                        item.MenuName,
                        item.ParentId,
                        IsChecked = tenantMenuList?.Where(qitem => qitem.MenuId == item.MenuId)?.Count() > 0,
                        SubMenuList = secondList
                    };
                    result.Add(obj);
                }
            }
            return ApiResult.Success(data: result);
        }
        #endregion

        #region  营销中心插件配置

        /// <summary>
        /// 获取营销中心插件分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMarketingPlugPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_Marketing_Plug_Extend>(RequestParm.msg.ToString());
            var list = marketingPlugModule.GetMarketingPlugPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取营销中心插件列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMarketingPlugList()
        {
            var query = JsonConvert.DeserializeObject<RB_Marketing_Plug_Extend>(RequestParm.msg.ToString());
            query.TenantId = RequestParm.TenantId;
            var plugList = marketingPlugModule.GetMarketingPlugListModule(query);
            List<object> result = new List<object>();
            if (plugList != null && plugList.Count > 0)
            {
                var typeList = plugList.GroupBy(qitem => new { qitem.PlugType, qitem.PlugTypeName }).Select(qitem => new { qitem.Key.PlugType, qitem.Key.PlugTypeName });
                foreach (var item in typeList)
                {
                    var obj = new
                    {
                        item.PlugType,
                        item.PlugTypeName,
                        SubList = plugList.Where(qitem => qitem.PlugType == item.PlugType).ToList()
                    };
                    result.Add(obj);
                }
            }
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 新增修改营销中心插件
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMarketingPlug()
        {
            var extModel = JsonConvert.DeserializeObject<RB_Marketing_Plug_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            var flag = marketingPlugModule.SetMarketingPlugModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取营销中心插件实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMarketingPlug()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var PId = parms.GetInt("PId", 0);
            var extModel = marketingPlugModule.GetMarketingPlugModule(PId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 修改营销中心插件状态
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveMarketingPlug()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var PId = parms.GetInt("PId", 0);
            var Status = parms.GetInt("Status");
            var flag = marketingPlugModule.RemoveMarketingPlugModule(PId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 新增修改营销中心插件配置
        /// </summary>
        /// <returns></returns>
        public ApiResult GetMarketingConfigList()
        {
            var query = JsonConvert.DeserializeObject<RB_Marketing_Config_Extend>(RequestParm.msg.ToString());
            query.TenantId = RequestParm.TenantId;
            var plugList = marketingPlugModule.GetMarketingPlugListModule(new RB_Marketing_Plug_Extend());
            var configList = marketingPlugModule.GetMarketingConfigListModule(query);
            List<object> result = new List<object>();
            if (plugList != null && plugList.Count > 0)
            {
                var typeList = plugList.GroupBy(qitem => new { qitem.PlugType, qitem.PlugTypeName }).Select(qitem => new { qitem.Key.PlugType, qitem.Key.PlugTypeName });
                foreach (var item in typeList)
                {
                    List<object> childList = new List<object>();
                    var childDataList = plugList.Where(qitem => qitem.PlugType == item.PlugType).ToList();
                    foreach (var subItem in childDataList)
                    {
                        var subObj = new
                        {
                            subItem.PId,
                            subItem.PlugName,
                            IsChecked = configList?.Where(qitem => qitem.PlugId == subItem.PId).Count() > 0
                        };
                        childList.Add(subObj);
                    }
                    var obj = new
                    {
                        item.PlugType,
                        item.PlugTypeName,
                        IsChecked=false,
                        SubList = childList
                    };
                    result.Add(obj);
                }
            }
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 新增修改营销中心插件配置
        /// </summary>
        /// <returns></returns>
        public ApiResult SetMarketingConfig()
        {
            var list = JsonConvert.DeserializeObject<List<RB_Marketing_Config_Extend>>(RequestParm.msg.ToString());
            foreach (var item in list)
            {
                item.TenantId = RequestParm.TenantId;
            }
            var flag = marketingPlugModule.SetMarketingConfigModule(list);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 商城插件

        /// <summary>
        /// 获取小程序插件列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetTenantPlug()
        {
            var list = JsonConvert.DeserializeObject<List<RB_Tenant_Plug_Extend>>(RequestParm.msg.ToString());
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    item.TenantId = RequestParm.TenantId;
                }
            }
            var flag = tenantPlugModule.SetTenantPlugModule(list);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取商户插件列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetTenantPlugList()
        {
            List<object> result = new List<object>();
            var plugList = plugInModule.GetPlugInListModule(new  RB_PlugIn_Extend());
            if (plugList != null && plugList.Count > 0)
            {
                var tenantPlugList = tenantPlugModule.GetTenantPlugListModule( new RB_Tenant_Plug_Extend  { TenantId = RequestParm.TenantId });
                var plugTypeList = plugList.GroupBy(qitem => qitem.PlugType).Select(qitem => new { qitem.Key});
                foreach (var item in plugTypeList)
                {
                    List<object> secondList = new List<object>();
                    var subList = plugList.Where(qitem => qitem.PlugType == item.Key).ToList();
                    foreach (var subItem in subList)
                    {
                        secondList.Add(new
                        {
                            subItem.Id,
                            subItem.Name,
                            subItem.PlugId,
                            subItem.PlugType,
                            subItem.Icon,
                            IsChecked = tenantPlugList?.Where(qitem => qitem.PlugId == subItem.PlugId)?.Count() > 0,
                        });
                    }
                    string PlugTypeName = "";
                    if (item.Key == 1)
                    {
                        PlugTypeName = "基础组件";
                    }
                    else if (item.Key == 2)
                    {
                        PlugTypeName = "营销组件";
                    }
                    else if (item.Key == 3)
                    {
                        PlugTypeName = "其他组件";
                    }
                    result.Add(new
                    {
                        Id="",
                        Name= PlugTypeName,
                        PlugId=0,
                        PlugType=item.Key,
                        Icon="",
                        SubList = secondList
                    });
                }
            }
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 获取插件分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetPlugInPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = JsonConvert.DeserializeObject<RB_PlugIn_Extend>(RequestParm.msg.ToString());
            query.TenantId = RequestParm.TenantId;
            var list = plugInModule.GetPlugInPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改插件
        /// </summary>
        /// <returns></returns>
        public ApiResult SetPlugIn()
        {
            var extModel = JsonConvert.DeserializeObject<RB_PlugIn_Extend>(RequestParm.msg.ToString());
            extModel.Status = 0;
            extModel.TenantId = RequestParm.TenantId;
            var flag = plugInModule.SetPlugInModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取插件实体
        /// </summary>
        /// <returns></returns>
        public ApiResult GetPlugIn()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var PlugId = parms.GetInt("PlugId", 0);
            var extModel = plugInModule.GetPlugInModule(PlugId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 修改插件状态
        /// </summary>
        /// <returns></returns>
        public ApiResult SetPlugInStatus()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var PlugId = parms.GetInt("PlugId", 0);
            var Status = parms.GetInt("Status", 0);
            var flag = plugInModule.SetPlugInStatusModule(PlugId, Status);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion
    }
}