
using System;
using System.Reflection;
using System.Text.RegularExpressions;

namespace Mall.Common.Plugin
{
    /// <summary>
    /// ֤
    /// </summary>
    public static class ValidateHepler
    {

        /// <summary>
        /// okΪϷΪϷ
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static string Validate(this object obj)
        {
            Type type = obj.GetType();
            PropertyInfo[] fields = type.GetProperties();
            foreach (var item in fields)
            {
                if (item.IsDefined(typeof(AbstractValidateAttribute), true))
                {
                    object[] validateAttribute = item.GetCustomAttributes(typeof(AbstractValidateAttribute), true);
                    foreach (var validate in validateAttribute)
                    {
                        AbstractValidateAttribute val = (AbstractValidateAttribute)validate;
                        string message = val.CheckValiadte(item.Name, item.GetValue(obj));
                        if (!message.Equals("ok"))
                        {
                            return message;
                        }
                    }
                }
            }
            return "ok";
        }
        /// <summary>
        /// ַ֤Ƿ
        /// </summary>
        /// <param name="val"></param>
        /// <returns></returns>
        public static bool IsNumber(string val)
        {
            if (val == "0")
                return true;
            if (string.IsNullOrEmpty(val))
                return false;


            return Regex.IsMatch(val, @"^[1-9]\d*\.?[0]*$");
        }

        /// <summary>
        /// ǷEmail
        /// </summary>
        /// <param name="email"></param>
        /// <returns></returns>
        public static bool IsEmail(string email)
        {
            return Regex.IsMatch(email, @"^([0-9a-z]+[-._+&])*[0-9a-z]+@([-0-9a-z]+[.])+[a-z]{2,6}$", RegexOptions.IgnoreCase);
        }

        /// <summary>
        /// Ƿҳַ
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public static bool IsURL(string url)
        {
            return Regex.IsMatch(url, @"^(http|https|ftp)\://[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(:[a-zA-Z0-9]*)?/?([a-zA-Z0-9\-\._\?\,\'/\\\+&%\$#\=~])*[^\.\,\)\(\s]$");
        }

        /// <summary>
        /// Ƿֻ
        /// </summary>
        /// <param name="mobileNumber">ֻ</param>
        /// <returns>ǷЧ</returns>
        public static bool IsMobileNumber(string mobileNumber)
        {
            if (string.IsNullOrWhiteSpace(mobileNumber))
            {
                return false;
            }
            if (Regex.IsMatch(mobileNumber, "^1[3456789]\\d{9}$", RegexOptions.IgnoreCase))
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary>
        /// жϴĲǷЧڸʽ
        /// </summary>
        /// <param name="dateTime">Ҫжϵַ</param>
        /// <returns>ǷЧ</returns>
        public static bool IsDateTime(string dateTime)
        {
            try
            {
                DateTime dteConvert = DateTime.Parse(dateTime.ToString());
                return true;
            }
            catch (FormatException)
            {
                return false;
            }
        }
    }
    /// <summary>
    /// ֤
    /// </summary>
    [AttributeUsage(AttributeTargets.Property)]
    public abstract class AbstractValidateAttribute : System.Attribute
    {
        /// <summary>
        /// ɹʾϢ
        /// </summary>
        protected string successMessage = "ok";

        /// <summary>
        /// ʾϢ
        /// </summary>
        public string showMessage = "";

        /// <summary>
        /// ֤
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">ֵ</param>
        /// <returns></returns>
        public abstract string CheckValiadte(string name, object value);
    }
    /// <summary>
    /// ַΧ֤
    /// </summary>
    public class IntRangeValidateAttribute : AbstractValidateAttribute
    {
        private int _min = 0;
        private int _max = 0;

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="min"></param>
        /// <param name="max"></param>
        public IntRangeValidateAttribute(int min, int max)
        {
            this._min = min;
            this._max = max;
        }

        /// <summary>
        /// ַΧ֤
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public override string CheckValiadte(string name, object value)
        {

            if (value == null || string.IsNullOrWhiteSpace(value.ToString()))
            {
                return successMessage;
            }
            int _value = (int)value;
            if (_value >= _min && _value <= _max)
            {

                return successMessage;
            }
            else
            {
                if (!string.IsNullOrWhiteSpace(showMessage))
                {
                    return showMessage;
                }
                else
                {
                    return $"{name}ֵΧΪ{_min}{_max}";
                }
            }
        }
    }
    /// <summary>
    /// ַ֤
    /// </summary>
    public class RequiredValidateAttribute : AbstractValidateAttribute
    {
        /// <summary>
        /// ַ֤
        /// </summary>
        /// <param name="name">ʾ</param>
        /// <param name="value">ֵ</param>
        /// <returns></returns>
        public override string CheckValiadte(string name, object value)
        {

            if (value == null || string.IsNullOrWhiteSpace(value.ToString()))
            {
                if (!string.IsNullOrWhiteSpace(showMessage))
                {
                    return showMessage;
                }
                else
                {
                    return $"{name}Ϊֶ";
                }
            }
            else
            {
                return successMessage;
            }

        }
    }
    /// <summary>
    /// ַΧ֤
    /// </summary>
    public class StringRangeValidateAttribute : AbstractValidateAttribute
    {
        private int _min = 0;
        private int _max = 0;

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="min"></param>
        /// <param name="max"></param>
        public StringRangeValidateAttribute(int min, int max)
        {
            this._min = min;
            this._max = max;
        }

        /// <summary>
        /// ַΧ֤
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public override string CheckValiadte(string name, object value)
        {

            if (value == null || string.IsNullOrWhiteSpace(value.ToString()))
            {
                return successMessage;
            }
            string _value = value.ToString();
            if (_value.Length >= _min && _value.Length <= _max)
            {

                return successMessage;
            }
            else
            {
                if (!string.IsNullOrWhiteSpace(showMessage))
                {
                    return showMessage;
                }
                else
                {
                    return $"{name}ĳȷΧΪ{_min}{_max}ַ";
                }
            }
        }
    }

    /// <summary>
    /// У
    /// </summary>
    public class IsNumberValidateAttribute : AbstractValidateAttribute
    {
        /// <summary>
        /// У
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public override string CheckValiadte(string name, object value)
        {
            if (value == null || string.IsNullOrWhiteSpace(value.ToString()))
            {
                return successMessage;
            }
            string number = value.ToString();

            if (!Regex.IsMatch(number, @"^[0-9]\d*\.?[0]*$"))
            {
                if (!string.IsNullOrWhiteSpace(showMessage))
                {
                    return showMessage;
                }
                else
                {
                    return $"{name}Ϊ";
                }
            }
            else
            {
                return successMessage;
            }


        }
    }
    /// <summary>
    /// У
    /// </summary>
    public class IsEmailValidateAttribute : AbstractValidateAttribute
    {
        /// <summary>
        /// У
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public override string CheckValiadte(string name, object value)
        {
            if (value == null || string.IsNullOrWhiteSpace(value.ToString()))
            {
                return successMessage;
            }
            string email = value.ToString();

            if (string.IsNullOrEmpty(email))
            {
                return showMessage;
            }
            else
            {
                if (!Regex.IsMatch(email, @"^([0-9a-z]+[-._+&])*[0-9a-z]+@([-0-9a-z]+[.])+[a-z]{2,6}$", RegexOptions.IgnoreCase))
                {
                    if (!string.IsNullOrWhiteSpace(showMessage))
                    {
                        return showMessage;
                    }
                    else
                    {
                        return $"{name}ΪϷ";
                    }
                }
                else
                {
                    return successMessage;
                }
            }

        }
    }
    /// <summary>
    /// ʱ֤
    /// </summary>
    public class IsDateTimeValidateAttribute : AbstractValidateAttribute
    {
        /// <summary>
        /// ʱ֤
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public override string CheckValiadte(string name, object value)
        {
            if (value == null || string.IsNullOrWhiteSpace(value.ToString()))
            {
                return successMessage;
            }
            try
            {
                Convert.ToDateTime(value.ToString());
                return successMessage;
            }
            catch (Exception)
            {
                return $"{name}Ϊڸʽ";
            }

        }
    }

    /// <summary>
    /// ʽ֤
    /// </summary>
    public class RegularValidateAttribute : AbstractValidateAttribute
    {

        private string pattern = "";
        /// <summary>
        ///
        /// </summary>
        /// <param name="pattern">֤</param>
        public RegularValidateAttribute(string pattern)
        {
            this.pattern = pattern;
        }
        /// <summary>
        /// ֤
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        public override string CheckValiadte(string name, object value)
        {
            if (value == null || string.IsNullOrWhiteSpace(value.ToString()))
            {
                return successMessage;
            }
            if (!Regex.IsMatch(value.ToString(), pattern, RegexOptions.IgnoreCase))
            {
                if (!string.IsNullOrWhiteSpace(showMessage))
                {
                    return showMessage;
                }
                else
                {
                    return $"{name}زϷ";
                }
            }
            else
            {
                return successMessage;
            }

        }
    }

}
