﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 退货地址仓储层
    /// </summary>
    public class RB_Logistics_DeliveryRepository : RepositoryBase<RB_Logistics_Delivery>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Logistics_Delivery); } }


        // <summary>
        /// 表名称
        /// </summary>
        public string DestinationTableName { get { return nameof(RB_Destination); } }

        /// <summary>
        /// 退货地址列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Delivery_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Logistics_Delivery_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.`Name` as ProvinceName,c.`Name` as CityName,d.`Name` as DistrictName  FROM {TableName} as a
 LEFT JOIN {DestinationTableName} as b on a.ProvinceId = b.ID
 LEFT JOIN {DestinationTableName} as c on a.CityId = c.ID
 LEFT JOIN {DestinationTableName} as d on a.DistrictId = d.ID WHERE  a.{nameof(RB_Logistics_Delivery_Extend.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Logistics_Delivery_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Logistics_Delivery_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND (a.{nameof(RB_Logistics_Delivery_Extend.Name)} like '%{query.Name}%' or a.{nameof(RB_Logistics_Delivery_Extend.Mobile)} like '%{query.Mobile}%') ");
                }

            }
            return GetPage<RB_Logistics_Delivery_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 退货地址列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Delivery_Extend> GetLogisticsDeliveryList(RB_Logistics_Delivery_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.`Name` as ProvinceName,c.`Name` as CityName,d.`Name` as DistrictName  FROM {TableName} as a
 LEFT JOIN { DestinationTableName} as b on a.ProvinceId = b.ID
 LEFT JOIN { DestinationTableName} as c on a.CityId = c.ID
 LEFT JOIN { DestinationTableName} as d on a.DistrictId = d.ID WHERE a.{ nameof(RB_Logistics_Delivery_Extend.Status)}= 0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Logistics_Delivery_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Logistics_Delivery_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Logistics_Delivery_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND a.{nameof(RB_Logistics_Delivery_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrWhiteSpace(query.Mobile))
                {
                    builder.Append($" AND a.{nameof(RB_Logistics_Delivery_Extend.Mobile)} like '%{query.Mobile}%'");
                }
            }
            return Get<RB_Logistics_Delivery_Extend>(builder.ToString()).ToList();
        }
    }
}
