﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    public class RB_WarehouseOut_GoodsRepository : RepositoryBase<RB_WarehouseOut_Goods>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_WarehouseOut_Goods); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableNameApply { get { return nameof(RB_WarehouseOut_Apply); } }
        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Goods_Extend> GetWarehouseOutPageList(int pageIndex, int pageSize, out long rowCount, RB_WarehouseOut_Goods_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" select * from {TableName} as a where a.Status=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.ID)}={query.ID}");
                }

                if (query.ApplyId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.ApplyId)}={query.ApplyId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.GoodsName))
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.GoodsName)} like '%{query.GoodsName}%'");
                }
                if (query.SupplierId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.SupplierId)}={query.SupplierId}");
                }
                if (!string.IsNullOrWhiteSpace(query.OrderGoodsIds))
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.OrderGoodsId)} in ({query.OrderGoodsIds})");
                }
            }
            return GetPage<RB_WarehouseOut_Goods_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 出库申请列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Goods_Extend> GetWarehouseOutList(RB_WarehouseOut_Goods_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" select * from {TableName} as a where a.Status=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.ID)}={query.ID}");
                }
                if (query.ApplyId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.ApplyId)}={query.ApplyId}");
                }

                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.GoodsName))
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.GoodsName)} like '%{query.GoodsName}%'");
                }
                if (query.SupplierId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.SupplierId)}={query.SupplierId}");
                }
            }
            return Get<RB_WarehouseOut_Goods_Extend>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取已出库的商品列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_WarehouseOut_Goods_Extend> GetWarehouseOutListByIds(RB_WarehouseOut_Goods_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" select * from {TableName} as a LEFT JOIN {TableNameApply} as b on a.ApplyId=b.ID where a.Status=0  and b.`Status`=0 and b.ApplyStatus in(1,2) ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.ID)}={query.ID}");
                }
                if (query.ApplyId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.ApplyId)}={query.ApplyId}");
                   
                }

                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.TenantId)}={query.TenantId}");
                    builder.Append($" AND b.{nameof(RB_WarehouseOut_Apply.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.MallBaseId)}={query.MallBaseId}");
                    builder.Append($" AND b.{nameof(RB_WarehouseOut_Apply.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.GoodsName))
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.GoodsName)} like '%{query.GoodsName}%'");
                }
                if (query.SupplierId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.SupplierId)}={query.SupplierId}");
                }

                if (!string.IsNullOrWhiteSpace(query.OrderGoodsIds))
                {
                    builder.Append($" AND a.{nameof(RB_WarehouseOut_Goods_Extend.OrderGoodsId)} in ({query.OrderGoodsIds})");
                }
            }
            return Get<RB_WarehouseOut_Goods_Extend>(builder.ToString()).ToList();
        }
    }
}
