﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Entity.User;
using Mall.Model.Extend.BaseSetUp;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Module.BaseSetUp;
using Mall.Module.MarketingCenter;
using Mall.Module.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;


namespace Mall.WebApi.Controllers.MallBase
{
    /// <summary>
    /// 小程序商城控制器
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]

    public class MallController : BaseController
    {
        /// <summary>
        /// 商户账号处理类
        /// </summary>
        private Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();


        /// <summary>
        /// 自定义页面处理类
        /// </summary>
        private readonly MiniprogramPageTemplModule miniprogramPageTemplModule = new MiniprogramPageTemplModule();

        /// <summary>
        /// 自定义模板处理类
        /// </summary>
        private readonly MiniprogramTemplateModule miniprogramTemplateModule = new MiniprogramTemplateModule();

        /// <summary>
        /// 产品处理类
        /// </summary>
        private readonly ProductModule productModule = new ProductModule();

        /// <summary>
        /// 导航图标处理类
        /// </summary>
        private readonly MiniProgramNaviconModule programNaviconModule = new MiniProgramNaviconModule();

        /// <summary>
        /// 内容管理
        /// </summary>
        private readonly ContentModule contentModule = new ContentModule();

        /// <summary>
        /// 小程序首页
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetHome()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            //小程序Id
            var MiniAppId = parms.GetStringValue("MiniAppId");
            MiniAppId = RequestParm.MiniAppId;
           
            var homePage = new object();
            if (MiniAppId != null && !string.IsNullOrEmpty(MiniAppId))
            {
                //获取小程序信息
                var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetHomeData: true);
                if (miniProgram != null && miniProgram.MallBaseId > 0)
                {
                    var selfHomePage = miniprogramPageTemplModule.GetMiniprogramPageTemplModule(new RB_Miniprogram_Page_Templ_Extend()
                    {
                        MallBaseId = miniProgram.MallBaseId,
                        TenantId = miniProgram.TenantId,
                    }, isGetHome: true);
                    List<object> list = new List<object>();
                    //自定义首页
                    if (selfHomePage != null && selfHomePage.Id > 0)
                    {
                        //获取模板编号
                        string templateIds = string.Join(",", selfHomePage.DetailsList.Select(qitem => qitem.TemplateId));
                        var templateList = miniprogramTemplateModule.GetMiniprogramTemplateListModule(new Model.Extend.MarketingCenter.RB_Miniprogram_Template_Extend()
                        {
                            MallBaseId = miniProgram.MallBaseId,
                            TenantId = miniProgram.TenantId,
                            QIds = templateIds
                        }, IsAnalyzePlus: true);
                        //解析模板
                        foreach (var item in templateList)
                        {
                            var detailsModel = selfHomePage?.DetailsList?.Where(qitem => qitem.TemplateId == item.Id)?.FirstOrDefault();
                            var templateData = new
                            {
                                id = detailsModel?.Id ?? 0,
                                name = detailsModel?.NavName ?? "",
                                data = new List<object>()
                            };
                            if (item.ComponentDataList != null && item.ComponentDataList.Count() > 0)
                            {
                                foreach (var subItem in item.ComponentDataList)
                                {
                                    templateData.data.Add(PlusDataToObject(subItem, (miniProgram?.TenantId ?? 0), miniProgram.MallBaseId));
                                }
                            }
                            var tempObj = new
                            {
                                id = item.Id,
                                name = item.TemplateName,
                                page_id = 0,
                                template_id = item.Id,
                                template = templateData
                            };
                            list.Add(tempObj);
                        }

                        homePage = new
                        {
                            id = miniProgram.MallBaseId,
                            title = miniProgram.MallName,
                            show_navs = selfHomePage.IsShowNav,
                            is_home_page = selfHomePage.IsHome,
                            navs = list
                        };
                    }
                    //自定义首页布局
                    else
                    {
                        //配置了首页
                        if (miniProgram.HomeDataList != null && miniProgram.HomeDataList.Count > 0)
                        {
                            var templateData = new
                            {
                                id = 0,
                                name = "",
                                data = new List<object>()
                            };
                            foreach (var subitem in miniProgram.HomeDataList)
                            {
                                switch (subitem.key)
                                {
                                    //搜索框
                                    case "search":
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new searchItem()
                                            {
                                                color = "#FFFFFF",
                                                background = "#f2f2f2", //背景颜色
                                                radius = 4, //圆角
                                                placeholder = "搜索", //提示文字
                                                textColor = "#555555", //文字颜色
                                                textPosition = "left" //文字位置
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;

                                    //轮播图
                                    case "banner":
                                        var bannerList = programModule.GetMallNavListModule(new Model.Entity.User.RB_Mall_Nav_Extend() { TenantId = miniProgram.TenantId, MallBaseId = miniProgram.MallBaseId });
                                        var detailsBannerList = new List<bannerDetailItem>();
                                        if (bannerList != null && bannerList.Count > 0)
                                        {
                                            foreach (var bItem in bannerList)
                                            {
                                                detailsBannerList.Add(new bannerDetailItem()
                                                {
                                                    url = bItem.NavLink,
                                                    picUrl = Common.Config.GetFileUrl(bItem.NavImg)
                                                });
                                            }
                                        }
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new bannerItem()
                                            {
                                                style = 1, //样式
                                                fill = 1, //填充方式0-留白 1填充
                                                height = 450, //默认高度
                                                banners = detailsBannerList
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //导航图标
                                    case "home_nav":
                                        var navList = programNaviconModule.GetMiniProgramNaviconListModule(new RB_MiniProgram_Navicon_Extend()
                                        {
                                            MallBaseId = miniProgram.MallBaseId
                                        });
                                        List<navIconItem> navs = new List<navIconItem>();
                                        if (navList != null && navList.Count > 0)
                                        {
                                            foreach (var nItem in navList)
                                            {
                                                navs.Add(new navIconItem()
                                                {
                                                    icon = Common.Config.GetFileUrl(nItem.NavIconImg),
                                                    url = nItem.NavIconUrl,
                                                    key = "",
                                                    name = nItem.NavIconName,
                                                    openType = ""
                                                });
                                            }
                                        }
                                        templateData.data.Add(new
                                        {
                                            id = "nav",
                                            data = new navItem()
                                            {
                                                color = "#353535",
                                                rows = 1,//每页行数
                                                columns = subitem.row_num, //每行个数 
                                                scroll = true, //左右滑动
                                                showImg = false, //背景图片
                                                backgroundColor = "#ffffff", //背景颜色
                                                backgroundPicUrl = "", //背景链接
                                                position = 5, //图片位置
                                                mode = 1, //填充方式
                                                backgroundHeight = 100, //背景图宽
                                                backgroundWidth = 100, //背景图高
                                                navs = navs, //导航图标
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;

                                    //视频插件
                                    case "video":
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new videoItem()
                                            {
                                                pic_url = Common.Config.GetFileUrl(subitem.video_pic_url),
                                                url = subitem.video_url,
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //公告
                                    case "notice":
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new noticeItem()
                                            {
                                                name = subitem.NoticeName, //公告名称
                                                content = subitem.NoticeContent, //公告内容
                                                icon = Common.Config.GetFileUrl(subitem.notice_url), //公告图标
                                                textColor = subitem.notice_text_color, //文字颜色
                                                background = subitem.notice_bg_color, //背景颜色
                                                headerUrl = "", //头部图片
                                                btnColor = "#ff4544", //按钮颜色
                                                btnWidth = 500, //按钮宽度 
                                                btnHeight = 80, //按钮高度 
                                                btnRadius = 40, //按钮圆角 
                                                btnText = "我知道了", //按钮文本内容
                                                btnTextColor = "#ffffff" //按钮文本颜色
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //专题
                                    case "topic":
                                        var topicSourceList = contentModule.GetTopicListModule(new Model.Entity.User.RB_Topic_Extend()
                                        {
                                            MallBaseId = miniProgram.MallBaseId,
                                            TenantId = miniProgram.TenantId,
                                        });
                                        var topic_list = new List<topicDetailsItem>();
                                        if (topicSourceList != null && topicSourceList.Count > 0)
                                        {
                                            foreach (var tItem in topicSourceList)
                                            {
                                                topic_list.Add(new topicDetailsItem()
                                                {
                                                    cover_pic = Common.Config.GetFileUrl(tItem.CoverImg),
                                                    read_count = 0,
                                                    title = tItem.Title,
                                                    id = tItem.Id,
                                                    layout = 0
                                                });
                                            }
                                        }
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new topicItem()
                                            {
                                                style = "normal",
                                                count = subitem.topic_num,
                                                logo_1 = Common.Config.GetFileUrl(subitem.topic_url),
                                                logo_2 = Common.Config.GetFileUrl(subitem.topic_url_2),
                                                icon = Common.Config.GetFileUrl(subitem.label_url),
                                                cat_show = false,
                                                list = new List<topicTypeItem>(),
                                                topic_list = topic_list
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //领劵中心
                                    case "coupon":

                                        break;
                                    //商品分类
                                    case "cat":
                                        var cats = new catItem()
                                        {
                                            goodsNum = 6,
                                            id = subitem.relation_id,
                                            menuName = subitem.name,
                                            name = subitem.name,
                                            staticGoods = false,
                                            goodsList = new List<GoodsDetailsItem2>()
                                        };
                                        if (subitem.relation_id == 0)
                                        {
                                            var goodsList = productModule.GetProductGoodsPageList(1, 6, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                            {
                                                TenantId = Convert.ToInt32(miniProgram.TenantId),
                                                MallBaseId = miniProgram.MallBaseId
                                            });
                                            if (goodsList != null && goodsList.Count > 0)
                                            {

                                                foreach (var gItem in goodsList)
                                                {
                                                    cats.goodsList.Add(new GoodsDetailsItem2()
                                                    {
                                                        id = gItem.Id,
                                                        price = gItem?.SellingPrice ?? 0,
                                                        name = gItem.Name,
                                                        picUrl = Common.Config.GetFileUrl(gItem.CoverImage)
                                                    });
                                                }
                                            }
                                        }
                                        else
                                        {
                                            var goodsList = productModule.GetProductGoodsPageList(1, 6, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                            {
                                                TenantId = Convert.ToInt32(miniProgram.TenantId),
                                                MallBaseId = miniProgram.MallBaseId,
                                                CategoryIds = subitem.relation_id.ToString()
                                            });
                                            if (goodsList != null && goodsList.Count > 0)
                                            {
                                                foreach (var gItem in goodsList)
                                                {
                                                    cats.goodsList.Add(new GoodsDetailsItem2()
                                                    {
                                                        id = gItem.Id,
                                                        price = gItem?.SellingPrice ?? 0,
                                                        name = gItem.Name,
                                                        picUrl = Common.Config.GetFileUrl(gItem.CoverImage)
                                                    });
                                                }
                                            }
                                        }
                                        templateData.data.Add(new
                                        {
                                            id = "goods",
                                            data = new goodsItem()
                                            {
                                                showCat = true,
                                                catPosition = "top",
                                                catStyle = 0,
                                                addGoodsType = 0,
                                                goodsLength = 6,
                                                listStyle = 3,
                                                goodsCoverProportion = "1-1",
                                                fill = 1,
                                                goodsStyle = 1,
                                                textStyle = 1,
                                                showGoodsName = true,
                                                showGoodsPrice = true,
                                                showBuyBtn = true,
                                                buyBtn = "cart",
                                                buyBtnStyle = 1,
                                                buyBtnText = "购买",
                                                buttonColor = "#ff4544",
                                                showGoodsTag = false,
                                                customizeGoodsTag = false,
                                                goodsTagPicUrl = "",
                                                showImg = false,
                                                backgroundColor = "#fff",
                                                backgroundPicUrl = "",
                                                position = 5,
                                                mode = 1,
                                                backgroundHeight = 100,
                                                backgroundWidth = 100,
                                                list = new List<GoodsDetailsItem2>(),
                                                catList = new List<catItem>() { cats }
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //图片魔方
                                    case "block":
                                        var blockSource = programModule.GetMallMagicListModule(new Model.Entity.User.RB_Mall_Magic_Extend()
                                        {
                                            MallBaseId = miniProgram.MallBaseId,
                                            TenantId = Convert.ToInt32(miniProgram.TenantId),
                                            Id = subitem.relation_id
                                        }).FirstOrDefault();
                                        if (blockSource != null && blockSource.Id > 0)
                                        {
                                            var rubikData = new rubikItem()
                                            {
                                                style = Convert.ToInt32(blockSource.Style),
                                                space = 0,
                                                list = new List<rubikDetailItem>(),
                                            };
                                            switch (rubikData.style)
                                            {
                                                //1张图
                                                case 0:
                                                    rubikData.height = "360";
                                                    rubikData.w = "1";
                                                    rubikData.h = 1;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 0,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        },
                                                        width = "calc(100%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //两张图
                                                case 1:
                                                    rubikData.height = "360";
                                                    rubikData.w = "25";
                                                    rubikData.h = 12;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 10,
                                                        h = 12,
                                                        x = 0,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        },
                                                        width = "calc(40%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 12,
                                                        x = 10,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        },
                                                        width = "calc(60%)",
                                                        height = "calc(100%)",
                                                        left = "calc(40%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //三张图
                                                case 2:
                                                    rubikData.height = "360";
                                                    rubikData.w = "25";
                                                    rubikData.h = 12;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 10,
                                                        h = 12,
                                                        x = 0,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        },
                                                        width = "calc(40%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 6,
                                                        x = 10,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        },
                                                        width = "calc(60%)",
                                                        height = "calc(50%)",
                                                        left = "calc(40%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 6,
                                                        x = 10,
                                                        y = 6,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        },
                                                        width = "calc(60%)",
                                                        height = "calc(50%)",
                                                        left = "calc(40%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //四张图
                                                case 3:
                                                    rubikData.height = "360";
                                                    rubikData.w = "50";
                                                    rubikData.h = 24;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 20,
                                                        h = 24,
                                                        x = 0,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        },
                                                        width = "calc(40%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 30,
                                                        h = 12,
                                                        x = 20,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        },
                                                        width = "calc(60%)",
                                                        height = "calc(50%)",
                                                        left = "calc(40%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 12,
                                                        x = 20,
                                                        y = 12,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        },
                                                        width = "calc(30%)",
                                                        height = "calc(50%)",
                                                        left = "calc(40%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 12,
                                                        x = 35,
                                                        y = 12,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[3].Link
                                                        },
                                                        width = "calc(30%)",
                                                        height = "calc(50%)",
                                                        left = "calc(70%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[3].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //两张平分图
                                                case 4:
                                                    rubikData.height = "240";
                                                    rubikData.w = "50";
                                                    rubikData.h = 16;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 16,
                                                        x = 0,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 16,
                                                        x = 25,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //三张平分图
                                                case 5:
                                                    rubikData.height = "240";
                                                    rubikData.w = "75";
                                                    rubikData.h = 24;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 24,
                                                        x = 0,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        },
                                                        width = "calc(33.33%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 24,
                                                        x = 25,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        },
                                                        width = "calc(33.33%)",
                                                        height = "calc(100%)",
                                                        left = "calc(33.33%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 24,
                                                        x = 50,
                                                        y = 6,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        },
                                                        width = "calc(33.34%)",
                                                        height = "calc(100%)",
                                                        left = "calc(66.66%)",
                                                        top = "calc(0%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;

                                                //四张平分
                                                case 6:
                                                    rubikData.height = "186";
                                                    rubikData.w = "4";
                                                    rubikData.h = 1;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 0,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        },
                                                        width = "calc(25%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 1,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        },
                                                        width = "calc(25%)",
                                                        height = "calc(100%)",
                                                        left = "calc(25%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 2,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        },
                                                        width = "calc(25%)",
                                                        height = "calc(100%)",
                                                        left = "calc(50%)",
                                                        top = "calc(0%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 3,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[3].Link
                                                        },
                                                        width = "calc(25%)",
                                                        height = "calc(100%)",
                                                        left = "calc(75%)",
                                                        top = "calc(0%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[3].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //四张上下平分
                                                case 7:
                                                    rubikData.height = "372";
                                                    rubikData.w = "250";
                                                    rubikData.h = 124;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 125,
                                                        h = 62,
                                                        x = 0,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(50%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 125,
                                                        h = 62,
                                                        x = 125,
                                                        y = 0,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(50%)",
                                                        left = "calc(50%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 125,
                                                        h = 62,
                                                        x = 0,
                                                        y = 62,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(50%)",
                                                        left = "calc(0%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 125,
                                                        h = 62,
                                                        x = 125,
                                                        y = 62,
                                                        link = new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[3].Link
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(50%)",
                                                        left = "calc(50%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[3].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                            }
                                            templateData.data.Add(new
                                            {
                                                id = "rubik",
                                                data = rubikData
                                            });
                                            templateData.data.Add(new
                                            {
                                                id = "empty",
                                                data = new emptyItem()
                                                {
                                                    background = "#ffffff",
                                                    height = 10
                                                }
                                            });
                                        }
                                        break;
                                }
                            }
                            var tempObj = new
                            {
                                id = miniProgram.MallBaseId,
                                name = "自定义首页布局",
                                page_id = miniProgram.MallBaseId,
                                template_id = miniProgram.MallBaseId,
                                template = templateData
                            };
                            list.Add(tempObj);
                            homePage = new
                            {
                                id = 0,
                                title = miniProgram.MallName,
                                show_navs = 0,
                                is_home_page = 0,
                                navs = list
                            };
                        }
                        //未配置自定义页面
                        else
                        {
                            homePage = new
                            {
                                id = miniProgram.MallBaseId,
                                title = miniProgram.MallName,
                                show_navs = 1,
                                is_home_page = 1,
                                navs = list
                            };
                        }
                    }
                }
            }
            var objResult = new 
            {
                home_pages = homePage
            };
            return ApiResult.Success(data: objResult);
        }



        /// <summary>
        /// 解析插件数据为对象
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
        public object PlusDataToObject(ComponentItem subItem, int TenantId,int MallBaseId)
        {
            var obj = new object();
            switch (subItem.Id)
            {
                //背景插件
                case "background":
                    var backgroundData = subItem.data as backgroundItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = backgroundData
                    };
                    break;
                //搜索插件
                case "search":
                    var searchData = subItem.data as searchItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = searchData
                    };
                    break;
                //导航组件
                case "nav":
                    var navData = subItem.data as navItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = navData
                    };
                    break;
                //轮播广告插件
                case "banner":
                    var bannerData = subItem.data as bannerItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bannerData
                    };
                    break;
                //公告组件
                case "notice":
                    var noticeData = subItem.data as noticeItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = noticeData
                    };
                    break;
                //专题组件
                case "topic":
                    var topicData = subItem.data as topicItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = topicData
                    };
                    break;
                //标题组件
                case "link":
                    var linkData = subItem.data as linkItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = linkData
                    };
                    break;
                //图片广告插件
                case "rubik":
                    var rubikData = subItem.data as rubikItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = rubikData
                    };
                    break;
                //视频插件
                case "video":
                    var videoData = subItem.data as videoItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = videoData
                    };
                    break;
                //商品插件
                case "goods":
                    var goodsData = subItem.data as goodsItem;
                    if (goodsData != null)
                    {
                        //显示商品分类
                        if (goodsData.showCat)
                        {
                            if (goodsData.catList != null && goodsData.catList.Count > 0)
                            {
                                foreach (var childItem in goodsData.catList)
                                {
                                    //自定义商品
                                    if (childItem.staticGoods)
                                    {
                                        if (childItem.goodsList != null && childItem.goodsList.Count > 0)
                                        {
                                            var Ids = "0," + string.Join(",", childItem.goodsList.Select(qitem => qitem.id));
                                            var tempGoodsList = productModule.GetProductGoodsList(new Model.Extend.Product.RB_Goods_Extend()
                                            {
                                                TenantId = TenantId,
                                                MallBaseId = MallBaseId,
                                                GoodsIds = Ids
                                            });
                                            foreach (var lastItem in childItem.goodsList)
                                            {
                                                var tempGood = tempGoodsList?.Where(qitem => qitem.Id == lastItem.id)?.FirstOrDefault();
                                                if (tempGood != null && tempGood.Id > 0)
                                                {
                                                    lastItem.name = tempGood?.Name ?? lastItem.name;
                                                    lastItem.price = tempGood?.SellingPrice ?? lastItem.price;
                                                    lastItem.picUrl = tempGood?.CoverImage != null ? Common.Config.GetFileUrl(tempGood.CoverImage) : Common.Config.GetFileUrl(lastItem.picUrl);
                                                }
                                            }
                                        }
                                    }
                                    //自动添加商品
                                    else
                                    {
                                        childItem.goodsList = new List<GoodsDetailsItem2>();
                                        var catGoodsList = productModule.GetProductGoodsPageList(1, childItem.goodsNum, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                        {
                                            TenantId = TenantId,
                                            MallBaseId = MallBaseId,
                                            CategoryIds = childItem.id.ToString()
                                        });
                                        if (catGoodsList != null && catGoodsList.Count > 0)
                                        {
                                            foreach (var gItem in catGoodsList)
                                            {
                                                childItem.goodsList.Add(new GoodsDetailsItem2()
                                                {
                                                    id = gItem.Id,
                                                    price = gItem?.SellingPrice ?? 0,
                                                    name = gItem.Name,
                                                    picUrl = Common.Config.GetFileUrl(gItem.CoverImage)
                                                });
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        //不显示商品分类
                        else
                        {
                            //自动添加商品
                            if (goodsData.addGoodsType == 0)
                            {
                                goodsData.list = new List<GoodsDetailsItem2>();
                                var goodsList = productModule.GetProductGoodsPageList(1, goodsData.goodsLength, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                {
                                    TenantId = TenantId,
                                    MallBaseId = MallBaseId
                                });
                                if (goodsList != null && goodsList.Count > 0)
                                {
                                    foreach (var gItem in goodsList)
                                    {
                                        goodsData.list.Add(new GoodsDetailsItem2()
                                        {
                                            id = gItem.Id,
                                            price = gItem?.SellingPrice ?? 0,
                                            name = gItem.Name,
                                            picUrl = Common.Config.GetFileUrl(gItem.CoverImage)
                                        });
                                    }
                                }
                            }
                            //手动添加商品
                            else
                            {
                                if (goodsData.list != null && goodsData.list.Count > 0)
                                {
                                    var Ids = "0," + string.Join(",", goodsData.list.Select(qitem => qitem.id));
                                    var tempGoodsList = productModule.GetProductGoodsList(new Model.Extend.Product.RB_Goods_Extend()
                                    {
                                        TenantId = TenantId,
                                        MallBaseId = MallBaseId,
                                        GoodsIds = Ids
                                    });
                                    foreach (var childItem in goodsData.list)
                                    {
                                        var tempGood = tempGoodsList?.Where(qitem => qitem.Id == childItem.id)?.FirstOrDefault();
                                        if (tempGood != null && tempGood.Id > 0)
                                        {
                                            childItem.name = tempGood?.Name ?? childItem.name;
                                            childItem.price = tempGood?.SellingPrice ?? childItem.price;
                                            childItem.picUrl = tempGood?.CoverImage != null ? Common.Config.GetFileUrl(tempGood.CoverImage) : Common.Config.GetFileUrl(childItem.picUrl);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = goodsData
                    };
                    break;
                //门店插件
                case "store":
                    var storeData = subItem.data as storeItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = storeData
                    };
                    break;
                //版权插件
                case "copyright":
                    var copyrightData = subItem.data as copyrightItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = copyrightData
                    };
                    break;
                //签到插件
                case "check-in":
                    var checkinData = subItem.data as checkinItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = checkinData
                    };
                    break;
                //用户信息插件
                case "user-info":
                    var userinfoData = subItem.data as userinfoItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = userinfoData
                    };
                    break;
                //用户订单插件
                case "user-order":
                    var userorderData = subItem.data as userorderItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = userorderData
                    };
                    break;
                //地图插件
                case "map":
                    var mapData = subItem.data as mapItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = mapData
                    };
                    break;
                //微信公众号插件
                case "mp-link":
                    var mplinkData = subItem.data as mplinkItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = mplinkData
                    };
                    break;
                //图文插件
                case "image-text":
                    var imagetextData = subItem.data as imagetextItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = imagetextData
                    };
                    break;
                //优惠券插件
                case "coupon":
                    var couponData = subItem.data as couponItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = couponData
                    };
                    break;
                //倒计时插件
                case "timer":
                    var timerData = subItem.data as timerItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = timerData
                    };
                    break;
                //拼团插件
                case "pintuan":
                    var pintuanData = subItem.data as pintuanItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = pintuanData
                    };
                    break;
                //预约插件
                case "booking":
                    var bookingData = subItem.data as bookingItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bookingData
                    };
                    break;
                //砍价插件
                case "bargain":
                    var bargainData = subItem.data as bargainItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bargainData
                    };
                    break;
                //积分商城插件
                case "integral-mall":
                    var integralmallData = subItem.data as integralmallItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = integralmallData
                    };
                    break;
                //抽奖插件
                case "lottery":
                    var lotteryData = subItem.data as lotteryItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = lotteryData
                    };
                    break;

                //预售
                case "advance":
                    var advanceData = subItem.data as advanceItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = advanceData
                    };
                    break;

                //超级会员卡
                case "vip-card":
                    var vipcardData = subItem.data as vipcardItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = vipcardData
                    };
                    break;
                //直播组件
                case "live":
                    var liveData = subItem.data as liveItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = liveData
                    };
                    break;


                //空组件
                case "empty":
                    var emptyData = subItem.data as emptyItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = emptyData
                    };
                    break;

                //流量主广告
                case "ad":
                    var adData = subItem.data as adItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = adData
                    };
                    break;

                //弹窗广告
                case "modal":
                    var modalData = subItem.data as modalItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = modalData
                    };
                    break;

                //弹窗广告
                case "quick-nav":
                    var quicknavData = subItem.data as quicknavItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = quicknavData
                    };
                    break;
            }
            return obj;
        }


        /// <summary>
        /// 用户中心
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetUserCenter()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            //小程序Id
            var MiniAppId = parms.GetStringValue("MiniAppId");
            //获取小程序信息
            var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetUserCenterMenu: true);
            var mall = new object();
            if (miniProgram != null && miniProgram.MallBaseId > 0)
            {
                var config = new
                {
                    //顶部导航
                    title_bar = new
                    {
                        //顶部背景颜色
                        background = miniProgram.TopNavBgColor,
                        //顶部文字颜色
                        color = miniProgram.TopNavWordColor,
                    },
                    //用户中心
                    user_center = new
                    {
                        //是否显示账户栏
                        is_account_status = (miniProgram.IsShowAccountNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_menu_status = (miniProgram.IsShowMenuNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_order_bar_status = (miniProgram.IsShowOrderNav == 0 ? 1 : 0),
                        //是否显示收藏夹
                        is_foot_bar_status = (miniProgram.IsShowFavorite == 0 ? 1 : 0),
                        //菜单样式
                        menu_style = (miniProgram.MenuNavStyle == 0 ? 1 : 2),
                        //头像样式
                        top_style = (miniProgram.HeadStyle),
                        //顶部默认背景图
                        top_pic_url = miniProgram.DefaultBgImg,
                        //普通用户背景图
                        member_pic_url = miniProgram.MemberBgImg,
                        //会员中心背景图
                        member_bg_pic_url = miniProgram.VipBgImg,
                        //头像内嵌背景图[暂无]
                        style_bg_pic_url = "",

                        //账户相关菜单
                        account = miniProgram?.AccountMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            is_show = 1,
                        }),
                        //自定义菜单
                        menus = miniProgram?.SelfMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl,
                            open_type = "navigate",
                            @params = "",

                        }),
                        //订单菜单列表
                        order_bar = miniProgram?.OrderMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl,
                            open_type = "navigate",
                            text = "",
                        }),
                        //收藏足迹
                        foot_bar = miniProgram?.FavoriteFootMenuList.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl,
                            open_type = "navigate",
                        }),
                        //版权设置
                        copyright = new
                        {
                            pic_url = miniProgram.CopyRightImg,
                            description = miniProgram.CopyRightWord,
                            link_url = miniProgram.CopyRightLink,
                        }
                    }
                };
                mall = new
                {
                    id = miniProgram.MallBaseId,
                    name = miniProgram.MallName,
                    //配置信息
                    config
                };
            }
            return ApiResult.Success(data: mall);
        }
    }
}