﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using Mall.Common.API;
using Mall.Common.Pay.WeChatPat;
using Mall.Common.Plugin;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.AppletWeChat
{

   
    public class WeChatNotifyController : Controller
    {
        private static object _lock = new object();



        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string Notify()
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.Notify();
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //订单No：dic["sOrderNo"]
                //支付金额：dic["dPrice"]
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];
                    sOrderNo = sOrderNo.Substring(17, 5);
                    // var model = new REBORN.Module.SellModule.CounponOrderModule().GetEntity(Convert.ToInt32(sOrderNo));//获取订单信息

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sTradeNo = dic["sTradeNo"];
                    string sPayerOpenID = dic["sPayerOpenID"];


                     //处理订单信息2020-05-26   逻辑还未处理
                    #region 处理订单信息
                    //if (model.PreferPrice == dPaid)
                    //{

                    //    model.PayType = dic["OrderPayType"].Equals("JSAPI", StringComparison.CurrentCultureIgnoreCase) ? 1 : 2;
                    //    model.sTradeNo = sTradeNo;
                    //    model.sPayerOpenID = sPayerOpenID;
                    //    model.Income = dPaid;
                    //    //查询订单信息
                    //    try
                    //    {

                    //    }
                    //    catch (Exception ex)
                    //    {
                    //        Common.Plugin.LogHelper.Write(ex, string.Format("Notify:infoError"));
                    //    }

                    //    req.SetParameter("return_code", "SUCCESS");
                    //    req.SetParameter("return_msg", "OK");
                    //}
                    //else
                    //{
                    //    req.SetParameter("return_code", "FAIL");
                    //    req.SetParameter("return_msg", "支付金额与订单金额不等");
                    //}
                    #endregion

                }
                var reqXml = req.ParseXml();
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                return reqXml;
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
            }
            //  return ApiResult.Failed();
            //告诉微信我们处理失败，请继续调用我们的接口。好像是会重试8次。

        }
    }
}