﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品订单明细表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderDetail_Extend : RB_Goods_OrderDetail
    {
        /// <summary>
        /// 会员优惠
        /// </summary>
        public object Discounts { get; set; }
        /// <summary>
        /// 属性列表
        /// </summary>
        public object Attr_list { get; set; }
        /// <summary>
        /// 快递费用
        /// </summary>
        public decimal? Express { get; set; }
        /// <summary>
        /// 重量
        /// </summary>
        public int? GoodsWeight { get; set; }
        /// <summary>
        /// 订单ids
        /// </summary>
        public string OrderIds { get; set; }
        /// <summary>
        /// 图片地址
        /// </summary>
        public string CoverImagePath { get; set; }
        /// <summary>
        /// 明细ids
        /// </summary>
        public string OrderDetailIds { get; set; }
        /// <summary>
        /// 是否已发货
        /// </summary>
        public int? IsBindExpress { get; set; }
        /// <summary>
        /// 商品分类ids
        /// </summary>
        public List<int> CategoryIdList { get; set; }
        /// <summary>
        /// 剩余库存
        /// </summary>
        public int InventoryNum { get; set; }
        /// <summary>
        /// 规格价格列表id
        /// </summary>
        public int SpeciPriceId { get; set; }
        /// <summary>
        /// 是否开启单独返佣  1是  2否
        /// </summary>
        public int? SeparateDistribution { get; set; }
        /// <summary>
        /// 分销类型 1普通  2详细
        /// </summary>
        public int? SeparateDistributionType { get; set; }
        /// <summary>
        /// 分销佣金类型  1百分比  2固定值
        /// </summary>
        public int? SeparateDistributionMoneyType { get; set; }

        /// <summary>
        /// 规格列表
        /// </summary>
        public List<string> SpecificationList { get; set; }
        /// <summary>
        /// 是否申请售后
        /// </summary>
        public int? IsApplyForAfterSale { get; set; }


        /// <summary>
        /// 积分赠送
        /// </summary>        
        public int? IntegralPresent
        {
            get;
            set;
        }
        /// <summary>
        /// 赠送类型  2固定值  1百分比
        /// </summary>        
        public int? IntegralPresentType
        {
            get;
            set;
        }

        #region 自动生成收入单据新增字段

        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }


        /// <summary>
        /// 1-商品，2-运费
        /// </summary>
        public int FinanceType { get; set; }
        #endregion
        #region 供应商商品信息
        public string StartTime { get; set; }

        public string EndTime { get; set; }


        /// <summary>
        /// 是否制单
        /// </summary>
        public int IsFinance { get; set; }


        /// <summary>
        /// 订单商品ids
        /// </summary>
        public List<int> IdList { get; set; }
        #endregion

    }
}
