﻿using Mall.Common.AOP;
using Mall.Model.Entity.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.MarketingCenter
{
    /// <summary>
    /// 优惠券扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_DiscountCoupon_Extend : RB_DiscountCoupon
    {
        /// <summary>
        /// 商品/分类id
        /// </summary>
        public List<RB_DiscountCoupon_Product_Extend> ProductList { get; set; }

        /// <summary>
        /// 发放优惠券的时候会员ids
        /// </summary>
        public string UserIds { get; set; }

        /// <summary>
        /// 0-未领取 >0已领取
        /// </summary>
        public int MemberNum { get; set; }

        /// <summary>
        /// 发放数量
        /// </summary>
        public int GrantNum { get; set; }

        /// <summary>
        /// 触发事件，1-分享，2-购买并付款，3-新人领券
        /// </summary>
        public int TriggerType { get; set; }
        /// <summary>
        /// 优惠卷ids
        /// </summary>
        public string CouponIds { get; set; }

        /// <summary>
        /// 会员等级
        /// </summary>
        public int[] MemberLevelList { get; set; }




        /// <summary>
        /// 发放优惠券的时候会员id
        /// </summary>
        public int UserId { get; set; }


        /// <summary>
        /// 使用状态 0-未使用，1:已使用，2:已过期
        /// </summary>
        public int UseState { get; set; }



        /// <summary>
        /// 会员优惠券id
        /// </summary>
        public int MemberCouponId { get; set; }

        /// <summary>
        /// 商品
        /// </summary>
        public int[] GoodsIds { get; set; }

        /// <summary>
        /// 分类
        /// </summary>
        public int[] CategoryIds { get; set; }


        /// <summary>
        /// 领劵中心领取
        /// </summary>
        public int GetType { get; set; }
    }
}
