﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 财务生成记录表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Finance_Record
    {

        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }
        /// <summary>
        /// 类型  1收款  2成本  3退款   4打款
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }


        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }


        /// <summary>
        /// 财务id
        /// </summary>        
        public int FinanceId
        {
            get;
            set;
        }


        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }



        /// <summary>
        /// 是否是成本与运费一起制单，0-全部，1-成本，2-运费
        /// </summary>
        public int IsFinanceAll { get; set; }
    }
}
