﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 分销海报实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiniProgram_FenXiaoPoster
    {
        /// <summary>
        /// 主键编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 商户Id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序Id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 海报背景图
        /// </summary>
        public string PosterBgImg { get; set; }

        /// <summary>
        /// 是否显示头像(0-显示，1-不显示)
        /// </summary>
        public int IsShowHead { get; set; }

        /// <summary>
        /// 头像大小
        /// </summary>
        public int HeadSize { get; set; }

        /// <summary>
        /// 头像上间距
        /// </summary>
        public int HeadPaddingTop { get; set; }

        /// <summary>
        /// 头像左间距
        /// </summary>
        public int HeadPaddingLeft { get; set; }

        /// <summary>
        /// 是否显示昵称(0-显示,1-不显示)
        /// </summary>
        public int IsShowNick { get; set; }

        /// <summary>
        /// 昵称大小
        /// </summary>
        public int NickSize { get; set; }

        /// <summary>
        /// 昵称上间距
        /// </summary>
        public int NickPaddingTop { get; set; }

        /// <summary>
        /// 昵称左间距
        /// </summary>
        public int NickPaddingLeft { get; set; }

        /// <summary>
        /// 昵称颜色
        /// </summary>
        public string NickColor { get; set; }

        /// <summary>
        /// 是否显示二维码(0-显示,1-不显示)
        /// </summary>
        public int IsShowQrCode { get; set; }

        /// <summary>
        /// 二维码大小
        /// </summary>
        public int QrCodeSize { get; set; }

        /// <summary>
        /// 二维码上间距
        /// </summary>
        public int QrCodePaddingTop { get; set; }

        /// <summary>
        /// 二维码上间距
        /// </summary>
        public int QrCodePaddingLeft { get; set; }

        /// <summary>
        /// 二维码形状(0-圆形，1-方形)
        /// </summary>
        public int QrCodeType { get; set; }

        /// <summary>
        /// 是否开启校园版(1-开启)    2(相亲帖子海报)
        /// </summary>
        public int IsOpenSchool { get; set; }

        /// <summary>
        /// 是否显示封面图 (0-显示,1-不显示)
        /// </summary>
        public int IsShowCover { get; set; }
        /// <summary>
        /// 封面图高度
        /// </summary>
        public int CoverHeight { get; set; }
        /// <summary>
        /// 封面图宽度 (等于-1 全屏)
        /// </summary>
        public int CoverWidth { get; set; }
        /// <summary>
        /// 封面图上边距
        /// </summary>
        public int CoverPaddingTop { get; set; }
        /// <summary>
        /// 封面图左边距
        /// </summary>
        public int CoverPaddingLeft { get; set; }
        /// <summary>
        /// 是否显示标题(0-显示,1-不显示)
        /// </summary>
        public int IsShowTitle { get; set; }
        /// <summary>
        /// 标题大小
        /// </summary>
        public int TitleSize { get; set; }
        /// <summary>
        /// 标题颜色
        /// </summary>
        public int TitleColor { get; set; }
        /// <summary>
        /// 标题上边距
        /// </summary>
        public int TitlePaddingTop { get; set; }
        /// <summary>
        /// 标题左边距
        /// </summary>
        public int TitlePaddingLeft { get; set; }
        /// <summary>
        /// 标题行数
        /// </summary>
        public int TitleRow { get; set; }
    }
}
