﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using Newtonsoft.Json;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    public class CarrierModule
    {
        /// <summary>
        /// 载体信息仓储层对象
        /// </summary>
        private readonly RB_CarrierRepository carrierRepository = new RB_CarrierRepository();
        /// <summary>
        /// 载体地铁信息仓储层对象
        /// </summary>
        private readonly RB_CarrierMetroRepository carrierMetroRepository = new RB_CarrierMetroRepository();
        /// <summary>
        /// 载体信息仓储层对象
        /// </summary>
        private readonly RB_BrandRepository brandRepository = new RB_BrandRepository();
        /// <summary>
        /// 公司信息仓储层对象
        /// </summary>
        private readonly RB_CompanyRepository companyRepository = new RB_CompanyRepository();

        #region 载体
        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Carrier_Extend> GetCarrierPageList(int pageIndex, int pageSize, out long rowCount, RB_Carrier_Extend query)
        {
            var list = carrierRepository.GetCarrierPageList(pageIndex, pageSize, out rowCount, query);
            if (list != null && list.Any())
            {
                string carrierIds = string.Join(",", list.Select(x => x.ID));
                if (!string.IsNullOrWhiteSpace(carrierIds))
                {
                    var metroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CarrierIds = carrierIds });
                    if (metroList != null && metroList.Any())
                    {
                        foreach (var item in list)
                        {
                            item.CarrierMetroList = new List<RB_CarrierMetro_Extend>();
                            item.CarrierMetroList = metroList.Where(x => x.CarrierId == item.ID).ToList();
                        }
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Carrier_Extend> GetCarrierList(RB_Carrier_Extend query)
        {
            var list = carrierRepository.GetCarrierList(query);
            if (list != null && list.Any())
            {
                string carrierIds = string.Join(",", list.Select(x => x.ID));
                if (!string.IsNullOrWhiteSpace(carrierIds))
                {
                    var metroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CarrierIds = carrierIds });
                    if (metroList != null && metroList.Any())
                    {
                        foreach (var item in list)
                        {
                            if (!string.IsNullOrWhiteSpace(item.Banner))
                            {
                                item.BannerList = JsonConvert.DeserializeObject<List<string>>(item.Banner);
                            }
                            item.CarrierMetroList = new List<RB_CarrierMetro_Extend>();
                            item.CarrierMetroList = metroList.Where(x => x.CarrierId == item.ID).ToList();
                        }
                    }
                }
            }
            return list;
        }



        /// <summary>
        /// 载体信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_Carrier_Extend GetCarrierModel(RB_Carrier_Extend query)
        {
            var model = carrierRepository.GetCarrierList(query).FirstOrDefault();
            if (model != null && model.ID > 0)
            {
                var metroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = query.TenantId, MallBaseId = query.MallBaseId, CarrierId = model.ID });
                if (metroList != null && metroList.Any())
                {
                    if (!string.IsNullOrWhiteSpace(model.Banner))
                    {
                        model.BannerList = JsonConvert.DeserializeObject<List<string>>(model.Banner);
                    }
                    model.CarrierMetroList = new List<RB_CarrierMetro_Extend>();
                    model.CarrierMetroList = metroList;
                }
            }
            return model;
        }

        /// <summary>
        /// 新增/修改载体
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCarrier(RB_Carrier_Extend model)
        {
            bool flag = false;
            int Id = 0;
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Carrier_Extend.CarrierName),model.CarrierName },
                    {nameof(RB_Carrier_Extend.Logo),model.Logo },
                    {nameof(RB_Carrier_Extend.Banner),model.Banner },
                    {nameof(RB_Carrier_Extend.VideoUrl),model.VideoUrl },
                    {nameof(RB_Carrier_Extend.Address),model.Address },
                    {nameof(RB_Carrier_Extend.LatAndLon),model.LatAndLon },
                    {nameof(RB_Carrier_Extend.Developers),model.Developers },
                    {nameof(RB_Carrier_Extend.OpenTime),model.OpenTime },
                    {nameof(RB_Carrier_Extend.CarrierSize),model.CarrierSize },
                    {nameof(RB_Carrier_Extend.ProjectType),(int)model.ProjectType },
                    {nameof(RB_Carrier_Extend.LayersNum),model.LayersNum },
                    {nameof(RB_Carrier_Extend.CarNum),model.CarNum },
                    {nameof(RB_Carrier_Extend.CarrierPlan),model.CarrierPlan },
                    {nameof(RB_Carrier_Extend.CarrierTarget),model.CarrierTarget },
                    {nameof(RB_Carrier_Extend.Location),model.Location },
                    {nameof(RB_Carrier_Extend.Crowd),model.Crowd }

                };
                flag = carrierRepository.Update(fileds, new WhereHelper(nameof(RB_Carrier_Extend.ID), model.ID));
                if (flag)
                {
                    var oldCarrierMetroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = model.TenantId, MallBaseId = model.MallBaseId, CarrierId = model.ID });
                    carrierMetroRepository.DeleteBatch(oldCarrierMetroList);
                    model.CarrierMetroList.ForEach(x => x.CarrierId = Id);
                    model.CarrierMetroList.ForEach(x => x.Status = 0);
                    model.CarrierMetroList.ForEach(x => x.TenantId = model.TenantId);
                    model.CarrierMetroList.ForEach(x => x.MallBaseId = model.MallBaseId);
                    carrierMetroRepository.InsertBatch(model.CarrierMetroList);
                    Id = model.ID;
                }
            }
            else
            {
                Id = carrierRepository.Insert(model);
                if (Id > 0)
                {
                    model.CarrierMetroList.ForEach(x => x.CarrierId = Id);
                    model.CarrierMetroList.ForEach(x => x.Status = 0);
                    model.CarrierMetroList.ForEach(x => x.TenantId = model.TenantId);
                    model.CarrierMetroList.ForEach(x => x.MallBaseId = model.MallBaseId);
                    carrierMetroRepository.InsertBatch(model.CarrierMetroList);
                }
                flag = Id > 0;
            }

            return flag;
        }


        /// <summary>
        ///删除载体信息状态
        /// </summary>
        /// <param name="CompanyId"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCarrierModule(int CarrierId, int TenantId, int MallBaseId, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Carrier_Extend.Status),Status },
            };
            bool flag = carrierRepository.Update(fileds, new WhereHelper(nameof(RB_Carrier_Extend.ID), CarrierId));
            if (flag)
            {
                var oldCarrierMetroList = carrierMetroRepository.GetCarrierMetroList(new RB_CarrierMetro_Extend { TenantId = TenantId, MallBaseId = MallBaseId, CarrierId = CarrierId });
                if (oldCarrierMetroList != null && oldCarrierMetroList.Any())
                {
                    oldCarrierMetroList.ForEach(x => x.Status = Common.Enum.DateStateEnum.Delete);
                    carrierMetroRepository.UpdateBatch(oldCarrierMetroList);
                }
            }
            return flag;
        }



        #endregion


        #region 品牌

        /// <summary>
        /// 获取品牌信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Extend> GetBrandPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Brand_Extend query)
        {
            return brandRepository.GetBrandPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 根据查询条件获取品牌信息实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Brand_Extend GetBrandRepository(RB_Brand_Extend query)
        {
            return brandRepository.GetBrandRepository(query);
        }

        /// <summary>
        /// 新增修改品牌
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetBrand(RB_Brand_Extend model)
        {
            if (model.ID == 0)
            {
                return brandRepository.Insert(model) > 0;
            }
            else
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Brand_Extend.BrandName),model.BrandName },
                    {nameof(RB_Brand_Extend.ShopNum),model.ShopNum },
                    {nameof(RB_Brand_Extend.BuiltUpArea),model.BuiltUpArea },
                    {nameof(RB_Brand_Extend.EndBuiltUpArea),model.EndBuiltUpArea },
                    {nameof(RB_Brand_Extend.FullBrandName),model.FullBrandName },
                    {nameof(RB_Brand_Extend.CustomerType),model.CustomerType },
                    {nameof(RB_Brand_Extend.CustomerOtherType),model.CustomerOtherType },
                    {nameof(RB_Brand_Extend.StoreExpansion),model.StoreExpansion },
                    {nameof(RB_Brand_Extend.ProjectType),(int)model.ProjectType },
                    {nameof(RB_Brand_Extend.AreaRequirement),model.AreaRequirement },
                    {nameof(RB_Brand_Extend.EndAreaRequirement),model.EndAreaRequirement }
                };
                return brandRepository.Update(fileds, new WhereHelper(nameof(RB_Brand_Extend.ID), model.ID));
            }
        }


        #endregion
    }
}
