﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.MiAi;
using VT.FW.DB;

namespace Mall.Model.Entity.Miai
{
    /// <summary>
    /// 相亲会员基础资料
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiAi_BaseInfo
    {
        /// <summary>
        /// 编号
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 真实姓名
        /// </summary>
        public string RealName { get; set; }


        /// <summary>
        /// 微信号
        /// </summary>
        public string WechatNo { get; set; }
        /// <summary>
        /// 会员id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 身份证正面
        /// </summary>
        public string IDCard { get; set; }

        /// <summary>
        /// 身份证背面
        /// </summary>
        public string IDCardBack { get; set; }
        public string IDCardNo { get; set; }


        /// <summary>
        /// 活动区域
        /// </summary>
        public string ActivityRegion { get; set; }

        /// <summary>
        /// 性别1-男，2-女
        /// </summary>
        public int Sex { get; set; }


        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }
        /// <summary>
        /// 身高
        /// </summary>
        public decimal Height { get; set; }
        /// <summary>
        /// 体重
        /// </summary>
        public decimal Weight { get; set; }
        /// <summary>
        /// 学历
        /// </summary>
        public EducationTypeEnum? EducationType { get; set; }
        /// <summary>
        /// 毕业院校
        /// </summary>
        public string SchoolInfo { get; set; }


        /// <summary>
        /// 婚姻
        /// </summary>
        public MarriageEnum? Marriage { get; set; }

        /// <summary>
        /// 职务
        /// </summary>
        public string Job { get; set; }

        /// <summary>
        /// 工作单位
        /// </summary>
        public string WorkUnit { get; set; }

        /// <summary>
        /// 年收入
        /// </summary>
        public decimal YearMoney { get; set; }


        /// <summary>
        /// 国家
        /// </summary>        
        public int? Country
        {
            get;
            set;
        }
        /// <summary>
        /// 省
        /// </summary>        
        public int? Province
        {
            get;
            set;
        }
        /// <summary>
        /// 市
        /// </summary>        
        public int? City
        {
            get;
            set;
        }
        /// <summary>
        /// 区
        /// </summary>        
        public int? District
        {
            get;
            set;
        }


        /// <summary>
        /// 定位省
        /// </summary>        
        public int? DWProvince
        {
            get;
            set;
        }
        /// <summary>
        /// 定位市
        /// </summary>        
        public int? DWCity
        {
            get;
            set;
        }
        /// <summary>
        /// 定位区
        /// </summary>        
        public int? DWDistrict
        {
            get;
            set;
        }



        /// <summary>
        /// 家庭背景
        /// </summary>
        public string FamilyInfo { get; set; }



        /// <summary>
        /// 业余爱好
        /// </summary>
        public string Hobby { get; set; }


        /// <summary>
        /// 喜欢的食物
        /// </summary>
        public string LikeFood { get; set; }


        /// <summary>
        /// 喜欢的书
        /// </summary>
        public string LikeBook { get; set; }

        /// <summary>
        /// 喜欢的电影和电视剧
        /// </summary>
        public string LikeTV { get; set; }


        /// <summary>
        /// 喜欢的情歌
        /// </summary>
        public string LikeSong { get; set; }
        /// <summary>
        /// 欣赏哪对名人的爱情，原因是什么
        /// </summary>
        public string IdealLove { get; set; }

        /// <summary>
        /// 情话
        /// </summary>
        public string LoveTalk { get; set; }
        /// <summary>
        /// 单身原因
        /// </summary>
        public string SingleReason { get; set; }


        /// <summary>
        /// 关于
        /// </summary>
        public string About { get; set; }

        /// <summary>
        /// 希望您是
        /// </summary>
        public string HopeYou { get; set; }


        /// <summary>
        /// 相册
        /// </summary>
        public string Album { get; set; }

        /// <summary>
        /// 约会时间
        /// </summary>
        public string Appointment { get; set; }

        /// <summary>
        /// 约会地点
        /// </summary>
        public string AppointmentAddress { get; set; }

        /// <summary>
        /// 车
        /// </summary>
        public CarInfoEnum? CarInfo { get; set; }

        /// <summary>
        /// 资产
        /// </summary>
        public string OtherInfo { get; set; }

        /// <summary>
        /// 房屋信息
        /// </summary>
        public HouseInfoEnum? HouseInfo { get; set; }
        /// <summary>
        /// 浏览数
        /// </summary>
        public int BrowseNum { get; set; }


        /// <summary>
        /// 关注数
        /// </summary>
        public int FollowNum { get; set; }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }


        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }

        public int IsFaTie { get; set; }
    }
}
