﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 活动奖品领取仓储层
    /// </summary>
    public class RB_Goods_Activity_GetRepository : BaseRepository<RB_Goods_Activity_Get>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Activity_Get_Extend> GetList(RB_Goods_Activity_Get_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Get_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Get_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Code))
            {
                where += $@" and {nameof(RB_Goods_Activity_Get_Extend.Code)} ='{dmodel.Code}'";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Get_Extend.ActivityId)}={dmodel.ActivityId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityIds))
            {
                where += $@" and {nameof(RB_Goods_Activity_Get_Extend.ActivityId)} in({dmodel.ActivityIds})";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Get_Extend.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserIds))
            {
                where += $@" and {nameof(RB_Goods_Activity_Get_Extend.UserId)} in({dmodel.UserIds})";
            }
            if (dmodel.State > 0)
            {
                where += $@" and {nameof(RB_Goods_Activity_Get_Extend.State)}={dmodel.State}";
            }

            string sql = $@"SELECT * FROM RB_Goods_Activity_Get where {where} order by Id asc";
            return Get<RB_Goods_Activity_Get_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Activity_Get_Extend> GetPageList(int pageIndex,int pageSize, out long count, RB_Goods_Activity_Get_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Activity_Get_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Activity_Get_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Code))
            {
                where += $@" and g.{nameof(RB_Goods_Activity_Get_Extend.Code)} ='{dmodel.Code}'";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Activity_Get_Extend.ActivityId)}={dmodel.ActivityId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ActivityName))
            {
                where += $@" and a.{nameof(RB_Goods_Activity_Extend.ActivityName)} like '%{dmodel.ActivityName}%'";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Activity_Get_Extend.UserId)}={dmodel.UserId}";
            }
            if (dmodel.State > 0)
            {
                if (dmodel.State == 3)
                {
                    where += $@" and (g.{nameof(RB_Goods_Activity_Get_Extend.State)} =3";
                    where += $@" or (g.{nameof(RB_Goods_Activity_Get_Extend.State)} =1 and a.{nameof(RB_Goods_Activity_Get_Extend.ReceiveTime)} <'{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'))";
                }
                else
                {
                    where += $@" and g.{nameof(RB_Goods_Activity_Get_Extend.State)}={dmodel.State}";
                }
            }

            string sql = $@"SELECT g.*,a.ActivityName,a.CoverImage,a.ReceiveTime,a.Way,a.PrizeName,a.PrizeImage,u.Name,u.Photo FROM RB_Goods_Activity_Get g
LEFT JOIN rb_goods_activity a on g.ActivityId = a.Id
LEFT JOIN rb_member_user u on g.UserId = u.Id
where {where} order by g.Id asc";
            return GetPage<RB_Goods_Activity_Get_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
