﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.CacheManager.User;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Enum.Goods;
using Mall.Common.Enum.TradePavilion;
using Mall.Common.Enum.User;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.TradePavilion
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletTradeController : BaseController
    {
        /// <summary>
        /// 投资采购处理类对象
        /// </summary>
        private readonly InvestmentProcurementModule procurementModule = new InvestmentProcurementModule();

        /// <summary>
        /// 公司信息处理类对象
        /// </summary>
        private readonly CompanyModule companyModule = new CompanyModule();

        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly Module.User.UserModule userModule = new Module.User.UserModule();

        /// <summary>
        /// 商会活动处理类对象
        /// </summary>
        private readonly CommerceActivityModule activityModule = new CommerceActivityModule();

        /// <summary>
        /// 商会活动报名处理类对象
        /// </summary>
        private readonly CommerceConsultModule consultModule = new CommerceConsultModule();

        /// <summary>
        /// 新闻处理类对象
        /// </summary>
        private readonly CommerceNewsModule commerceNewsModule = new CommerceNewsModule();

        /// <summary>
        /// Fat资料处理类对象
        /// </summary>
        private readonly CommerceAskModule askModule = new CommerceAskModule();

        /// <summary>
        /// 载体处理类对象
        /// </summary>
        private readonly CarrierModule carrierModule = new CarrierModule();

        /// <summary>
        /// 活动评论处理类对象
        /// </summary>
        private readonly CommerceCommentModule commerceCommentModule = new CommerceCommentModule();
        /// <summary>
        /// 认证对象
        /// </summary>
        private readonly AuthenticationModule authenticationModule = new AuthenticationModule();
        /// <summary>
        /// 小程序
        /// </summary>
        private readonly Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();
        /// <summary>
        /// 榜单
        /// </summary>
        private readonly FirstShopListModule firstShopListModule = new FirstShopListModule();
        /// <summary>
        /// 心愿单
        /// </summary>
        private readonly FirstShopWishModule firstShopWishModule = new FirstShopWishModule();



        #region 公司信息管理

        /// <summary>
        /// 新增修改公司信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Company_Extend()
            {
                CompanyId = parms.GetInt("CompanyId"),
                CompanyName = parms.GetStringValue("CompanyName"),
                BusinessLicense = parms.GetStringValue("BusinessLicense"),
                Mobile = parms.GetStringValue("Mobile"),
                UnifiedCode = parms.GetStringValue("UnifiedCode"),
                LegalPerson = parms.GetStringValue("LegalPerson"),
                FirstShopType = parms.GetInt("FirstShopType", 0)
            };
            if (string.IsNullOrWhiteSpace(extModel.BusinessLicense))
            {
                return ApiResult.Failed("请上传公司营业执照");
            }
            if (string.IsNullOrWhiteSpace(extModel.CompanyName))
            {
                return ApiResult.Failed("请输入企业名称");
            }
            if (string.IsNullOrWhiteSpace(extModel.UnifiedCode))
            {
                return ApiResult.Failed("请输入统一社会信用代码");
            }

            if (string.IsNullOrWhiteSpace(extModel.LegalPerson))
            {
                return ApiResult.Failed("请输入法人代表");
            }
            if (string.IsNullOrWhiteSpace(extModel.Mobile))
            {
                return ApiResult.Failed("请输入联系电话");
            }
            if (extModel.FirstShopType <= 0)
            {
                return ApiResult.Failed("请选择身份类型");
            }

            var userInfo = AppletUserInfo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = userInfo.MallBaseId;
            extModel.TenantId = userInfo.TenantId;
            Int32.TryParse(userInfo.UserId.ToString(), out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            extModel.CompanyStatus = 0;
            int ID = companyModule.SetCompanyModule(extModel);
            if (ID > 0)
            {
                //获取订阅消息
                var miniModel = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId });

                List<string> template_message_list = new List<string>();

                if (miniModel != null)
                {
                    if (!string.IsNullOrWhiteSpace(miniModel.HatchExamineTpl))
                    {
                        template_message_list.Add(miniModel.HatchExamineTpl);
                    }
                }
                return ApiResult.Success("", new { CompanyId = ID, template_message_list });
            }
            return ApiResult.Failed();

        }

        /// <summary>
        /// 获取当前用户的公司信息实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserCompany()
        {
            var userInfo = AppletUserInfo;
            var model = companyModule.GetCompanyByUserIdModule(userInfo.UserId);
            return ApiResult.Success(data: model);
        }

        /// <summary>
        /// 获取认证状态
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCommpanyStatus()
        {
            var userInfo = AppletUserInfo;
            var model = companyModule.GetCommpanyStatus(userInfo.UserId);
            return ApiResult.Success(data: model);
        }

        /// <summary>
        /// 新增/修改品牌申请信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetBrandApplyFor()
        {
            var userInfo = AppletUserInfo;
            RB_BrandApplyFor_Extend query = JsonConvert.DeserializeObject<RB_BrandApplyFor_Extend>(RequestParm.msg.ToString());
            if (query.CompanyId <= 0)
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            if (string.IsNullOrWhiteSpace(query.BrandName))
            {
                return ApiResult.Failed("请输入品牌名称");
            }
            if (string.IsNullOrWhiteSpace(query.Logo))
            {
                return ApiResult.Failed("请上传Logo");
            }
            if (query.BrandClassId == 0)
            {
                return ApiResult.Failed("请选择品牌分类");
            }
            if (query.BannerList != null && query.BannerList.Any())
            {
                query.Banner = JsonConvert.SerializeObject(query.BannerList);
            }
            else
            {
                query.Banner = "";
            }
            query.CreateDate = System.DateTime.Now;
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            query.Status = 0;
            query.UpdateDate = System.DateTime.Now;
            query.CreateBy = userInfo.UserId;
            query.UpdateBy = userInfo.UserId;

            #region 验证品牌名称是否已经存在了
            if (query.ExistBrandId == 0)
            {
                if (carrierModule.ValidateBrandName(query.BrandName, userInfo.MallBaseId))
                {
                    return ApiResult.Failed("该品牌名称已存在,请选择绑定已有品牌");
                }
                if (carrierModule.ValidateFullBrandName(query.FullBrandName, userInfo.MallBaseId))
                {
                    return ApiResult.Failed("该品牌全名已存在,请选择绑定已有品牌");
                }
            }
            //修改
            #region 验证品牌是否已关联用户
            if (query.ExistBrandId > 0)
            {
                var bmodel = carrierModule.GetBrand(new RB_Brand_Extend { ID = query.ExistBrandId, MallBaseId = query.MallBaseId, TenantId = query.TenantId });
                if (bmodel.UserId > 0)
                {
                    return ApiResult.Failed("该品牌已被其他用户认证，请核实后再试");
                }
            }
            #endregion
            #endregion

            bool flag = carrierModule.SetBrandApplyFor(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 新增/修改载体申请信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCarrierApplyFor()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_CarrierApplyFor_Extend query = new RB_CarrierApplyFor_Extend()
            {
                ID=parms.GetInt("ID"),
                CompanyId=parms.GetInt("CompanyId"),
                ExistCarrierId=parms.GetInt("ExistCarrierId"),
                CarrierName=parms.GetStringValue("CarrierName"),
                Logo=parms.GetStringValue("Logo"),
                BannerList=new List<string> (),
                VideoUrl=parms.GetStringValue("VideoUrl"),
                Address=parms.GetStringValue("Address"),
                LatAndLon=parms.GetStringValue("LatAndLon"),
                Developers=parms.GetStringValue("Developers"),
                OpenTime=parms.GetDateTime("OpenTime"),
                ProjectType=(ProjectTypeEnum)parms.GetInt("ProjectType"),
                CarrierSize=parms.GetDecimal("CarrierSize"),
                LayersNum=parms.GetStringValue("LayersNum"),
                CarNum=parms.GetInt("CarNum"),
                CarrierPlan=parms.GetStringValue("CarrierPlan"),
                CarrierTarget=parms.GetStringValue("CarrierTarget"),
                Location=parms.GetStringValue("Location"),
                Crowd=parms.GetStringValue("Crowd"),
                CarrierMetroList=new List<RB_CarrierMetroApplyFor_Extend> (),
                FirstShopNumList=new List<FirstShopNumModel> (),
                HonorList=new List<string> (),
                Discount=parms.GetStringValue("Discount"),
                StartingInfo=parms.GetStringValue("StartingInfo"),
                ShopNum=parms.GetInt("ShopNum"),
                BuiltUpArea=parms.GetDecimal("BuiltUpArea"),
                AreaRequirement=parms.GetDecimal("AreaRequirement"),
                YeJi=parms.GetDecimal("YeJi"),
                //FirstShow = parms.GetStringValue("FirstShow"),
                //FirstExhibition =
            };
            var bannerList = parms.GetStringValue("BannerList");
            if (!string.IsNullOrEmpty(bannerList))
            {
                query.BannerList = JsonHelper.DeserializeObject<List<string>>(bannerList);
            }
            var carrierMetroList = parms.GetStringValue("CarrierMetroList");
            if (!string.IsNullOrEmpty(carrierMetroList))
            {
                query.CarrierMetroList = JsonHelper.DeserializeObject<List<RB_CarrierMetroApplyFor_Extend>>(carrierMetroList);
            }
            var firstShopNumList = parms.GetStringValue("FirstShopNumList");
            if (!string.IsNullOrEmpty(firstShopNumList))
            {
                query.FirstShopNumList = JsonHelper.DeserializeObject<List<FirstShopNumModel>>(firstShopNumList);
            }
            var honorList = parms.GetStringValue("HonorList");
            if (!string.IsNullOrEmpty(honorList))
            {
                query.HonorList = JsonHelper.DeserializeObject<List<string>>(honorList);
            }

            if (query.CompanyId <= 0)
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            if (string.IsNullOrWhiteSpace(query.CarrierName))
            {
                return ApiResult.Failed("请输入载体名称");
            }
            if (string.IsNullOrWhiteSpace(query.Developers))
            {
                return ApiResult.Failed("请输入开发商");
            }
            if (string.IsNullOrWhiteSpace(query.Address))
            {
                return ApiResult.Failed("请输入项目地址");
            }
            if (!query.ShopNum.HasValue)
            {
                return ApiResult.Failed("请输入店铺数量");
            }
            if (!query.BuiltUpArea.HasValue)
            {
                return ApiResult.Failed("请输入经营面积");
            }
            if (!query.AreaRequirement.HasValue)
            {
                return ApiResult.Failed("请输入可租赁面积");
            }
            if (string.IsNullOrWhiteSpace(query.Logo))
            {
                return ApiResult.Failed("请上传Logo");
            }
            if (query.BannerList == null || !query.BannerList.Any())
            {
                return ApiResult.Failed("请上传介绍图");
            }
            if (!query.OpenTime.HasValue)
            {
                return ApiResult.Failed("请输入开业时间");
            }
            if (!query.ProjectType.HasValue)
            {
                return ApiResult.Failed("请选择项目类型");
            }
            if (query.BannerList != null && query.BannerList.Any())
            {
                query.Banner = JsonConvert.SerializeObject(query.BannerList);
            }
            else
            {
                query.Banner = "";
            }
            if (query.HonorList != null && query.HonorList.Any())
            {
                query.Honor = JsonConvert.SerializeObject(query.HonorList);
            }
            else
            {
                query.Honor = "";
            }
            if (query.FirstShopNumList != null && query.FirstShopNumList.Any())
            {
                query.FirstShopNum = JsonConvert.SerializeObject(query.FirstShopNumList);
            }
            else
            {
                query.FirstShopNum = "";
            }
            query.ShopNum = query.ShopNum ?? 0;
            query.BuiltUpArea = query.BuiltUpArea ?? 0;
            query.EndBuiltUpArea = query.EndBuiltUpArea ?? 0;
            query.AreaRequirement = query.AreaRequirement ?? 0;
            query.EndAreaRequirement = query.EndAreaRequirement ?? 0;
            query.YeJi = query.YeJi ?? 0;
            query.CreateDate = DateTime.Now;
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            query.UpdateDate = DateTime.Now;

            #region 验证品牌名称是否已经存在了
            if (query.ExistCarrierId == 0)
            {
                if (carrierModule.ValidateCarrierName(query.CarrierName, userInfo.MallBaseId))
                {
                    return ApiResult.Failed("该载体名称已存在,请选择绑定已有载体");
                }
            }

            //修改
            #region 验证品牌是否已关联用户
            if (query.ExistCarrierId > 0)
            {
                var carrmodel = carrierModule.GetCarrierModel(new RB_Carrier_Extend { ID = query.ExistCarrierId, TenantId = query.TenantId, MallBaseId = query.MallBaseId });
                if (carrmodel.UserId > 0)
                {
                    return ApiResult.Failed("该载体已被其他用户认证，请核实后再试");
                }
            }
            #endregion
            #endregion

            bool flag = carrierModule.SetCarrierApplyFor(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 修改品牌
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetBrandUpdate()
        {
            var userInfo = AppletUserInfo;
            RB_Brand_Extend query = JsonConvert.DeserializeObject<RB_Brand_Extend>(RequestParm.msg.ToString());
            if (query.ID <= 0)
            {
                return ApiResult.ParamIsNull("请传递品牌id");
            }
            if (string.IsNullOrWhiteSpace(query.BrandName))
            {
                return ApiResult.Failed("请输入品牌名称");
            }
            if (string.IsNullOrWhiteSpace(query.Logo))
            {
                return ApiResult.Failed("请上传Logo");
            }
            if (query.BrandClassId == 0)
            {
                return ApiResult.Failed("请选择品牌分类");
            }
            if (query.BannerList != null && query.BannerList.Any())
            {
                query.Banner = JsonConvert.SerializeObject(query.BannerList);
            }
            else
            {
                query.Banner = "";
            }
            query.CreateDate = System.DateTime.Now;
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            query.Status = 0;
            query.UpdateDate = System.DateTime.Now;
            query.CreateBy = userInfo.UserId;

            var oldModel = carrierModule.GetBrand(new RB_Brand_Extend() { ID = query.ID });
            if (oldModel == null) { return ApiResult.Failed("品牌不存在"); }
            if (oldModel.UserId != userInfo.UserId) { return ApiResult.Failed("无法修改此品牌"); }

            bool flag = carrierModule.SetBrand(query);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 修改载体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCarrierUpdate()
        {
            var userInfo = AppletUserInfo;
            RB_Carrier_Extend query = JsonConvert.DeserializeObject<RB_Carrier_Extend>(RequestParm.msg.ToString());
            if (query.ID <= 0)
            {
                return ApiResult.ParamIsNull("请传递载体id");
            }
            if (string.IsNullOrWhiteSpace(query.CarrierName))
            {
                return ApiResult.Failed("请输入载体名称");
            }
            if (string.IsNullOrWhiteSpace(query.Developers))
            {
                return ApiResult.Failed("请输入开发商");
            }
            if (string.IsNullOrWhiteSpace(query.Address))
            {
                return ApiResult.Failed("请输入项目地址");
            }
            if (!query.ShopNum.HasValue)
            {
                return ApiResult.Failed("请输入店铺数量");
            }
            if (!query.BuiltUpArea.HasValue)
            {
                return ApiResult.Failed("请输入经营面积");
            }
            if (!query.AreaRequirement.HasValue)
            {
                return ApiResult.Failed("请输入可租赁面积");
            }

            if (string.IsNullOrWhiteSpace(query.Logo))
            {
                return ApiResult.Failed("请上传Logo");
            }
            if (query.BannerList == null || !query.BannerList.Any())
            {
                return ApiResult.Failed("请上传介绍图");
            }
            if (!query.OpenTime.HasValue)
            {
                return ApiResult.Failed("请输入开业时间");
            }
            if (!query.ProjectType.HasValue)
            {
                return ApiResult.Failed("请选择项目类型");
            }
            if (query.BannerList != null && query.BannerList.Any())
            {
                query.Banner = JsonConvert.SerializeObject(query.BannerList);
            }
            else
            {
                query.Banner = "";
            }
            query.CreateDate = DateTime.Now;
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            query.UpdateDate = DateTime.Now;
            query.ShopNum = query.ShopNum ?? 0;
            query.BuiltUpArea = query.BuiltUpArea ?? 0;
            query.EndBuiltUpArea = query.EndBuiltUpArea ?? 0;
            query.AreaRequirement = query.AreaRequirement ?? 0;
            query.EndAreaRequirement = query.EndAreaRequirement ?? 0;
            query.YeJi = query.YeJi ?? 0;
            var oldModel = carrierModule.GetCarrierModel(new RB_Carrier_Extend() { ID = query.ID });
            if (oldModel == null) { return ApiResult.Failed("载体不存在"); }
            if (oldModel.UserId != userInfo.UserId) { return ApiResult.Failed("无法修改此载体"); }


            if (!string.IsNullOrWhiteSpace(query.StartingInfo))
            {
                query.FirstStoreTest = 1;
            }
            else {
                query.FirstStoreTest = 0;
            }

            if (query.OpenTime.HasValue)
            {
                if (query.OpenTime.Value <= System.DateTime.Now)
                {
                    query.OpeningStatus = 1;
                }
                else
                {
                    query.OpeningStatus = 0;
                }
            }
            else {
                query.OpeningStatus = 0;
            }
            bool flag = carrierModule.SetCarrier(query);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 设置认证为待完善
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCommpanyCompleteCorvidae()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int CompanyId = parms.GetInt("CompanyId", 0);
            if (CompanyId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            string msg = companyModule.SetCommpanyCompleteCorvidae(CompanyId, userInfo.UserId);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 获取认证品牌列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCenterBrandList()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Brand_Extend()
            {
                BrandName = parms.GetStringValue("BrandName"),
                UserId = -1//查询未绑定用户的
            };
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            var list = carrierModule.GetBrandList_V2(query);
            foreach (var item in list)
            {
                item.ProjectName = item.ProjectType.GetEnumName();
                if (!string.IsNullOrWhiteSpace(item.Banner))
                {
                    item.BannerList = JsonConvert.DeserializeObject<List<string>>(item.Banner);
                }
                else
                {
                    item.BannerList = new List<string>();
                }
            }
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取品牌分类实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetBrandDetailsForCompany()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Brand_Extend()
            {
                ID = parms.GetInt("ID", 0),

            };
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            query.RanQi = -1;
            query.KongTiao = -1;
            query.XinFeng = -1;
            query.Plumbing = -1;
            query.Caliber = -1;
            query.PaiYan = -1;
            query.Sewage = -1;
            var extModel = carrierModule.GetBrand(query);

            if (!string.IsNullOrWhiteSpace(extModel.Banner))
            {
                extModel.BannerList = JsonConvert.DeserializeObject<List<string>>(extModel.Banner);
            }
            else
            {
                extModel.BannerList = new List<string>();
            }
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 获取认证载体列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetCenterCarrierList()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Carrier_Extend()
            {
                CarrierName = parms.GetStringValue("CarrierName"),
                UserId = -1//查询未绑定用户的
            };
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            var list = carrierModule.GetCarrierList(query);

            return ApiResult.Success(data: list.Select(x => new
            {
                x.ID,
                x.CarrierName,
                x.Logo,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                x.Address,
                x.LatAndLon,
                x.Developers,
                OpenTime = x.OpenTime.HasValue ? x.OpenTime.Value.ToString("yyyy-MM-dd HH:mm") : "",
                x.ProjectType,
                ProjectTypeName = x.ProjectType.GetEnumName(),
                x.CarrierSize,
                x.LayersNum,
                x.CarNum,
                x.CarrierPlan,
                x.CarrierTarget,
                x.Location,
                x.Crowd,
                x.VideoUrl,
                x.CarrierMetroList
            }));
        }

        /// <summary>
        /// 获取载体实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCarrierDetailsForCompany()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Carrier_Extend()
            {
                ID = parms.GetInt("ID", 0),
            };
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            var extModel = carrierModule.GetCarrierModel(query);
            return ApiResult.Success(data: extModel);
        }

        #endregion

        #region 新闻管理

        /// <summary>
        /// 获取新闻前几条
        /// </summary>
        /// <returns></returns>
        public ApiResult GetNewsPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_News_Extend()
            {
                Title = parms.GetStringValue("Title"),
                Type = parms.GetInt("Type")
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            var list = commerceNewsModule.GetCommerceNewsPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取新闻信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceNews()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = commerceNewsModule.GetCommerceNewsModule(Id);
            return ApiResult.Success(data: extModel);
        }
        #endregion

        #region 投资采购管理

        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurementPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_InvestmentProcurement_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
                Type = parms.GetInt("Type"),
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            query.CreateBy = userInfo.UserId;
            var list = procurementModule.GetInvestmentProcurementPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改投资采购
        /// </summary>
        /// <returns></returns>
        public ApiResult SetInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_InvestmentProcurement_Extend()
            {
                Id = parms.GetInt("Id"),
                Type = parms.GetInt("Type"),
                GoodsCategory = parms.GetStringValue("GoodsCategory"),
                Investment = parms.GetStringValue("Investment"),
                ImportNum = parms.GetInt("ImportNum"),
                Describe = parms.GetStringValue("Describe"),
                CompanyName = parms.GetStringValue("CompanyName"),
                CompanyEnName = parms.GetStringValue("CompanyEnName"),
                Mobile = parms.GetStringValue("Mobile"),
                EMail = parms.GetStringValue("EMail"),
                LegalPerson = parms.GetStringValue("LegalPerson"),
                Principal = parms.GetStringValue("Principal"),
                WechatNo = parms.GetStringValue("WechatNo"),
                DomainUrl = parms.GetStringValue("DomainUrl"),
                Industry = parms.GetStringValue("Industry"),
                FoundingTime = parms.GetDateTime("FoundingTime"),
                EmployeeNum = parms.GetInt("EmployeeNum"),
                AnnualSales = parms.GetDecimal("AnnualSales"),
                Address = parms.GetStringValue("Address"),
                EnAddress = parms.GetStringValue("EnAddress"),
                AnnualImport = parms.GetDecimal("AnnualImport"),
                ImportCategory = parms.GetStringValue("ImportCategory"),
                ImportCountry = parms.GetStringValue("ImportCountry"),
                ExportCountry = parms.GetStringValue("ExportCountry"),
                CompanyIntro = parms.GetStringValue("CompanyIntro"),
                OtherInfo = parms.GetStringValue("OtherInfo"),
            };
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            var userInfo = AppletUserInfo;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = userInfo?.TenantId ?? 0;
            extModel.CreateBy = userInfo?.UserId ?? 0;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = userInfo?.UserId ?? 0; ;
            extModel.UpdateDate = DateTime.Now;
            var flag = procurementModule.SetInvestmentProcurementModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取投资采购详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetInvestmentProcurement()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = procurementModule.GetInvestmentProcurementModule(Id);
            return ApiResult.Success(data: extModel);
        }

        #endregion

        #region Fat咨询管理

        /// <summary>
        /// 新增修改Fat咨询
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceAsk()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Ask_Extend()
            {
                Id = parms.GetInt("Id"),
                CompanyName = parms.GetStringValue("CompanyName"),
                Principal = parms.GetStringValue("Principal"),
                Mobile = parms.GetStringValue("Mobile"),
                EMail = parms.GetStringValue("EMail"),
                FatCode = parms.GetStringValue("FatCode"),
                FatTitle = parms.GetStringValue("FatTitle"),
                FatQuestion = parms.GetStringValue("FatQuestion"),
                FatContent = parms.GetStringValue("FatContent")
            };
            var userInfo = AppletUserInfo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = userInfo.MallBaseId;
            extModel.TenantId = userInfo.TenantId;
            Int32.TryParse(userInfo.UserId.ToString(), out int Uid);
            extModel.CreateBy = Uid;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateBy = Uid;
            extModel.UpdateDate = DateTime.Now;
            var flag = askModule.SetCommerceAskModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取投资采购分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAskPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Ask_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            query.CreateBy = userInfo.UserId;
            var list = askModule.GetCommerceAskPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取咨询详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetCommerceAsk()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = askModule.GetCommerceAskModule(Id);
            return ApiResult.Success(data: extModel);
        }
        #endregion

        #region 活动管理

        /// <summary>
        /// 获取商会活动类型列表
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        public ApiResult GetCommerceActivityTypeList()
        {
            var query = new RB_Commerce_ActivityType_Extend();
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            var list = activityModule.GetCommerceActivityTypeListModule(query);
            return ApiResult.Success(data: list.Select(qitem => new { qitem.Id, qitem.CoverImage, qitem.TypeName, LableNameList = string.IsNullOrWhiteSpace(qitem.LableName) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(qitem.LableName) }));
        }

        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        public ApiResult GetCommerceActivityPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Commerce_Activity_Extend()
            {
                ActivityType = jObj.GetInt("ActivityType")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            var list = activityModule.GetCommerceActivityPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }


        /// <summary>
        /// 获取商会活动详情
        /// </summary>
        /// <returns></returns>
        [AllowAnonymous]
        public ApiResult GetCommerceActivity()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            var extModel = activityModule.GetCommerceActivityModule(Id);
            var userInfo = AppletUserInfo;
            if (extModel != null && extModel.CreateBy > 0)
            {
                extModel.CreateByName = UserReidsCache.GetUserLoginInfo(extModel.CreateBy)?.Name ?? "";
                extModel.IsJoinActivity = 0;
                if (userInfo == null)
                {
                    userInfo = new AppletUserInfo
                    {
                        UserId = RequestParm.UserId,
                        MallBaseId = RequestParm.MallBaseId,
                        TenantId = RequestParm.TenantId
                    };
                }
                if (userInfo != null && userInfo.UserId > 0)
                {
                    var list = consultModule.GetCommerceConsultListModule(new RB_Commerce_Consult_Extend() { ActivityId = Id, UserId = userInfo.UserId });
                    if (list != null && list.Count > 0)
                    {
                        extModel.IsJoinActivity = 1;
                    }
                    else
                    {
                        extModel.IsJoinActivity = 0;
                    }
                    extModel.CommerceConsultList = list ?? new List<RB_Commerce_Consult_Extend>();
                }
            }
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 根据编号删除用户报名
        /// </summary>
        /// <returns></returns>
        public ApiResult DeleteTrdceConsult()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id", 0);
            bool flag = consultModule.RemoveTrdceConsultModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        /// <summary>
        /// 新增修改首店报名
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTradeConsult()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_Commerce_Consult_Extend model = new RB_Commerce_Consult_Extend()
            {
                Id = parms.GetInt("Id", 0),
                ActivityId = parms.GetInt("ActivityId"),
                LinkMan = parms.GetStringValue("LinkMan"),
                LinkTel = parms.GetStringValue("LinkTel"),
                Post = parms.GetStringValue("Post"),
                CountryInfo = parms.GetStringValue("CountryInfo"),
            };
            var userInfo = AppletUserInfo;
            if (userInfo == null)
            {
                userInfo = new AppletUserInfo
                {
                    UserId = RequestParm.UserId,
                    MallBaseId = RequestParm.MallBaseId,
                    TenantId = RequestParm.TenantId
                };
            }
            model.Status = Common.Enum.DateStateEnum.Normal;
            model.PeopleNum = 1;
            model.UserId = userInfo.UserId;
            model.TenantId = userInfo.TenantId;
            model.MallBaseId = userInfo.MallBaseId;
            model.CreateTime = DateTime.Now;
            bool flag = consultModule.SetTradeConsultModule(model);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }



        /// <summary>
        /// 获取当前用户参加的活动
        /// </summary>
        /// <returns></returns>
        public ApiResult GetUserActivityPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            var query = new RB_Commerce_Activity_Extend()
            {
            };
            var userInfo = AppletUserInfo;
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            query.CreateBy = userInfo.UserId;
            var list = activityModule.GetUserCommerceActivityPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取活动报名列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserJoinActivityPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Commerce_Consult_Extend dmodel = JsonConvert.DeserializeObject<RB_Commerce_Consult_Extend>(RequestParm.msg.ToString());
            var userInfo = AppletUserInfo;
            dmodel.MallBaseId = RequestParm.MallBaseId;
            dmodel.TenantId = userInfo?.TenantId ?? 0;
            dmodel.UserId = userInfo.UserId;
            var list = consultModule.GetUserJoinActivityPageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, dmodel);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.ActivityId,
                x.UserId,
                x.LinkMan,
                x.LinkTel,
                CreateTime = x.CreateTime.ToString("yyyy-MM-dd HH:mm:ss"),
                x.Status,
                x.PeopleNum,
                x.Money,
                x.Remark,
                x.IsApplyForCancel,
                x.CancelRemark,
                x.ApplyForCancelStatus,
                x.RejectRemark,
                x.ActivityName,
                x.CoverImg,
                StartTime = x.StartTime.HasValue ? x.StartTime.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                EndTime = x.EndTime.HasValue ? x.EndTime.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                x.TypeName
            });
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 新增修改商会活动报名
        /// </summary>
        /// <returns></returns>
        public ApiResult SetCommerceConsult()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Consult_Extend()
            {
                Id = jObj.GetInt("Id"),
                ActivityId = jObj.GetInt("ActivityId"),
                UserId = jObj.GetInt("UserId"),
                LinkMan = jObj.GetStringValue("LinkMan"),
                LinkTel = jObj.GetStringValue("LinkTel"),
                PeopleNum = jObj.GetInt("PeopleNum", 0),
                UnitPrice = jObj.GetInt("UnitPrice", 0),
                Money = jObj.GetInt("Money", 0),
                Remark = jObj.GetStringValue("Remark"),
            };
            var userInfo = AppletUserInfo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = userInfo?.TenantId ?? 0;
            extModel.UserId = userInfo?.UserId ?? 0;
            extModel.CreateTime = DateTime.Now;
            string msg = consultModule.SetCommerceConsultModule(extModel);
            return msg == "" ? ApiResult.Success() : ApiResult.Failed(msg);
        }





        #region 首店活动报名



        /// <summary>
        /// 获取性质枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetNatureEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.NatureEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 根据活动ids获取活动列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetActivityList()
        {
            var userInfo = AppletUserInfo;
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Activity_Extend()
            {
                ActivityIds = jObj.GetStringValue("ActivityIds"),
                MallBaseId = RequestParm.MallBaseId,
                TenantId = userInfo?.TenantId ?? 0
            };

            var list = activityModule.GetCommerceActivityListModule(extModel);
            return ApiResult.Success("", list);
        }


        /// <summary>
        /// 活动报名
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public ApiResult SetFirstShopActivityEnroll()
        {

            var request = RequestParm;
            var userInfo = AppletUserInfo;
            if (userInfo == null)
            {
                return ApiResult.Failed("请登录");
            }
            Model.Extend.TradePavilion.FirstShopConsult firstShopModel = JsonConvert.DeserializeObject<Model.Extend.TradePavilion.FirstShopConsult>(request.msg.ToString());
            var activityList = activityModule.GetCommerceActivityListModule(new RB_Commerce_Activity_Extend { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId, ActivityIds = firstShopModel.ActivityIds });

            List<RB_Commerce_Consult_Extend> consultList = new List<RB_Commerce_Consult_Extend>();
            foreach (var model in activityList)
            {
                if (model == null || model.Status == Common.Enum.DateStateEnum.Delete) { return ApiResult.Failed(model.ActivityName + "活动不存在"); }
                if (model.SignStartTime >= DateTime.Now)
                {
                    return ApiResult.Failed("报名还未开始，无法报名");
                }
                if (model.SignEndTime <= DateTime.Now)
                {
                    return ApiResult.Failed("已过了报名时间，无法报名");
                }

                foreach (var item in firstShopModel.FirstShopLinkManList)
                {
                    RB_Commerce_Consult_Extend demodel = new RB_Commerce_Consult_Extend
                    {
                        ActivityName = model.ActivityName,
                        LinkMan = item.LinkMan,
                        LinkTel = item.LinkTel,
                        Post = item.Post,
                        CompanyName = firstShopModel.CompanyName,
                        ActivityIds = firstShopModel.ActivityIds,
                        CountryInfo = item.CountryInfo,
                        Nature = firstShopModel.Nature
                    };
                    demodel.ActivityId = model.Id;
                    demodel.Remark = firstShopModel.Remark;
                    demodel.UserId = userInfo.UserId;
                    demodel.Money = 0;
                    demodel.UnitPrice = 0;
                    demodel.MallBaseId = userInfo.MallBaseId;
                    demodel.TenantId = userInfo.TenantId;
                    demodel.Status = 0;
                    demodel.PeopleNum = 1;
                    demodel.CreateTime = System.DateTime.Now;
                    consultList.Add(demodel);
                }
            }
            bool flag = consultModule.SetBatchActivityEnrollInfo(consultList);
            return flag ? ApiResult.Success("报名成功") : ApiResult.Failed("出错了，请联系管理员");
        }

        /// <summary>
        /// 根据活动ids获取活动列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCommerceConsult()
        {
            var userInfo = AppletUserInfo;
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Consult_Extend()
            {
                ActivityId = jObj.GetInt("ActivityId"),
                MallBaseId = userInfo.MallBaseId,
                TenantId = userInfo.TenantId,
                UserId = userInfo.UserId
            };
            var list = consultModule.GetCommerceConsultListModule(extModel);
            return ApiResult.Success("", list);
        }


        #endregion

        /// <summary>
        /// 取消报名
        /// </summary>
        /// <returns></returns>
        public ApiResult CancelCommerceConsult()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var ActivityId = jObj.GetInt("ActivityId");
            string CancelRemark = jObj.GetStringValue("CancelRemark");
            var userInfo = AppletUserInfo;
            var flag = consultModule.CancelCommerceConsultModule(ActivityId, CancelRemark, out int IsCancelConfirm, userInfo.UserId);
            return flag ? ApiResult.Success("", IsCancelConfirm) : ApiResult.Failed();
        }

        /// <summary>
        /// 新增活动评论
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AddCommerceComment()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var extModel = new RB_Commerce_Comment_Extend()
            {
                Id = jObj.GetInt("Id"),
                ActivityId = jObj.GetInt("ActivityId"),
                CommentScore = jObj.GetInt("CommentScore"),
                CommentGrade = (GoodsCommentTypeEnum)jObj.GetInt("CommentGrade"),
                CommentImage = jObj.GetStringValue("CommentImage"),
                PlatformSource = (UserSourceEnum)jObj.GetInt("PlatformSource"),
                Content = jObj.GetStringValue("Content")
            };
            var userInfo = AppletUserInfo;
            extModel.UserName = userInfo.Name;
            extModel.UserPhoto = userInfo.Photo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = RequestParm.MallBaseId;
            extModel.TenantId = userInfo?.TenantId ?? 0;
            extModel.UserId = userInfo?.UserId ?? 0;
            extModel.CreateDate = DateTime.Now;
            extModel.UpdateDate = DateTime.Now;
            var flag = commerceCommentModule.SetCommerceCommentModule(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除评论
        /// </summary>
        /// <returns></returns>
        public ApiResult RemoveCommerceComment()
        {
            JObject jObj = JObject.Parse(RequestParm.msg.ToString());
            var Id = jObj.GetInt("Id");
            var flag = commerceCommentModule.RemoveCommerceCommentModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
        #endregion

        #region 认证申请

        /// <summary>
        /// 申请
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAuthenticationInfo()
        {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            RB_Authentication_Extend demodel = JsonConvert.DeserializeObject<RB_Authentication_Extend>(parms.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name))
            {
                return ApiResult.ParamIsNull("请传递首店名称");
            }
            if (string.IsNullOrEmpty(demodel.Address))
            {
                return ApiResult.ParamIsNull("请输入地址");
            }
            if (string.IsNullOrEmpty(demodel.Description))
            {
                return ApiResult.ParamIsNull("请输入简介");
            }
            if (string.IsNullOrEmpty(demodel.Contact))
            {
                return ApiResult.ParamIsNull("请输入联系人");
            }
            if (string.IsNullOrEmpty(demodel.ContactMobile))
            {
                return ApiResult.ParamIsNull("请输入联系电话");
            }
            if (demodel.ExistBrandId == 0)
            {
                return ApiResult.ParamIsNull("请选择您的品牌信息");
            }
            demodel.ImageList ??= new List<string>();
            demodel.Images = JsonConvert.SerializeObject(demodel.ImageList);
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.Status = 0;
            demodel.CreateBy = userInfo.UserId;
            demodel.CreateDate = DateTime.Now;
            demodel.AuditState = 1;
            bool flag = authenticationModule.SetActivityDiscussInfo(demodel);
            if (flag)
            {
                //获取订阅消息
                var miniModel = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId });

                List<string> template_message_list = new List<string>();

                if (miniModel != null)
                {
                    if (!string.IsNullOrWhiteSpace(miniModel.HatchExamineTpl))
                    {
                        template_message_list.Add(miniModel.HatchExamineTpl);
                    }
                }
                return ApiResult.Success("", template_message_list);
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 获取认证分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAuthenticationPageList()
        {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Authentication_Extend demodel = JsonConvert.DeserializeObject<RB_Authentication_Extend>(parms.msg.ToString());
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.CreateBy = userInfo.UserId;
            var list = authenticationModule.GetAuthenticationPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.CoverImage,
                x.ImageList,
                x.VideoUrl,
                x.Type,
                TypeName = x.Type.GetEnumName(),
                x.BrandType,
                BrandTypeName = x.BrandType.GetEnumName(),
                OpenTime = x.OpenTime.ToString("yyyy-MM-dd HH:mm"),
                x.Address,
                x.TradingArea,
                x.BusinessType,
                BusinessTypeName = x.BusinessType.GetEnumName(),
                x.BusinessDetail,
                x.Description,
                x.County,
                x.Category,
                CategoryName = x.Category.GetEnumName(),
                x.Contact,
                x.ContactMobile,
                x.AuditState,
                x.AuditRemark,
                AuditDate = x.AuditDate.HasValue ? x.AuditDate.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                x.ExistBrandId,
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取认证详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAuthenticationInfo()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int AuthenticationId = parms.GetInt("AuthenticationId", 0);
            if (AuthenticationId <= 0)
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            var model = authenticationModule.GetAuthenticationInfo(AuthenticationId);
            if (model == null) { return ApiResult.Failed("认证不存在"); }
            if (userInfo.UserId != model.CreateBy) { return ApiResult.Failed("无法查看"); }

            //获取品牌名称
            string brandName = "";
            if (model.ExistBrandId > 0)
            {
                var query = new RB_Brand_Extend()
                {
                    ID = model.ExistBrandId,

                };
                query.MallBaseId = userInfo.MallBaseId;
                query.TenantId = userInfo.TenantId;
                query.RanQi = -1;
                query.KongTiao = -1;
                query.XinFeng = -1;
                query.Plumbing = -1;
                query.Caliber = -1;
                query.PaiYan = -1;
                query.Sewage = -1;
                var extModel = carrierModule.GetBrand(query);
                if (extModel != null && extModel.ID > 0)
                {
                    brandName = extModel.BrandName;
                }
            }
            return ApiResult.Success("", new
            {
                model.Id,
                model.Name,
                model.CoverImage,
                model.ImageList,
                model.VideoUrl,
                model.Type,
                TypeName = model.Type.GetEnumName(),
                model.BrandType,
                BrandTypeName = model.BrandType.GetEnumName(),
                OpenTime = model.OpenTime.ToString("yyyy-MM-dd HH:mm"),
                model.Address,
                model.TradingArea,
                model.BusinessType,
                BusinessTypeName = model.BusinessType.GetEnumName(),
                model.BusinessDetail,
                model.Description,
                model.County,
                model.Category,
                CategoryName = model.Category.GetEnumName(),
                model.Contact,
                model.ContactMobile,
                model.AuditState,
                model.AuditRemark,
                AuditDate = model.AuditDate.HasValue ? model.AuditDate.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = model.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                model.ExistBrandId,
                BrandName = brandName
            });
        }

        /// <summary>
        /// 删除认证
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelAuthenticationInfo()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int AuthenticationId = parms.GetInt("AuthenticationId", 0);
            if (AuthenticationId <= 0)
            {
                return ApiResult.ParamIsNull("请传递认证id");
            }
            bool flag = authenticationModule.DelAuthenticationInfo(AuthenticationId, userInfo);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 获取认证分类枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetAuthenticationCategoryEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.AuthenticationCategoryEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取认证类型枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetAuthenticationTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.AuthenticationTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取品牌归属地枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetBrandTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.BrandTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取行业枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetBusinessTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.BusinessTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        #endregion

        #region 载体管理

        /// <summary>
        /// 获取商会活动类型列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetCarrierPageList()
        {
            var userInfo = AppletUserInfo;
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Carrier_Extend()
            {
                MetroName = parms.GetStringValue("MetroName"),
                CarrierName = parms.GetStringValue("CarrierName"),
                MetroNum = parms.GetInt("MetroNum", 0),
                Developers = parms.GetStringValue("Developers"),
                StartOpenTime = parms.GetStringValue("StartOpenTime"),
                EndOpenTime = parms.GetStringValue("EndOpenTime"),
                ProjectType = (Common.Enum.TradePavilion.ProjectTypeEnum)parms.GetInt("ProjectType", 0),
                OrderBy = 1,
                OpeningStatus = parms.GetInt("OpeningStatus", -1),
                FirstStoreTest = parms.GetInt("FirstStoreTest", -1),
            };
            if (query.FirstStoreTest != 1)
            {
                query.FirstStoreTest = -1;
            }
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;

            var list = carrierModule.GetCarrierPageList(pageModel.pageIndex, pageModel.pageSize, out long count, query);
            List<RB_FirstShop_ListEnroll_Extend> listEnroll = new List<RB_FirstShop_ListEnroll_Extend>();
            if (list != null && list.Any())
            {
                string ids = string.Join(",", list.Select(x => x.ID));

                listEnroll = firstShopListModule.GetFirstShopListEnrollList(new RB_FirstShop_ListEnroll_Extend { MallBaseId = RequestParm.MallBaseId, TenantId = RequestParm.TenantId, ObjectType = Common.Enum.TradePavilion.ListObjectTypeEnum.Carrier, ObjectIds = ids, RankListState = 1 });

            }
            foreach (var item in list)
            {
                if (!string.IsNullOrWhiteSpace(item.Banner))
                {
                    item.BannerList = JsonConvert.DeserializeObject<List<string>>(item.Banner);
                }
                else
                {
                    item.BannerList = new List<string>();
                }
                item.ListEnroll = new List<RB_FirstShop_ListEnroll_Extend>();
                if (listEnroll != null && listEnroll.Any())
                {
                    item.ListEnroll = listEnroll.Where(x => x.ObjectId == item.ID).ToList();
                }
            }
            pageModel.count = Convert.ToInt32(count);
            pageModel.pageData = list.Select(x => new
            {
                x.ID,
                x.CarrierName,
                x.Logo,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                x.Address,
                x.LatAndLon,
                x.Developers,
                OpenTime = x.OpenTime.HasValue ? x.OpenTime.Value.ToString("yyyy-MM-dd HH:mm") : "",
                x.ProjectType,
                ProjectTypeName = x.ProjectType.GetEnumName(),
                x.CarrierSize,
                x.LayersNum,
                x.CarNum,
                x.CarrierPlan,
                x.CarrierTarget,
                x.Location,
                x.Crowd,
                x.VideoUrl,
                x.CarrierMetroList,
                x.BannerList,
                x.ListEnroll,
                x.OpeningStatus,
                x.FirstStoreTest
            });
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取载体实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetCarrierDetails()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Carrier_Extend()
            {
                ID = parms.GetInt("ID", 0),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = userInfo?.TenantId ?? 0;
            var extModel = carrierModule.GetCarrierModel(query);
            if (userInfo == null)
            {
                userInfo = new AppletUserInfo
                {
                    UserId = RequestParm.UserId,
                    MallBaseId = RequestParm.MallBaseId,
                    TenantId = RequestParm.TenantId
                };
            }
            if (userInfo.UserId > 0 && extModel.ID > 0)
            {                //判断是否已经关注过
                var collectModel = carrierModule.GetList(new RB_Collect_Extend { Status = 0, Type = 1, UserId = userInfo.UserId, SourceId = extModel.ID, MallBaseId = query.MallBaseId, TenantId = query.TenantId }).FirstOrDefault();
                extModel.CollectId = collectModel?.Id ?? 0;
            }

            List<RB_FirstShop_ListEnroll_Extend> listEnroll = firstShopListModule.GetFirstShopListEnrollList(new RB_FirstShop_ListEnroll_Extend { MallBaseId = RequestParm.MallBaseId, TenantId = RequestParm.TenantId, ObjectType = Common.Enum.TradePavilion.ListObjectTypeEnum.Carrier, ObjectId = extModel.ID, RankListState = 1 });


            return ApiResult.Success(data: new
            {
                extModel.ID,
                extModel.CarrierName,
                extModel.Logo,
                CreateDate = extModel.CreateDate.ToString("yyyy-MM-dd HH:mm"),
                extModel.Address,
                extModel.LatAndLon,
                extModel.Developers,
                OpenTime = extModel.OpenTime.HasValue ? extModel.OpenTime.Value.ToString("yyyy-MM-dd HH:mm") : "",
                extModel.ProjectType,
                ProjectTypeName = extModel.ProjectType.GetEnumName(),
                extModel.CarrierSize,
                extModel.LayersNum,
                extModel.CarNum,
                extModel.CarrierPlan,
                extModel.CarrierTarget,
                extModel.Location,
                extModel.Crowd,
                extModel.VideoUrl,
                extModel.CarrierMetroList,
                extModel.BannerList,
                extModel.CollectId,
                Discount = extModel.Discount ?? "",
                extModel.HonorList,
                extModel.YeJi,
                extModel.ShopNum,
                extModel.AreaRequirement,
                extModel.EndAreaRequirement,
                extModel.BuiltUpArea,
                extModel.EndBuiltUpArea,
                extModel.FirstShopNumList,
                StartingInfo = extModel.StartingInfo ?? "",
                listEnroll,
                extModel.OpeningStatus,
                extModel.FirstStoreTest
            });
        }

        #endregion

        #region 公司品牌
        /// <summary>
        /// 新增修改品牌信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetBrand()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            RB_CompanyBrand_Extend extModel = JsonConvert.DeserializeObject<RB_CompanyBrand_Extend>(RequestParm.msg.ToString());

            if (string.IsNullOrWhiteSpace(extModel.BrandName))
            {
                return ApiResult.Failed("品牌名称必填");
            }
            if (extModel.ShopNum == 0)
            {
                return ApiResult.Failed("店铺数量必须大于0");
            }
            if (extModel.BuiltUpArea == 0)
            {
                return ApiResult.Failed("店铺面积必填");
            }
            if (extModel.EndBuiltUpArea == 0)
            {
                return ApiResult.Failed("店铺面积必填");
            }
            if (string.IsNullOrWhiteSpace(extModel.FullBrandName))
            {
                return ApiResult.Failed("店铺定位必填");
            }
            if (string.IsNullOrWhiteSpace(extModel.CustomerType))
            {
                return ApiResult.Failed("请选择客户群体");
            }
            if (!string.IsNullOrWhiteSpace(extModel.CustomerType) && extModel.CustomerType.Split(",").ToList().Any(x => x.Contains("5")))
            {
                if (string.IsNullOrWhiteSpace(extModel.CustomerOtherType))
                {
                    return ApiResult.Failed("请输入客户群体");
                }
            }


            var userInfo = AppletUserInfo;
            extModel.Status = Common.Enum.DateStateEnum.Normal;
            extModel.MallBaseId = userInfo.MallBaseId;
            extModel.TenantId = userInfo.TenantId;
            var oldBrandModel = carrierModule.GetBrandRepository(new RB_CompanyBrand_Extend { MallBaseId = userInfo.MallBaseId, TenantId = userInfo.TenantId, CompanyId = extModel.CompanyId });
            if (oldBrandModel != null && oldBrandModel.ID > 0)
            {
                extModel.ID = oldBrandModel.ID;
            }
            var flag = carrierModule.SetCompanyBrand(extModel);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        /// <summary>
        /// 获取当前用户的公司品牌信息实体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetUserCompanyBrand()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var model = carrierModule.GetBrandRepository(new RB_CompanyBrand_Extend { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId, CompanyId = CompanyId });
            return ApiResult.Success(data: model);
        }


        /// <summary>
        /// 获取客户群体枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetCustomerTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.CustomerTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取商品性质枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetProjectTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.ProjectTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        #endregion


        #region 品牌
        /// <summary>
        /// 获取品牌分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetBrandPageList()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Brand_Extend()
            {
                BrandName = parms.GetStringValue("BrandName"),
                ProjectType = (Common.Enum.TradePavilion.ProjectTypeEnum)parms.GetInt("ProjectType", 0),
                BrandClassId = parms.GetInt("BrandClassId", 0),
                RanQi = parms.GetInt("RanQi", -1),
                KongTiao = parms.GetInt("KongTiao", -1),
                XinFeng = parms.GetInt("XinFeng", -1),
                Plumbing = parms.GetInt("Plumbing", -1),
                Caliber = parms.GetInt("Caliber", -1),
                Sewage = parms.GetInt("Sewage", -1),
                PaiYan = parms.GetInt("PaiYan", -1),
                DianLiang = parms.GetStringValue("DianLiang"),
                PrizeId = parms.GetInt("PrizeId", 0),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = carrierModule.GetBrandPageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            List<RB_FirstShop_ListEnroll_Extend> listEnroll = new List<RB_FirstShop_ListEnroll_Extend>();
            if (list != null && list.Any())
            {
                string ids = string.Join(",", list.Select(x => x.ID));

                listEnroll = firstShopListModule.GetFirstShopListEnrollList(new RB_FirstShop_ListEnroll_Extend { MallBaseId = RequestParm.MallBaseId, TenantId = RequestParm.TenantId, ObjectType = Common.Enum.TradePavilion.ListObjectTypeEnum.Brand, ObjectIds = ids, RankListState = 1 });

            }
            foreach (var item in list)
            {
                if (!string.IsNullOrWhiteSpace(item.Banner))
                {
                    item.BannerList = JsonConvert.DeserializeObject<List<string>>(item.Banner);
                }
                else
                {
                    item.BannerList = new List<string>();
                }
                item.ListEnroll = new List<RB_FirstShop_ListEnroll_Extend>();
                if (listEnroll != null && listEnroll.Any())
                {
                    item.ListEnroll = listEnroll.Where(x => x.ObjectId == item.ID).ToList();
                }
            }
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }



        /// <summary>
        /// 获取品牌实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetBrandDetails()
        {
            var req = RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            var query = new RB_Brand_Extend()
            {
                ID = parms.GetInt("ID", 0),

            };
            query.MallBaseId = req.MallBaseId;
            query.TenantId = req.TenantId;
            query.RanQi = -1;
            query.KongTiao = -1;
            query.XinFeng = -1;
            query.Plumbing = -1;
            query.Caliber = -1;
            query.PaiYan = -1;
            query.Sewage = -1;
            var extModel = carrierModule.GetBrand(query);

            if (!string.IsNullOrWhiteSpace(extModel.Banner))
            {
                extModel.BannerList = JsonConvert.DeserializeObject<List<string>>(extModel.Banner);
            }
            else
            {
                extModel.BannerList = new List<string>();
            }

            extModel.ProjectName = extModel.ProjectType.GetEnumName();
            if (req.UserId > 0 && extModel.ID > 0)
            {                //判断是否已经关注过
                var collectModel = carrierModule.GetList(new RB_Collect_Extend { Status = 0, Type = 2, UserId = req.UserId, SourceId = extModel.ID, MallBaseId = query.MallBaseId, TenantId = query.TenantId }).FirstOrDefault();
                extModel.CollectId = collectModel?.Id ?? 0;
            }
            if (extModel.UserId > 0)
            {
                //获取首店年份
                extModel.FirstShopYear = authenticationModule.GetFirstShopYear(extModel.UserId, req.MallBaseId);
                if (req.UserId > 0)
                {
                    //获取心愿单
                    var companyModel = companyModule.GetCompanyByUserIdModule(req.UserId);
                    if ((companyModel?.FirstShopType == 2 && companyModel?.CompanyStatus == 1) || req.UserId == extModel.UserId)
                    {
                        //载体方  并且认证OK
                        var wmodel = firstShopWishModule.GetWishList(new RB_FirstShop_Wish_Extend() { MallBaseId = req.MallBaseId, UserId = extModel.UserId }).FirstOrDefault();
                        if (wmodel != null)
                        {
                            extModel.WishDescription = wmodel.Description;
                            extModel.WishCard = wmodel.NameCard;
                        }
                    }
                }
            }
            extModel.ListEnroll = firstShopListModule.GetFirstShopListEnrollList(new RB_FirstShop_ListEnroll_Extend { MallBaseId = RequestParm.MallBaseId, TenantId = RequestParm.TenantId, ObjectType = Common.Enum.TradePavilion.ListObjectTypeEnum.Brand, ObjectId = extModel.ID, RankListState = 1 });
            if (!string.IsNullOrWhiteSpace(extModel.SourceIds))
            {
                extModel.PrizeList = carrierModule.GetPrizeList(new RB_Prize_Extend { MallBaseId = RequestParm.MallBaseId, TenantId = RequestParm.TenantId, QPrizeIds = extModel.SourceIds });
            }
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 获取品牌分类分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetBrandClassList()
        {
            var query = new RB_BrandClass_Extend
            {
                MallBaseId = RequestParm.MallBaseId,
                TenantId = RequestParm.TenantId
            };
            var list = carrierModule.GetBrandClassList(query);
            return ApiResult.Success(data: list);
        }

        #region 奖章
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetPrizePageList()
        {

            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Prize_Extend()
            {
                Name = parms.GetStringValue("Name"),
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = carrierModule.GetPrizeList(query);
            var result = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.BigIco,
                x.SmallIco,
                x.TotalCount,
                x.YearInfo
            });
            return ApiResult.Success(data: result);
        }

        #endregion

        #region 获取我绑定的品牌
        /// <summary>
        /// 获取品牌分类实体
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public ApiResult GetMyBrandList()
        {
            var userInfo = base.AppletUserInfo;
            var query = new RB_Brand_Extend
            {
                MallBaseId = userInfo.MallBaseId,
                TenantId = userInfo.TenantId,
                RanQi = -1,
                KongTiao = -1,
                XinFeng = -1,
                Plumbing = -1,
                Caliber = -1,
                PaiYan = -1,
                Sewage = -1,
                UserId = userInfo.UserId
            };
            var extList = carrierModule.GetBrandListByWhere(query);
            return ApiResult.Success(data: extList);
        }

        #endregion

        #endregion

        #region 关注
        /// <summary>
        /// 关注品牌/载体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCollect()
        {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            JObject jobj = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Collect_Extend()
            {
                Id = jobj.GetInt("Id"),
                Type = jobj.GetInt("Type"),
                SourceId = jobj.GetInt("SourceId"),
            };
            query.TenantId = userInfo.TenantId;
            query.MallBaseId = userInfo.MallBaseId;
            query.UserId = userInfo.UserId;

            bool isUpdate = true;

            if (query == null)
            {
                return ApiResult.Failed("请传入我关注的信息");
            }
            else
            {

                //判断是否已经关注过
                var oldList = carrierModule.GetList(new RB_Collect_Extend { Status = -1, Type = query.Type, UserId = query.UserId, SourceId = query.SourceId, MallBaseId = query.MallBaseId, TenantId = query.TenantId }); ;
                if (query.Id == 0)
                {
                    isUpdate = false;
                    query.CreateDate = System.DateTime.Now;
                    if (query.SourceId <= 0)
                    {
                        return ApiResult.Failed("请传入我关注的信息");
                    }
                    if (query.Type <= 0)
                    {
                        return ApiResult.Failed("请传入我关注的类型");
                    }
                    if (oldList != null && oldList.Any(x => x.Status == 0))
                    {
                        return ApiResult.Failed("您已关注，请勿重复操作");
                    }
                    else
                    {
                        if (oldList != null && oldList.Any())
                        {
                            query.Id = oldList.OrderByDescending(x => x.CreateDate).FirstOrDefault().Id;
                        }
                        query.Status = 0;
                    }
                }
                else
                {
                    query.Status = 1;
                }

                bool result = carrierModule.AddOrUpdateCollect(query);
                if (isUpdate)
                {
                    if (result)
                    {
                        return ApiResult.Success("取消关注成功");
                    }
                    else
                    {
                        return ApiResult.Failed("取消关注成功");
                    }
                }
                else
                {
                    if (result)
                    {
                        return ApiResult.Success("关注成功");
                    }
                    else
                    {
                        return ApiResult.Failed("关注成功");
                    }
                }
            }
        }


        /// <summary>
        /// 我的收藏
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMyCollectPage()
        {
            var userInfo = AppletUserInfo;
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Collect_Extend()
            {

                Type = parms.GetInt("Type"),
                UserId = userInfo.UserId
            };
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            var list = carrierModule.GetPageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);

            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list.Select(x => new
            {

                x.Id,
                x.SourceId,
                x.Type,
                x.SourceName,
                x.SourceFullName,
                x.BannerList,
                x.Address,
                ProjectType = x.ProjectType.HasValue ? x.ProjectType.GetEnumName() : ""
            });
            return ApiResult.Success(data: pageModel);

        }
        #endregion


        #region 心愿单
        /// <summary>
        /// 获取我的心愿单分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMyWishPageList()
        {
            var userInfo = AppletUserInfo;
            var requst = RequestParm;
            ResultPageModel pageModel = JsonHelper.DeserializeObject<ResultPageModel>(requst.msg.ToString());
            RB_FirstShop_Wish_Extend demodel = JsonHelper.DeserializeObject<RB_FirstShop_Wish_Extend>(requst.msg.ToString());
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.TenantId = userInfo.TenantId;

            if (demodel.UserId <= 0)
            {
                return ApiResult.ParamIsNull("请传递用户id");
            }

            var list = firstShopWishModule.GetWishPageList(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, demodel);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.UserId,
                x.UserName,
                x.BranchName,
                x.CarrierName,
                x.Area,
                x.Description,
                x.NameCard,
                x.Status,
                UpdateDate = x.UpdateDate.ToString("yyyy-MM-dd HH:mm")
            });
            return ApiResult.Success("", pageModel);
        }

        /// <summary>
        /// 获取心愿单明细
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMyWishInfo()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            int WishId = parms.GetInt("WishId", 0);
            if (WishId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var model = firstShopWishModule.GetMyWishInfo(WishId);
            if (model == null || model.MallBaseId != userInfo.MallBaseId) { return ApiResult.Failed("未查询到相关心愿单"); }
            if (model.Status == 1) { return ApiResult.Failed(""); }

            return ApiResult.Success("", new
            {
                model.Id,
                model.UserId,
                model.UserName,
                model.BranchName,
                model.CarrierName,
                model.Area,
                model.Description,
                model.NameCard,
                UpdateDate = model.UpdateDate.ToString("yyyy-MM-dd HH:mm")
            });
        }

        /// <summary>
        /// 新增修改心愿单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMyWishInfo()
        {
            var userInfo = AppletUserInfo;
            RB_FirstShop_Wish_Extend demodel = JsonConvert.DeserializeObject<RB_FirstShop_Wish_Extend>(RequestParm.msg.ToString());

            if (string.IsNullOrEmpty(demodel.BranchName))
            {
                return ApiResult.ParamIsNull("请输入品牌名称");
            }
            if (string.IsNullOrEmpty(demodel.CarrierName))
            {
                return ApiResult.ParamIsNull("请输入对标载体名称");
            }
            if (string.IsNullOrEmpty(demodel.Area))
            {
                return ApiResult.ParamIsNull("请输入区域");
            }
            if (string.IsNullOrEmpty(demodel.Description))
            {
                return ApiResult.ParamIsNull("请输入心愿详情");
            }
            if (string.IsNullOrEmpty(demodel.NameCard))
            {
                return ApiResult.ParamIsNull("请上传名称");
            }

            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.Status = 0;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            demodel.UserId = userInfo.UserId;
            string msg = firstShopWishModule.SetMyWishInfo(demodel);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }
        #endregion

        #region 榜单管理

        /// <summary>
        /// 获取榜单分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetAppletFirstShopListPageList()
        {
            var req = base.RequestParm;
            ResultPageModel pageModel = JsonHelper.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_FirstShop_List_Extend demodel = JsonHelper.DeserializeObject<RB_FirstShop_List_Extend>(req.msg.ToString());
            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.IsAppletSelectNor = 1;
            demodel.OrderBy = 1;

            var list = firstShopListModule.GetAppletFirstShopListPageList(pageModel.pageIndex, pageModel.pageSize, out long count, demodel);
            pageModel.count = Convert.ToInt32(count);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.ListType,
                ListTypeName = x.ListType.GetEnumName(),
                x.ObjectTypeList,
                x.Sponsor,
                x.ListName,
                x.CoverImage,
                EndDate = x.EndDate.ToString("yyyy-MM-dd"),
                StartDate = x.StartDate.ToString("yyyy-MM-dd"),
                FinishDate = x.FinishDate.ToString("yyyy-MM-dd HH:mm"),
                x.PrizeNum,
                x.State
            });
            return ApiResult.Success("", pageModel);
        }

        /// <summary>
        /// 获取榜单详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletFistShopListInfo()
        {
            var userInfo = base.AppletUserInfo;
            var req = base.RequestParm;
            JObject parms = JObject.Parse(req.msg.ToString());
            int ListId = parms.GetInt("ListId", 0);//榜单id
            if (ListId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var model = firstShopListModule.GetAppletFirstShopListInfo(ListId, userInfo);
            if (model == null) { return ApiResult.Failed("榜单不存在"); }
            //获取订阅消息
            var miniModel = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId });
            List<string> template_message_list = new List<string>();
            if (miniModel != null)
            {
                if (!string.IsNullOrWhiteSpace(miniModel.ListPrizeTpl))
                {
                    template_message_list.Add(miniModel.ListPrizeTpl);
                }
            }
            return ApiResult.Success("", new
            {
                model.Id,
                model.ListType,
                model.ObjectTypeIds,
                model.Sponsor,
                model.ListName,
                model.CoverImage,
                EndDate = model.EndDate.ToString("yyyy-MM-dd"),
                StartDate = model.StartDate.ToString("yyyy-MM-dd"),
                FinishDate = model.FinishDate.ToString("yyyy-MM-dd HH:mm"),
                model.Content,
                model.EnableRank,
                model.PrizeNum,
                model.ListState,
                model.State,
                EnrollList = model.EnrollList?.Select(x => new
                {
                    x.Id,
                    x.UserId,
                    x.UserName,
                    x.ObjectType,
                    ObjectTypeName = x.ObjectType.GetEnumName(),
                    x.ObjectId,
                    x.ObjectName,
                    x.ObjectIcon,
                    x.Content
                }),
                RankList = model.RankList?.OrderBy(x => x.Rank).Select(x => new
                {
                    x.Id,
                    x.UserId,
                    x.UserName,
                    x.ObjectId,
                    x.ObjectType,
                    ObjectTypeName = x.ObjectType.GetEnumName(),
                    x.ObjectName,
                    x.ObjectIcon,
                    x.Reviews,
                    x.Rank,
                    x.MedalImage,
                    x.MedalImageBig
                }),
                template_message_list
            });
        }

        /// <summary>
        /// 获取我的可报名的品牌载体
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletMyBrandCarrierList()
        {
            var userInfo = base.AppletUserInfo;
            JObject parms = JObject.Parse(base.RequestParm.msg.ToString());
            int ListId = parms.GetInt("ListId", 0);//榜单id
            int EnrollId = parms.GetInt("EnrollId", 0);//报名Id
            if (ListId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var list = firstShopListModule.GetAppletMyBrandCarrierList(ListId, EnrollId, userInfo);
            return ApiResult.Success("", list);
        }

        /// <summary>
        /// 榜单报名
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetAppletFirstShopListInfo()
        {
            var userInfo = base.AppletUserInfo;
            RB_FirstShop_ListEnroll_Extend demodel = JsonHelper.DeserializeObject<RB_FirstShop_ListEnroll_Extend>(base.RequestParm.msg.ToString());
            if (demodel.ListId <= 0)
            {
                return ApiResult.ParamIsNull("请传递榜单id");
            }
            if (demodel.ObjectType <= 0)
            {
                return ApiResult.ParamIsNull("请传递类型");
            }
            if (demodel.ObjectId <= 0)
            {
                return ApiResult.ParamIsNull("请传递品牌载体id");
            }
            if (string.IsNullOrEmpty(demodel.Content))
            {
                return ApiResult.ParamIsNull("请传递表单内容");
            }

            demodel.UserId = userInfo.UserId;
            demodel.CandidateState = 1;
            demodel.RankListState = 2;
            demodel.Status = 0;
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;

            string msg = firstShopListModule.SetAppletFirstShopListInfo(demodel);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 取消报名
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult CancelAppletFirstShopListInfo()
        {
            JObject parms = JObject.Parse(base.RequestParm.msg.ToString());
            int EnrollId = parms.GetInt("EnrollId", 0);//报名Id
            if (EnrollId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            string msg = firstShopListModule.CancelAppletFirstShopListInfo(EnrollId);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 获取榜单类型枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetListTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.TradePavilion.ListTypeEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取我报名的榜单分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletMyEnrollFistShopListPageList()
        {
            var userInfo = base.AppletUserInfo;
            var req = base.RequestParm;
            ResultPageModel pageModel = JsonHelper.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_FirstShop_List_Extend demodel = JsonHelper.DeserializeObject<RB_FirstShop_List_Extend>(req.msg.ToString());
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.CreateBy = userInfo.UserId;

            var list = firstShopListModule.GetAppletMyEnrollFistShopListPageList(pageModel.pageIndex, pageModel.pageSize, out long count, demodel);
            pageModel.count = Convert.ToInt32(count);
            pageModel.pageData = list.Select(x => new
            {
                x.Id,
                x.ListType,
                ListTypeName = x.ListType.GetEnumName(),
                x.Sponsor,
                x.ListName,
                x.CoverImage,
                EndDate = x.EndDate.ToString("yyyy-MM-dd"),
                StartDate = x.StartDate.ToString("yyyy-MM-dd"),
                FinishDate = x.FinishDate.ToString("yyyy-MM-dd HH:mm"),
                x.PrizeNum,
                x.EnableRank,
                x.ListState,
                x.Rank,
                x.MedalImage,
                x.RankListState
            });
            return ApiResult.Success("", pageModel);
        }
        #endregion

        #region 公司信息(管理端)

        /// <summary>
        /// 获取公司信息分页列表
        /// </summary>
        /// <returns></returns>
        public ApiResult GetAdminCompanyPageList()
        {
            var userInfo = AppletUserInfo;
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Company_Extend()
            {
                CompanyName = parms.GetStringValue("CompanyName"),
                CompanyStatus = parms.GetInt("CompanyStatus", -1),
                IsComplete = 1//需是 已完善了资料的
            };
            query.MallBaseId = userInfo.MallBaseId;
            query.TenantId = userInfo.TenantId;
            var list = companyModule.GetCompanyPageListModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list;
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取公司信息详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetAdminCompany()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var extModel = companyModule.GetCompanyModule(CompanyId);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 审核公司信息
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateAdminCompanyStatus()
        {
            var userInfo = AppletUserInfo;
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var CompanyId = parms.GetInt("CompanyId", 0);
            var Status = parms.GetInt("CompanyStatus", 0);
            var Remark = parms.GetStringValue("Remark");//不通过备注
            var model = companyModule.GetCompanyEntity(CompanyId);
            if (model == null || model.CompanyId <= 0)
            {
                return ApiResult.Failed("公司信息不存在");
            }
            if (Status != 1 && Status != 2)
            {
                return ApiResult.Failed("状态有误");
            }
            if (Status == 2 && string.IsNullOrEmpty(Remark))
            {
                return ApiResult.ParamIsNull("请输入不通过的原因");
            }
            if (model.CompanyStatus == 1)
            {
                return ApiResult.Failed("公司信息已审核通过，请勿重复审核");
            }
            #region 验证登录用户具有审核权限
            var adminModel = userModule.GetMemberUserInfo(userInfo.UserId);
            if (adminModel == null) { return ApiResult.Failed("无权限审核"); }
            if (adminModel.IsAdmin != 1)
            {
                return ApiResult.Failed("不是管理员，无法操作");
            }
            #endregion

            var msg = companyModule.UpdateCompanyStatus(CompanyId, Status, Remark);
            if (msg == "" && Status > 0)//推送审核结果
            {
                //查询用户的信息
                var umodel = userModule.GetMemberUserInfo(model.CreateBy);
                if (umodel != null && !string.IsNullOrWhiteSpace(umodel.OpenId))
                {
                    DateTime dt1 = DateTime.Now;
                    List<string> openidList = new List<string>
                    {
                        umodel.OpenId
                    };
                    new Module.User.MiniProgramMsgModule().SendHatchExamineMsg(model.TenantId, model.MallBaseId, openidList, Status == 1 ? "认证通过" : "认证失败", "企业认证结果通知", System.DateTime.Now.ToString("yyyy年MM月dd日 HH:mm"));
                    DateTime dt2 = DateTime.Now;
                    LogHelper.Write("认证通知耗时：" + (dt2 - dt1).TotalSeconds);
                }
            }
            return msg == "" ? ApiResult.Success() : ApiResult.Failed(msg);
        }
        #endregion
    }
}
